/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.StreamFile;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.editor.IDocumentReceiver;
import miworkplace.ui.editor.debug.Option;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class StreamFileContentLoader
implements Runnable {
    private Debug logger = Debug.getInstance();
    @Inject
    private UISynchronize sync;
    @Inject
    private IConnection connection;
    @Inject
    private IConnectionUtilities fUtils;
    @Inject
    @Named(value="inputUri")
    private String inputUri;
    @Inject
    private IDocumentReceiver receiver;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    @Named(value="miworkplace.editor.readonly")
    private Boolean readOnly;

    @Override
    public void run() {
        String ifsPath = EditorInputUriUtil.getMemberPath((String)this.inputUri);
        StreamFile streamFile = (StreamFile)this.workspaceStore.get(this.connection, ifsPath);
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (Writer out = this.createWriter(streamFile);){
                this.logger.debug((miworkplace.common.debug.Option)Option.loading, "Loading " + ifsPath);
                StringBuilder sb = this.fUtils.loadIFSFile(this.connection, ifsPath, out);
                int x = sb.indexOf("\r\n");
                while (x > -1) {
                    sb.replace(x, x + 2, "\n");
                    x = sb.indexOf("\r\n", x);
                }
                Document document = new Document(sb.toString());
                this.receiver.receiveDocument((IDocument)document);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SecurityException e) {
            if (e.getCause() == null) {
                Notifier.error((String)Messages.editor_stmfloader_notify, (String)Messages.editor_stmfloader_nopermission);
            }
        }
        catch (IOException e) {
            this.logger.error("Could not read IFS file " + ifsPath + ". Error: " + e.getMessage(), (Throwable)e);
            this.sync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Notifier.error((String)Messages.editor_stmfloader_notify, (String)Messages.editor_stmfloader_error);
                }
            });
        }
    }

    private Writer createWriter(StreamFile streamFile) throws IOException {
        File f = streamFile.getLocalResource().getLocation().toFile();
        if (f.exists()) {
            f.delete();
        }
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        f.createNewFile();
        BufferedWriter out = new BufferedWriter(new FileWriter(f));
        return out;
    }
}

