/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import com.ibm.as400.access.AS400File;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.SequentialFile;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.MiWorkplaceTraceException;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.services.api.ILockService;
import miworkplace.ui.editor.ISourceCodeReceiver;
import miworkplace.ui.editor.SourceUtil;
import miworkplace.ui.editor.debug.Option;
import miworkplace.ui.editor.diff.Delta;
import miworkplace.ui.editor.diff.DiffUtils;
import miworkplace.ui.editor.diff.Patch;
import miworkplace.ui.editor.history.LocalHistoryPersistenceService;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;

public class SaveJob
extends Job {
    private Debug logger = Debug.getInstance();
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IConnection connection;
    @Inject
    private IConnectionUtilities connUtil;
    @Inject
    private ILockService lockService;
    @Inject
    @Named(value="memberPath")
    private String memberPath;
    @Inject
    @Named(value="sourceCode")
    private String text;
    @Inject
    @Named(value="sourceCodeLines")
    private Integer numberOfLines;
    @Inject
    private ISourceCodeReceiver sourceCodeReceiver;
    @Inject
    @Named(value="lineNumberIncrementation")
    private double lineNumberIncrementation;
    @Inject
    @Named(value="resequenceLineNumbers")
    private Boolean resequenceLineNumbers;
    @Inject
    @Named(value="recordLength")
    private Integer recordLength;
    @Inject
    private LocalHistoryPersistenceService localHistorySaver;
    @Inject
    @Preference(nodePath="miworkplace.application")
    protected IEclipsePreferences fApplicationPreferences;

    public SaveJob() {
        super(Messages.editor_save_mbr_title);
    }

    @PostConstruct
    public void postConstruct() {
        this.setName(String.format(Messages.editor_save_mbr_name, this.memberPath));
    }

    /*
     * Loose catch block
     */
    protected IStatus run(IProgressMonitor monitor) {
        boolean locked;
        block25: {
            SequentialFile file = new SequentialFile(this.connection.getSystem(), this.memberPath);
            monitor.beginTask(String.format(Messages.editor_save_mbr_task1, file.getMemberName()), 7);
            monitor.subTask(Messages.editor_save_mbr_task2);
            this.localHistorySaver.save(this.connection, this.memberPath, this.text);
            monitor.worked(1);
            if (!this.connection.isConnected()) {
                return this.errorStatus(new RuntimeException("The system seems to be offline", (Throwable)new MiWorkplaceTraceException()));
            }
            monitor.subTask("Processing locks");
            try {
                file.setRecordFormat();
            }
            catch (Exception e) {
                this.logger.error((miworkplace.common.debug.Option)Option.saving, Messages.editor_save_mbr_error_access, (Throwable)e);
                return this.errorStatus(new RuntimeException(Messages.editor_save_mbr_error_access, e));
            }
            boolean bl = locked = this.lockService.isLocked(this.connection, this.memberPath) != ILockService.LockStatus.OTHER;
            if (!locked) {
                try {
                    this.lockService.lockMember(this.connection, this.memberPath);
                }
                catch (Exception e) {
                    this.logger.error((miworkplace.common.debug.Option)Option.saving, Messages.editor_save_mbr_error_access, (Throwable)e);
                    return this.errorStatus(new RuntimeException(Messages.editor_save_mbr_error_lock, e));
                }
            }
            monitor.worked(1);
            monitor.subTask(Messages.editor_save_mbr_task3);
            monitor.worked(1);
            List<List<BigDecimal>> metadata = this.composeMetaData();
            monitor.subTask(Messages.editor_save_mbr_task4);
            monitor.worked(1);
            this.text = this.normalizeLineSeparators(this.text);
            String[] recs = this.text.split("\n");
            this.logger.debug((miworkplace.common.debug.Option)Option.saving, "Using line number incrementation value " + this.lineNumberIncrementation);
            Record[] records = this.sourceToRecordObjects(recs, this.recordLength, file.getRecordFormat(), metadata);
            monitor.worked(1);
            monitor.subTask(Messages.editor_save_mbr_task5);
            if (file.isOpen()) {
                this.logger.debug((miworkplace.common.debug.Option)Option.saving, "File is open. Closing file " + file.getPath());
                file.close();
            }
            monitor.subTask(Messages.editor_save_mbr_task6);
            monitor.worked(1);
            this.clearAndOpenForWrite((AS400File)file);
            if (!file.isWriteOnly()) {
                this.logger.debug((miworkplace.common.debug.Option)Option.saving, "File is open but not write only. Closing file " + file.getPath());
                file.close();
                this.logger.debug((miworkplace.common.debug.Option)Option.saving, "Closed " + file.getPath());
                file.open(2, 0, 3);
                this.logger.debug((miworkplace.common.debug.Option)Option.saving, "File is open but not write only. Opened as write only.");
            }
            if (file.isOpen()) {
                monitor.subTask(Messages.editor_save_mbr_task7);
                monitor.worked(1);
                file.write(records);
                file.close();
                this.sourceCodeReceiver.setSourceCode(records, this.recordLength);
                break block25;
            }
            this.logger.error((miworkplace.common.debug.Option)Option.saving, "Could not open file " + this.memberPath + " for saving.");
            IStatus iStatus = this.errorStatus((Exception)new CoreException((IStatus)new Status(4, "miworkplace.ui.editor", String.format(Messages.editor_save_mbr_error_open, this.memberPath))));
            try {
                if (locked) {
                    this.lockService.lockMember(this.connection, this.memberPath);
                }
            }
            catch (Exception inner) {
                this.logger.error(MessageFormat.format("Could not lock source {0}.", this.memberPath), (Throwable)inner);
            }
            return iStatus;
            catch (Exception e) {
                IStatus iStatus2;
                try {
                    this.logger.error("Could not save source " + this.memberPath + ".", (Throwable)e);
                    monitor.done();
                    iStatus2 = this.errorStatus(new RuntimeException(String.format(Messages.editor_save_mbr_error_save, this.memberPath)));
                }
                catch (Throwable throwable) {
                    try {
                        if (locked) {
                            this.lockService.lockMember(this.connection, this.memberPath);
                        }
                    }
                    catch (Exception inner) {
                        this.logger.error(MessageFormat.format("Could not lock source {0}.", this.memberPath), (Throwable)inner);
                    }
                    throw throwable;
                }
                try {
                    if (locked) {
                        this.lockService.lockMember(this.connection, this.memberPath);
                    }
                }
                catch (Exception inner) {
                    this.logger.error(MessageFormat.format("Could not lock source {0}.", this.memberPath), (Throwable)inner);
                }
                return iStatus2;
            }
        }
        try {
            if (locked) {
                this.lockService.lockMember(this.connection, this.memberPath);
            }
        }
        catch (Exception inner) {
            this.logger.error(MessageFormat.format("Could not lock source {0}.", this.memberPath), (Throwable)inner);
        }
        monitor.done();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("connection", this.connection.getName());
        map.put("memberPath", this.memberPath);
        map.put("org.eclipse.e4.data", this.memberPath);
        this.eventBroker.post("miworkplace/ui/editor/save/finished", map);
        return new Status(0, "miworkplace.ui.editor", String.format(Messages.editor_save_mbr_status_success, this.memberPath));
    }

    private void clearAndOpenForWrite(AS400File file) {
        if (!file.isOpen()) {
            try {
                this.lockService.releaseLock(this.connection, this.memberPath);
                file.open(2, 0, 3);
                file.close();
                this.lockService.lockMember(this.connection, this.memberPath);
                this.clearSource(this.connection, file);
                this.lockService.releaseLock(this.connection, this.memberPath);
                file.open(2, 0, 3);
            }
            catch (Exception e) {
                this.logger.error("PANIC! File was cleared but could not be opened for writing. Retry... " + file.getPath(), (Throwable)e);
            }
        }
    }

    private IStatus errorStatus(Exception pException) {
        return new Status(2, ((Object)((Object)this)).getClass(), pException.getMessage(), (Throwable)pException);
    }

    private String normalizeLineSeparators(String code) {
        StringBuilder sb = new StringBuilder(code);
        int x = sb.indexOf("\r\n");
        while (x > -1) {
            sb.replace(x, x + 2, "\n");
            x = sb.indexOf("\r\n", x);
        }
        return sb.toString();
    }

    private List<List<BigDecimal>> composeMetaData() throws Exception {
        ArrayList<List<BigDecimal>> metadata = new ArrayList<List<BigDecimal>>();
        List<String> oldList = this.recordsToList(this.sourceCodeReceiver.getSourceCode());
        List<String> newList = this.textToList(this.text);
        Patch patch = DiffUtils.diff(oldList, newList);
        List<BigDecimal> changeDates = this.composeChangeDates(patch);
        this.resequenceLineNumbers = true;
        List<BigDecimal> lineNumbers = this.composeLineNumbers(this.lineNumberIncrementation, this.resequenceLineNumbers, patch);
        metadata.add(changeDates);
        metadata.add(lineNumbers);
        return metadata;
    }

    private List<BigDecimal> composeLineNumbers(double lineNumberIncrementation, boolean resequence, Patch patch) throws Exception {
        ArrayList<BigDecimal> lineNumbers = new ArrayList<BigDecimal>(this.numberOfLines);
        if (resequence) {
            double lineNumber = 0.0;
            int i = 0;
            while (i < this.numberOfLines) {
                lineNumbers.add(new BigDecimal(lineNumber += lineNumberIncrementation).setScale(2, RoundingMode.HALF_UP));
                ++i;
            }
        }
        return lineNumbers;
    }

    private List<BigDecimal> composeChangeDates(Patch patch) throws Exception {
        BigDecimal currentDate = this.getDateAsDecimal(new Date());
        Record[] lastSourceCode = this.sourceCodeReceiver.getSourceCode();
        ArrayList<BigDecimal> changeDates = new ArrayList<BigDecimal>(this.numberOfLines);
        int lastSourceLinePosition = 0;
        for (Delta delta : patch.getDeltas()) {
            while (changeDates.size() < delta.getRevised().getPosition()) {
                if (lastSourceCode[lastSourceLinePosition].getFieldAsBytes(1)[0] == 64) {
                    changeDates.add(new BigDecimal(0));
                } else {
                    changeDates.add((BigDecimal)lastSourceCode[lastSourceLinePosition].getField(1));
                }
                ++lastSourceLinePosition;
            }
            int numberLinesDiff = delta.getRevised().size() - delta.getOriginal().size();
            switch (delta.getType()) {
                case INSERT: {
                    numberLinesDiff = delta.getRevised().size();
                    int i = 0;
                    while (i < delta.getRevised().size()) {
                        changeDates.add(currentDate);
                        ++i;
                    }
                    break;
                }
                case CHANGE: {
                    int i = 0;
                    while (i < delta.getRevised().size()) {
                        changeDates.add(currentDate);
                        ++i;
                    }
                    break;
                }
            }
            if (delta.getType() == Delta.TYPE.CHANGE) {
                lastSourceLinePosition += delta.getOriginal().size();
                continue;
            }
            if (numberLinesDiff == 0) {
                ++lastSourceLinePosition;
                continue;
            }
            if (numberLinesDiff >= 0) continue;
            lastSourceLinePosition += Math.abs(numberLinesDiff);
        }
        while (this.numberOfLines > changeDates.size()) {
            if (lastSourceCode.length >= lastSourceLinePosition + 1) {
                if (lastSourceCode[lastSourceLinePosition].getFieldAsBytes(1)[0] == 64) {
                    changeDates.add(new BigDecimal(0));
                } else {
                    changeDates.add((BigDecimal)lastSourceCode[lastSourceLinePosition].getField(1));
                }
                ++lastSourceLinePosition;
                continue;
            }
            changeDates.add(currentDate);
        }
        return changeDates;
    }

    private List<String> textToList(String text) {
        LinkedList<String> textList = new LinkedList<String>();
        String[] stringArray = text.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            textList.add(StringUtils.stripEnd((String)s, null));
            ++n2;
        }
        return textList;
    }

    private List<String> recordsToList(Record[] lastSources) throws UnsupportedEncodingException {
        LinkedList<String> textList = new LinkedList<String>();
        int i = 0;
        while (i < lastSources.length) {
            textList.add(StringUtils.stripEnd((String)(lastSources[i].getField(2).toString().replaceAll("\\s+$", "") + "\n"), null));
            ++i;
        }
        return textList;
    }

    public BigDecimal getDateAsDecimal(Date date) {
        SimpleDateFormat datfmt = new SimpleDateFormat("yyMMdd");
        return new BigDecimal(datfmt.format(date));
    }

    public Record[] sourceToRecordObjects(String[] sourceLines, int maxRecordLength, RecordFormat format, List<List<BigDecimal>> metadata) {
        boolean retain5250Colors = this.fApplicationPreferences.getBoolean("miworkplace.ui.editor.retain5250sourcecoloring", false);
        Record[] records = new Record[sourceLines.length];
        List<BigDecimal> changeDates = metadata.get(0);
        List<BigDecimal> lineNumbers = metadata.get(1);
        int i = 0;
        while (i < sourceLines.length) {
            records[i] = new Record(format);
            records[i].setField(0, (Object)lineNumbers.get(i).setScale(2, RoundingMode.HALF_UP));
            records[i].setField(1, (Object)changeDates.get(i));
            String line = sourceLines[i];
            if (retain5250Colors) {
                line = SourceUtil.convertToServer(sourceLines[i], format.getFieldDescription(2)).toString();
            }
            if (line.length() > maxRecordLength) {
                records[i].setField(2, (Object)line.substring(0, maxRecordLength));
            } else {
                records[i].setField(2, (Object)line);
            }
            ++i;
        }
        return records;
    }

    private void clearSource(IConnection connection, AS400File file) {
        this.logger.debug((miworkplace.common.debug.Option)Option.saving, "Clearing the source before writeback " + file.getPath());
        QSYSObjectPathName path = new QSYSObjectPathName(file.getPath());
        String clearMember = MessageFormat.format("CLRPFM {0}/{1} MBR({2})", path.getLibraryName().trim(), path.getObjectName().trim(), path.getMemberName().trim());
        this.connUtil.executeRemoteCommand(connection, clearMember);
        this.logger.debug((miworkplace.common.debug.Option)Option.saving, "Source clear returned without error " + file.getPath());
    }

    public boolean belongsTo(Object family) {
        if (this.connection.getName().equals(family) || this.connection.equals(family)) {
            return true;
        }
        String uri = this.connection.getName() + "://" + this.memberPath;
        return uri.equals(family);
    }
}

