/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import com.ibm.as400.access.Job;
import com.ibm.as400.access.Record;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.TextAttribute;
import miworkplace.common.progress.MiWJob;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.images.service.Factory;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.ILockService;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ITextAttributeService;
import miworkplace.services.api.ObjectProperty;
import miworkplace.ui.api.IPrintable;
import miworkplace.ui.api.IRemoteEditor;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.editor.CursorPositionChangedListener;
import miworkplace.ui.editor.DefaultSourceViewerConfiguration;
import miworkplace.ui.editor.FormatLine;
import miworkplace.ui.editor.FormatLineListener;
import miworkplace.ui.editor.FormatLineProvider;
import miworkplace.ui.editor.IDocumentReceiver;
import miworkplace.ui.editor.ISourceCodeReceiver;
import miworkplace.ui.editor.ISourceViewerExtension;
import miworkplace.ui.editor.IToggleBlockSupport;
import miworkplace.ui.editor.MemberRule;
import miworkplace.ui.editor.SaveJob;
import miworkplace.ui.editor.SourceContentLoader;
import miworkplace.ui.editor.composites.LoadingComposite;
import miworkplace.ui.editor.composites.OopsComposite;
import miworkplace.ui.editor.debug.Option;
import miworkplace.ui.themes.Colors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextOperationTargetExtension;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.json.JSONArray;
import org.json.JSONException;
import org.osgi.service.event.Event;

public class RemoteEditor
implements IRemoteEditor,
IDocumentReceiver,
ISourceCodeReceiver,
ISourceViewerExtension,
IAdaptable,
IPrintable,
IToggleBlockSupport {
    private static final String DEFAULT_MARGIN = "80";
    private static final String RESEQUENCE_LINE_NUMBERS = "resequenceLineNumbers";
    private static final String LINE_NUMBER_INCREMENTATION = "lineNumberIncrementation";
    private static final String SOURCE_CODE_LINES = "sourceCodeLines";
    private static final String SOURCE_CODE = "sourceCode";
    private static final String INPUT_URI = "inputUri";
    private static final String CONNECTION = "connection";
    private static final String MEMBER_PATH = "memberPath";
    private static final String RECORD_LENGTH = "recordLength";
    @Inject
    protected UISynchronize sync;
    @Inject
    protected IEventBroker eventBroker;
    @Inject
    protected IEclipseContext context;
    @Inject
    protected IConnectionUtilities connUtil;
    @Inject
    protected IConnectionManager connectionManager;
    @Inject
    protected Display display;
    @Inject
    protected ILockService lockService;
    protected Debug logger = Debug.getInstance();
    @Inject
    protected IWorkspaceStore workspaceStore;
    @Inject
    private IObjectPropertiesStore propertiesStore;
    @Inject
    protected EMenuService menuService;
    @Inject
    @Preference(nodePath="miworkplace.application")
    protected IEclipsePreferences applicationPreferences;
    protected ApplicationPreferenceChangeListener preferenceChangeListener;
    @Inject
    protected FormatLineProvider formatLineProvider;
    @Inject
    protected ITextAttributeService textAttributeService;
    @Inject
    protected IStylingEngine stylingEngine;
    @Inject
    private ESelectionService selectionService;
    @Inject
    private MPart part;
    private FormatLineListener formatLineListener;
    protected FormatLine formatLine;
    protected Record[] lastStoredSourceCode;
    protected int maxRecordLength;
    protected StackLayout stackLayout;
    protected Composite parentComposite;
    protected Composite defaultComposite;
    protected LoadingComposite loadingComposite;
    protected Composite statusNotExistComposite;
    protected Composite statusLockedComposite;
    protected FormToolkit statusLockedFormToolkit;
    private IResourcePool imagePool;
    private AnnotationPainter annotationPainter;
    protected AtomicBoolean loadingDocument = new AtomicBoolean(false);
    private SourceViewer viewer;
    private MarginPainter marginPainter;
    protected CompositeRuler compositeRuler;
    private LineNumberRulerColumn lineNumberRuler;
    private boolean overwriteMode = false;
    private EditModeListener editModeListener;
    private final boolean readOnly;
    protected final String inputUri;
    protected final String connectionName;
    protected final String memberPath;
    protected CursorPositionChangedListener cursorPositionChangedListener;
    private Caret defaultCaret;
    private Caret overwriteCaret;
    private Composite filterAreaPlaceholder;
    private OopsComposite fOopsComposite;
    private boolean fReady;

    @Inject
    public RemoteEditor(MPart part, IResourcePool imagePool) {
        this.inputUri = (String)part.getPersistedState().get("miworkplace.editor.inputUri");
        this.connectionName = (String)part.getPersistedState().get("miworkplace.editor.connection");
        this.readOnly = Boolean.parseBoolean((String)part.getPersistedState().get("miworkplace.editor.readonly"));
        this.memberPath = EditorInputUriUtil.getMemberPath((String)this.inputUri);
        this.imagePool = imagePool;
    }

    @PostConstruct
    public void createControls(Composite parent) {
        long time = System.currentTimeMillis();
        try {
            this.stackLayout = new StackLayout();
            this.parentComposite = new Composite(parent, 0);
            this.parentComposite.setLayout((Layout)this.stackLayout);
            this.defaultComposite = new Composite(this.parentComposite, 0);
            this.defaultComposite.setLayout((Layout)new GridLayout(1, true));
            this.stackLayout.topControl = this.defaultComposite;
            this.fOopsComposite = new OopsComposite(this.parentComposite, 0);
            this.fOopsComposite.setLayout((Layout)new FillLayout());
            this.loadingComposite = new LoadingComposite(this.parentComposite, 0);
            this.statusNotExistComposite = this.buildStatusNotExistComposite(this.parentComposite, this.memberPath);
            this.statusLockedComposite = this.buildStatusLockedComposite(this.parentComposite, this.memberPath);
            this.filterAreaPlaceholder = new Composite(this.defaultComposite, 0);
            this.filterAreaPlaceholder.setLayout((Layout)new FillLayout());
            this.filterAreaPlaceholder.setLayoutData((Object)new GridData(4, 1, true, false));
            if (this.supportFormatLines()) {
                this.formatLine = new FormatLine(this, this.defaultComposite);
                GridData layoutData = new GridData(768);
                layoutData.horizontalIndent = 3;
                this.formatLine.setLayoutData(layoutData);
            }
            this.compositeRuler = new CompositeRuler();
            this.lineNumberRuler = new LineNumberRulerColumn();
            this.viewer = this.createViewer(this.defaultComposite, this.compositeRuler);
            this.viewer.configure(this.createSourceViewerConfiguration());
            this.viewer.getControl().setLayoutData((Object)new GridData(1808));
            this.viewer.getTextWidget().setFont(this.buildFont((Widget)this.viewer.getTextWidget(), this.viewer.getTextWidget().getFont()));
            this.viewer.addSelectionChangedListener(pEvent -> this.selectionService.setSelection((Object)pEvent.getSelection()));
            this.stylingEngine.setClassname((Object)this.viewer.getTextWidget(), "miworkplace-editor-text");
            this.defaultCaret = this.createDefaultCaret(this.viewer.getTextWidget());
            this.overwriteCaret = this.createOverwriteCaret(this.viewer.getTextWidget());
            this.viewer.getTextWidget().setCaret(this.defaultCaret);
            this.viewer.setDocument(this.createDocument(), (IAnnotationModel)new AnnotationModel());
            this.createSourceContentLoader(this.getInputUri(), this.connectionName);
            boolean lineNumbersVisible = this.applicationPreferences.getBoolean("miworkplace.ui.editor.linenumbers", true);
            this.showLineNumberRuler(lineNumbersVisible);
            this.preferenceChangeListener = new ApplicationPreferenceChangeListener();
            this.applicationPreferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.preferenceChangeListener);
            if (this.supportFormatLines()) {
                this.formatLine.setFont(this.viewer.getTextWidget().getFont());
                this.compositeRuler.getControl().addControlListener((ControlListener)this.formatLine);
                this.formatLineListener = this.createFormatLineListener(this, this.formatLineProvider, this.formatLine);
                if (this.formatLineListener != null) {
                    StyledText st = this.viewer.getTextWidget();
                    st.addKeyListener((KeyListener)this.formatLineListener);
                    st.addMouseListener((MouseListener)this.formatLineListener);
                }
            }
            IAnnotationAccess annotationAccess = new IAnnotationAccess(){

                public Object getType(Annotation annotation) {
                    return annotation.getType();
                }

                public boolean isMultiLine(Annotation annotation) {
                    return true;
                }

                public boolean isTemporary(Annotation annotation) {
                    return true;
                }
            };
            this.annotationPainter = new AnnotationPainter((ISourceViewer)this.viewer, annotationAccess);
            this.annotationPainter.setAnnotationTypeColor((Object)"miworkplace.ui.editor.annotation.variable", this.imagePool.getColorUnchecked("COLOR_CONTENT_ASSIST_BOX"));
            this.annotationPainter.addAnnotationType((Object)"miworkplace.ui.editor.annotation.variable", (Object)"miworkplace.ui.editor.annotation.variable");
            this.annotationPainter.addTextStyleStrategy((Object)"miworkplace.ui.editor.annotation.variable", (AnnotationPainter.ITextStyleStrategy)new AnnotationPainter.BoxStrategy(1));
            this.annotationPainter.addAnnotationType((Object)"miworkplace.ui.editor.annotation.cursor", (Object)"miworkplace.ui.editor.annotation.cursor");
            this.annotationPainter.addTextStyleStrategy((Object)"miworkplace.ui.editor.annotation.cursor", (AnnotationPainter.ITextStyleStrategy)new AnnotationPainter.UnderlineStrategy(3));
            this.annotationPainter.setAnnotationTypeColor((Object)"miworkplace.ui.editor.annotation.cursor", this.imagePool.getColorUnchecked("COLOR_CONTENT_ASSIST_BOX"));
            this.marginPainter = new MarginPainter((ITextViewer)this.viewer);
            this.marginPainter.setMarginRulerColor(Colors.instance().get(Colors.ColorDefinition.PrintMargin));
            String printMarginValue = this.applicationPreferences.get("miworkplace.ui.editor.printmarginvalue", DEFAULT_MARGIN);
            if (!StringUtils.isNumeric((CharSequence)printMarginValue)) {
                this.logger.error((miworkplace.common.debug.Option)Option.editors, MessageFormat.format("Invalid value for print margin: {0}. Using default print margin of 80 characters.", printMarginValue));
                printMarginValue = DEFAULT_MARGIN;
            }
            this.marginPainter.setMarginRulerColumn(Integer.valueOf(printMarginValue).intValue());
            boolean printMarginVisible = this.applicationPreferences.getBoolean("miworkplace.ui.editor.printmargin", false);
            if (printMarginVisible) {
                SourceViewer extension = this.viewer;
                extension.addPainter((IPainter)this.marginPainter);
            }
            this.viewer.getTextWidget().addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    RemoteEditor.this.eventBroker.post("miworkplace/ui/editor/focus/lost", (Object)RemoteEditor.this);
                }

                public void focusGained(FocusEvent e) {
                    RemoteEditor.this.eventBroker.post("miworkplace/ui/editor/focus/gained", (Object)RemoteEditor.this);
                }
            });
            this.cursorPositionChangedListener = this.createCursorPositionChangedListener();
            if (this.cursorPositionChangedListener != null) {
                this.viewer.getTextWidget().addKeyListener((KeyListener)this.cursorPositionChangedListener);
                this.viewer.getTextWidget().addMouseListener((MouseListener)this.cursorPositionChangedListener);
            }
            this.editModeListener = new EditModeListener(this.eventBroker);
            this.viewer.getTextWidget().addKeyListener((KeyListener)this.editModeListener);
            this.viewer.getDocument().addDocumentListener(new IDocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    if (RemoteEditor.this.loadingDocument.get()) {
                        return;
                    }
                    RemoteEditor.this.setDirty(true);
                    HashMap<String, Object> eventProperties = new HashMap<String, Object>();
                    eventProperties.put("org.eclipse.e4.data", event);
                    eventProperties.put(RemoteEditor.INPUT_URI, RemoteEditor.this.inputUri);
                    RemoteEditor.this.eventBroker.post("miworkplace/editor/document/changed", eventProperties);
                }

                public void documentAboutToBeChanged(DocumentEvent event) {
                }
            });
            TextViewerUndoManager undoManager = new TextViewerUndoManager(1000);
            undoManager.connect((ITextViewer)this.viewer);
            this.viewer.setUndoManager((IUndoManager)undoManager);
            IDocumentPartitioner partitioner = this.createDocumentPartitioner();
            partitioner.connect(this.viewer.getDocument());
            this.viewer.getDocument().setDocumentPartitioner(partitioner);
            this.viewer.getAnnotationModel().addAnnotationModelListener((IAnnotationModelListener)this.annotationPainter);
            this.viewer.addTextPresentationListener((ITextPresentationListener)this.annotationPainter);
            this.annotationPainter.paint(16);
            if (!this.readOnly) {
                this.addDropSupport();
            }
            this.viewer.setEditable(!this.readOnly);
            this.registerContextMenu();
            this.parentComposite.layout();
        }
        catch (Throwable throwable) {
            this.logger.debug((miworkplace.common.debug.Option)Option.editors, MessageFormat.format("Preload Editor took {0} ms", System.currentTimeMillis() - time));
            throw throwable;
        }
        this.logger.debug((miworkplace.common.debug.Option)Option.editors, MessageFormat.format("Preload Editor took {0} ms", System.currentTimeMillis() - time));
        WorkspaceUtil.setHelp((Widget)parent, (String)"miworkplace.help.MIW: Editing");
    }

    protected IDocument createDocument() {
        return new Document();
    }

    protected SourceViewerConfiguration createSourceViewerConfiguration() {
        return (SourceViewerConfiguration)ContextInjectionFactory.make(DefaultSourceViewerConfiguration.class, (IEclipseContext)this.context);
    }

    protected SourceViewer createViewer(Composite parent, CompositeRuler ruler) {
        int styles = 66306;
        return new SourceViewer(parent, (IVerticalRuler)ruler, null, false, styles);
    }

    protected CursorPositionChangedListener createCursorPositionChangedListener() {
        return new CursorPositionChangedListener(this.eventBroker, (ITextViewer)this.viewer);
    }

    protected IDocumentPartitioner createDocumentPartitioner() {
        RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner();
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)scanner, new String[]{"__dftl_partition_content_type"});
        return partitioner;
    }

    private Caret createDefaultCaret(StyledText textWidget) {
        Caret caret = new Caret((Canvas)textWidget, 0);
        GC graphicsContext = new GC((Drawable)textWidget);
        FontMetrics fontMetrics = graphicsContext.getFontMetrics();
        caret.setBounds(caret.getLocation().x, caret.getLocation().y, 2, fontMetrics.getHeight());
        graphicsContext.dispose();
        return caret;
    }

    private Caret createOverwriteCaret(StyledText textWidget) {
        Caret caret = new Caret((Canvas)textWidget, 0);
        GC graphicsContext = new GC((Drawable)textWidget);
        FontMetrics fontMetrics = graphicsContext.getFontMetrics();
        caret.setBounds(caret.getLocation().x, caret.getLocation().y, fontMetrics.getAverageCharWidth(), fontMetrics.getHeight());
        graphicsContext.dispose();
        return caret;
    }

    private Composite buildStatusNotExistComposite(Composite parent, String memberPath) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), String.format(Messages.editor_remoteeditor_membernotexist, memberPath));
        return form;
    }

    private Composite buildStatusLockedComposite(Composite parent, String memberPath) {
        this.statusLockedFormToolkit = new FormToolkit(parent.getDisplay());
        Form form = this.statusLockedFormToolkit.createForm(parent);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        form.getBody().setLayout((Layout)layout);
        this.statusLockedFormToolkit.createLabel(form.getBody(), String.format(Messages.editor_remoteeditor_memberlocked, memberPath));
        return form;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private void updateStatusLockedControl(Collection<String> jobNames) {
        Control[] children = ((Form)this.statusLockedComposite).getBody().getChildren();
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        if (jobNames.isEmpty()) {
            this.statusLockedFormToolkit.createLabel(((Form)this.statusLockedComposite).getBody(), String.format(Messages.editor_remoteeditor_reopen, this.memberPath));
        } else {
            Composite parent = ((Form)this.statusLockedComposite).getBody();
            Label label = this.statusLockedFormToolkit.createLabel(parent, String.format(Messages.editor_remoteeditor_locked_jobs, this.memberPath));
            for (String s : jobNames) {
                FormData layoutData = new FormData();
                layoutData.left = new FormAttachment((Control)label, 0, 16384);
                layoutData.top = new FormAttachment((Control)label, 15);
                Label l = this.statusLockedFormToolkit.createLabel(parent, s);
                l.setLayoutData((Object)layoutData);
                label = l;
            }
            final String origJobName = jobNames.iterator().next();
            String[] jobNameParts = origJobName.split("/");
            final String jobName = jobNameParts[2] + "/" + jobNameParts[1] + "/" + jobNameParts[0];
            FormData layoutData = new FormData();
            layoutData.top = new FormAttachment((Control)label, 25);
            layoutData.left = new FormAttachment((Control)label, 0, 16384);
            Button killGracefullyButton = this.statusLockedFormToolkit.createButton(parent, Messages.editor_remoteeditor_endjob, 8);
            killGracefullyButton.setToolTipText(Messages.editor_remoteeditor_endjob_ttt);
            killGracefullyButton.setLayoutData((Object)layoutData);
            killGracefullyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (RemoteEditor.this.isJobActive(RemoteEditor.this.connectionManager.get(RemoteEditor.this.connectionName), origJobName)) {
                        int delay = RemoteEditor.this.applicationPreferences.getInt("miworkplace.ui.editor.endjob.delay", 30);
                        Notifier.info((String)Messages.editor_remoteeditor_endjob_notify_title, (String)String.format(Messages.editor_remoteeditor_endjob_notify_msg, origJobName));
                        String command = "ENDJOB JOB(" + jobName + ") OPTION(*CNTRLD) DELAY(" + delay + ")";
                        RemoteEditor.this.connUtil.executeRemoteCommand(RemoteEditor.this.connectionManager.get(RemoteEditor.this.connectionName), command);
                    } else {
                        Notifier.info((String)Messages.editor_remoteeditor_endjob_notify_title, (String)String.format(Messages.editor_remoteeditor_endjob_notactive, origJobName));
                    }
                }
            });
            layoutData = new FormData();
            layoutData.top = new FormAttachment((Control)killGracefullyButton, 10);
            layoutData.left = new FormAttachment((Control)label, 0, 16384);
            Button killImmediatelyButton = this.statusLockedFormToolkit.createButton(parent, Messages.editor_remoteeditor_endjobimmed, 8);
            killImmediatelyButton.setToolTipText(Messages.editor_remoteeditor_endjobimmed_ttt);
            killImmediatelyButton.setLayoutData((Object)layoutData);
            killImmediatelyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (RemoteEditor.this.isJobActive(RemoteEditor.this.connectionManager.get(RemoteEditor.this.connectionName), origJobName)) {
                        Notifier.info((String)Messages.editor_remoteeditor_endjob_notify_title, (String)String.format(Messages.editor_remoteeditor_endjobimmed_msg, origJobName));
                        String command = "ENDJOB JOB(" + jobName + ") OPTION(*IMMED)";
                        RemoteEditor.this.connUtil.executeRemoteCommand(RemoteEditor.this.connectionManager.get(RemoteEditor.this.connectionName), command);
                    } else {
                        Notifier.info((String)Messages.editor_remoteeditor_endjob_notify_title, (String)String.format(Messages.editor_remoteeditor_endjob_notactive, origJobName));
                    }
                }
            });
            layoutData = new FormData();
            layoutData.top = new FormAttachment((Control)killImmediatelyButton, 10);
            layoutData.left = new FormAttachment((Control)label, 0, 16384);
            Button retryLoadingButton = this.statusLockedFormToolkit.createButton(parent, Messages.editor_remoteeditor_retry, 8);
            retryLoadingButton.setToolTipText(Messages.editor_remoteeditor_retry_ttt);
            retryLoadingButton.setLayoutData((Object)layoutData);
            retryLoadingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RemoteEditor.this.load();
                }
            });
        }
        this.statusLockedComposite.layout();
    }

    protected boolean isJobActive(IConnection connection, String origJobName) {
        String[] jobNameParts = origJobName.split("/");
        Job job = new Job(connection.getSystem(), jobNameParts[0], jobNameParts[1], jobNameParts[2]);
        try {
            String status = job.getStatus();
            if ("*ACTIVE".equals(status)) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Error when checking locking job status. Error: " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    protected void registerContextMenu() {
        this.menuService.registerContextMenu((Object)this.getViewer().getTextWidget(), "miworkplace.ui.editor.popupmenu.default");
    }

    private Font buildFont(Widget pWidget, Font defaultFont) {
        TextAttribute ta = this.textAttributeService.get("miworkplace.ui.pref.text.basic.editor.font");
        try {
            String s;
            if (ta != null && (s = ta.getValue()) != null) {
                JSONArray array = new JSONArray(s);
                FontData[] fontList = new FontData[array.length()];
                int i = 0;
                while (i < array.length()) {
                    fontList[i] = new FontData(array.getString(i));
                    ++i;
                }
                return Factory.create((Widget)pWidget, (FontData[])fontList);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return defaultFont;
    }

    protected FormatLineListener createFormatLineListener(ISourceViewerExtension editorExtension, FormatLineProvider formatLineProvider, FormatLine formatLine) {
        return null;
    }

    protected boolean supportFormatLines() {
        return false;
    }

    private void showLineNumberRuler(boolean visible) {
        if (visible) {
            if (!this.compositeRuler.getDecoratorIterator().hasNext()) {
                this.compositeRuler.addDecorator(0, (IVerticalRulerColumn)this.lineNumberRuler);
                this.lineNumberRuler.setBackground(Colors.instance().get(Colors.ColorDefinition.SecondaryContent));
                this.lineNumberRuler.setForeground(Colors.instance().get(Colors.ColorDefinition.Comment));
            }
        } else if (this.compositeRuler.getDecoratorIterator().hasNext()) {
            this.compositeRuler.removeDecorator(0);
        }
    }

    public void toggleFilterArea() {
        if (this.filterAreaPlaceholder.getChildren().length == 0) {
            this.createFilterArea(this.filterAreaPlaceholder);
        } else {
            Control filterArea = this.filterAreaPlaceholder.getChildren()[0];
            filterArea.dispose();
        }
        this.filterAreaPlaceholder.layout();
        this.filterAreaPlaceholder.getParent().layout();
    }

    private void createFilterArea(Composite parent) {
        Composite filterArea = new Composite(parent, 0);
        filterArea.setLayout((Layout)new GridLayout(3, false));
        Label l = new Label(filterArea, 0);
        l.setText(Messages.common_filter + ":");
        final Text filterText = new Text(filterArea, 2048);
        filterText.setLayoutData((Object)new GridData(4, 1, true, false));
        filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    try {
                        RemoteEditor.this.filterLines(((Text)e.getSource()).getText());
                    }
                    catch (Exception ex) {
                        RemoteEditor.this.logger.error("Could not filter lines.", (Throwable)ex);
                    }
                }
                super.keyReleased(e);
            }
        });
        Button clear = new Button(filterArea, 8);
        clear.setImage(this.imagePool.getImageUnchecked("IMAGE_REMOVE"));
        clear.setToolTipText(Messages.common_clear);
        clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                filterText.setText("");
            }
        });
    }

    private void filterLines(String expression) throws Exception {
    }

    private SourceContentLoader createSourceContentLoader(String inputUri, String connectionName) {
        IConnection connection = this.connectionManager.get(connectionName);
        IEclipseContext additionalContext = EclipseContextFactory.create((String)SourceContentLoader.class.getName());
        additionalContext.set(IConnection.class, (Object)connection);
        additionalContext.set(INPUT_URI, (Object)inputUri);
        additionalContext.set(IDocumentReceiver.class, (Object)this);
        additionalContext.set(ISourceCodeReceiver.class, (Object)this);
        additionalContext.set("miworkplace.editor.readonly", (Object)this.readOnly);
        return (SourceContentLoader)ContextInjectionFactory.make(SourceContentLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
    }

    public void load() {
        IConnection connection = this.connectionManager.get(this.connectionName);
        if (!connection.isConnected()) {
            String message = connection.getName() + " is not connected. Check your network.";
            this.stackLayout.topControl = this.fOopsComposite;
            this.fOopsComposite.setMessage((IStatus)new Status(4, this.getClass(), message, (Throwable)new RuntimeException(message)));
            this.fOopsComposite.setCounter(1);
        } else if (!this.connUtil.doesMemberExist(connection, this.memberPath)) {
            this.stackLayout.topControl = this.statusNotExistComposite;
        } else if (this.readOnly) {
            boolean locked = true;
            try {
                locked = this.connUtil.isMemberLocked(connection, this.memberPath, new String[]{"EXCL", "EXCLRD"});
            }
            catch (Exception e) {
                this.logger.error("Problem checking lock. Assuming locked.", (Throwable)e);
            }
            if (locked) {
                this.updateStatusLockedControl(this.connUtil.listMemberLockJobs(connection, this.memberPath));
                this.stackLayout.topControl = this.statusLockedComposite;
            } else {
                this.stackLayout.topControl = this.defaultComposite;
                BusyIndicator.showWhile((Display)this.display, (Runnable)this.createSourceContentLoader(this.inputUri, this.connectionName));
            }
        } else if (this.lockService.isLocked(connection, this.memberPath) != ILockService.LockStatus.FREE) {
            this.updateStatusLockedControl(this.connUtil.listMemberLockJobs(connection, this.memberPath));
            this.stackLayout.topControl = this.statusLockedComposite;
        } else {
            this.stackLayout.topControl = this.loadingComposite;
            MiWJob runner = new MiWJob("Load remote source", this.loadingComposite.getProgressMonitor()){

                protected IStatus run(IProgressMonitor pMonitor) {
                    pMonitor.beginTask("Loading records", -1);
                    this.getSecondaryProgressMonitor().beginTask("Loading records", 100);
                    SourceContentLoader contentLoader = RemoteEditor.this.createSourceContentLoader(RemoteEditor.this.inputUri, RemoteEditor.this.connectionName);
                    contentLoader.run(this.getSecondaryProgressMonitor());
                    pMonitor.done();
                    this.getSecondaryProgressMonitor().done();
                    return contentLoader.getResult();
                }
            };
            runner.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent pEvent) {
                    RemoteEditor.this.sync.asyncExec(() -> {
                        if (pEvent.getResult().isOK()) {
                            RemoteEditor.this.stackLayout.topControl = RemoteEditor.this.defaultComposite;
                            RemoteEditor.this.fOopsComposite.setCounter(0);
                        } else {
                            RemoteEditor.this.stackLayout.topControl = RemoteEditor.this.fOopsComposite;
                            RemoteEditor.this.fOopsComposite.setMessage(pEvent.getResult());
                            RemoteEditor.this.fOopsComposite.setCounter(1);
                        }
                        RemoteEditor.this.defaultComposite.requestLayout();
                        super.done(pEvent);
                        RemoteEditor.this.setReady();
                    });
                }
            });
            runner.setUser(false);
            runner.schedule();
        }
        this.parentComposite.layout();
    }

    private void setReady() {
        this.fReady = true;
    }

    public boolean isReady() {
        return this.fReady;
    }

    @PreDestroy
    public void preDestroy() {
        if (!this.readOnly) {
            try {
                this.lockService.releaseLock(this.connectionManager.get(this.connectionName), this.memberPath);
            }
            catch (Exception e) {
                String message = String.format(Messages.editor_remoteeditor_release_msg, this.memberPath);
                this.logger.error(message, (Throwable)e);
                Notifier.error((String)"Release lock", (String)message);
            }
            this.setDirty(false);
        }
        if (this.preferenceChangeListener != null) {
            this.applicationPreferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.preferenceChangeListener);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(CONNECTION, this.connectionName);
        map.put(MEMBER_PATH, this.memberPath);
        map.put(INPUT_URI, this.inputUri);
        this.eventBroker.send("miworkplace/ui/editor/closed", map);
    }

    @Focus
    public void onFocus() {
        this.getViewer().getControl().setFocus();
        if (this.stackLayout.topControl == this.defaultComposite && this.cursorPositionChangedListener != null) {
            this.cursorPositionChangedListener.sendPositionUpdate();
        }
        this.eventBroker.post("miworkplace/ui/editor/focus/gained", (Object)this);
    }

    @Persist
    public void save(final @Named(value="activeShell") Shell shell) {
        SourceMember member = (SourceMember)this.workspaceStore.get(this.connectionManager.get(this.connectionName), this.memberPath);
        File file = member.getLocalResource().getLocation().toFile();
        try {
            FileWriter out = new FileWriter(file);
            IOUtils.write((String)this.getViewer().getDocument().get(), (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
            IConnection connection = this.connectionManager.get(this.connectionName);
            String[] recs = this.getViewer().getDocument().get().split("\n");
            int i = 0;
            while (i < recs.length) {
                recs[i] = recs[i].stripTrailing();
                ++i;
            }
            if (this.isLineNumberOverflowing(this.getLineNumberIncrementation(), recs.length)) {
                this.sync.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Notifier.notify((Shell)shell, (String)Messages.editor_remoteeditor_save_notify, (String)Messages.editor_remoteeditor_maxlinenumbers, (Notifier.Type)Notifier.Type.ERROR, (boolean)true, (int)10000);
                    }
                });
                return;
            }
            List<Integer> linesInError = this.doesSourceNeedsTruncating(recs, this.maxRecordLength);
            if (!linesInError.isEmpty()) {
                AtomicBoolean cancelSaveOp = new AtomicBoolean(false);
                MessageDialog truncateDialog = new MessageDialog(shell, Messages.editor_remoteeditor_toolong_title, null, Messages.editor_remoteeditor_toolong_msg + "\n\nLines: " + String.valueOf(linesInError), 3, new String[]{Messages.common_truncate, Messages.common_cancel}, 0);
                this.sync.syncExec(() -> {
                    int retButton = truncateDialog.open();
                    if (retButton != 0) {
                        cancelSaveOp.set(true);
                    } else {
                        this.truncateDocumentLines(this.getViewer().getDocument(), this.maxRecordLength);
                    }
                });
                if (cancelSaveOp.get()) {
                    return;
                }
            }
            IEclipseContext additionalContext = EclipseContextFactory.create((String)SaveJob.class.getName());
            additionalContext.set(IConnection.class, (Object)connection);
            additionalContext.set(RECORD_LENGTH, (Object)this.maxRecordLength);
            additionalContext.set(MEMBER_PATH, (Object)this.memberPath);
            additionalContext.set(SOURCE_CODE, (Object)this.getViewer().getDocument().get());
            additionalContext.set(SOURCE_CODE_LINES, (Object)this.getViewer().getDocument().getNumberOfLines());
            additionalContext.set(LINE_NUMBER_INCREMENTATION, (Object)this.getLineNumberIncrementation());
            additionalContext.set(RESEQUENCE_LINE_NUMBERS, (Object)this.getResequenceLineNumbers());
            additionalContext.set(ISourceCodeReceiver.class, (Object)this);
            SaveJob job = (SaveJob)((Object)ContextInjectionFactory.make(SaveJob.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
            job.setRule(new MemberRule(connection.getName(), this.memberPath));
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent pEvent) {
                    if (!pEvent.getResult().isOK()) {
                        RemoteEditor.this.sync.asyncExec(() -> RemoteEditor.this.setDirty(true));
                        Notifier.error((String)Messages.editor_remoteeditor_save_notify, (String)(Messages.editor_remoteeditor_save_error + "\n" + pEvent.getResult().getMessage()));
                    } else {
                        RemoteEditor.this.sync.asyncExec(() -> RemoteEditor.this.postFileSaved());
                    }
                }
            });
            job.schedule();
            this.setDirty(false);
        }
        catch (IOException ioe) {
            this.logger.error(MessageFormat.format("Could not save editor to local file {0}. Error: {1}", member.getLocalResource().getFullPath().toString(), ioe.getMessage()), (Throwable)ioe);
            Notifier.error((String)Messages.editor_remoteeditor_save_notify, (String)Messages.editor_remoteeditor_save_error);
        }
    }

    protected void postFileSaved() {
        this.eventBroker.post("miworkplace/ui/editor/save", (Object)this.part);
    }

    protected void setDirty(boolean pDirty) {
        this.part.setDirty(pDirty);
        WorkspaceUtil.requestEvaluation();
    }

    public void truncateDocumentLines(IDocument document, int maxLineLength) {
        int numberOfLines = document.getNumberOfLines();
        int i = 0;
        while (i < numberOfLines) {
            try {
                if (document.getLineLength(i) > maxLineLength) {
                    IRegion lineRegion = document.getLineInformation(i);
                    document.replace(lineRegion.getOffset() + maxLineLength, document.getLineLength(i) - maxLineLength - 1, "");
                }
            }
            catch (Exception exception) {}
            ++i;
        }
    }

    public List<Integer> doesSourceNeedsTruncating(String[] sourceLines, int maxSourceLength) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int line = 0;
        String[] stringArray = sourceLines;
        int n = sourceLines.length;
        int n2 = 0;
        while (n2 < n) {
            String sourceLine = stringArray[n2];
            ++line;
            if (sourceLine.length() > maxSourceLength) {
                result.add(line);
            }
            ++n2;
        }
        return result;
    }

    private boolean isLineNumberOverflowing(double lineNumberIncrementation, int length) {
        BigDecimal numberRows = new BigDecimal(lineNumberIncrementation).multiply(new BigDecimal(length)).setScale(0, RoundingMode.UP);
        return numberRows.compareTo(new BigDecimal(9999)) > 0;
    }

    private Boolean getResequenceLineNumbers() {
        Boolean resequence = this.applicationPreferences.getBoolean("miworkplace.ui.editor.line.number.incrementation", Boolean.TRUE.booleanValue());
        return resequence;
    }

    private double getLineNumberIncrementation() {
        String value = this.applicationPreferences.get("miworkplace.ui.editor.line.number.incrementation", "1.00");
        double incValue = 1.0;
        try {
            incValue = Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            incValue = 1.0;
            this.logger.error(MessageFormat.format("Could not set the line incrementation value. Using default 1.00. Value: {0}. Error: {1}", value, nfe.getMessage()), (Throwable)nfe);
        }
        return incValue;
    }

    @Override
    public void receiveDocument(IDocument document) {
        this.sync.asyncExec(() -> {
            this.loadingDocument.set(true);
            this.viewer.getDocument().set(document.get());
            this.loadingDocument.set(false);
        });
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        eventProperties.put("org.eclipse.e4.data", document);
        eventProperties.put(INPUT_URI, this.inputUri);
        this.eventBroker.post("miworkplace/editor/document/set", eventProperties);
    }

    @Inject
    @Optional
    public void notifiedConnectionClosed(@UIEventTopic(value="miworkplace/connection/disconnected") Event event, EPartService partService, MPart part) {
        partService.hidePart(part);
    }

    @Inject
    @Optional
    public void notifiedShowSelection(@UIEventTopic(value="miworkplace/ui/editor/selection/show") Event event) {
        String connectionName = event.getProperty(CONNECTION).toString();
        String memberPath = event.getProperty("path").toString();
        int line = Integer.parseInt(event.getProperty("line").toString()) - 1;
        int length = Integer.parseInt(event.getProperty("length").toString());
        int offset = Integer.parseInt(event.getProperty("offset").toString());
        if (!this.connectionName.equals(connectionName) || !this.memberPath.equals(memberPath)) {
            return;
        }
        try {
            this.waitForDocument();
            int offsetSelectionStart = this.getDocument().getLineOffset(line) - 1 + offset;
            TextSelection selection = new TextSelection(this.getDocument(), offsetSelectionStart, length);
            this.viewer.setSelection((ISelection)selection, true);
        }
        catch (Exception e) {
            this.logger.error("Could not show selection: line " + line + ", length " + length + ", offset " + offset, (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void waitForDocument() throws Exception {
        this.logger.debug((miworkplace.common.debug.Option)Option.loading, "Waiting for document ready");
        count = 0;
        ** GOTO lbl9
        {
            this.display.sleep();
            do {
                if (this.display.readAndDispatch()) continue block0;
                Thread.sleep(100L);
lbl9:
                // 2 sources

            } while (!this.isReady() && count++ < 100);
        }
        this.logger.debug((miworkplace.common.debug.Option)Option.loading, "Document ready");
    }

    @Inject
    @Optional
    public void notifiedHighlightLine(@UIEventTopic(value="miworkplace/editor/highlight/line") Event event) {
        if (!event.containsProperty(INPUT_URI)) {
            return;
        }
        String eventInputUri = event.getProperty(INPUT_URI).toString();
        if (!this.inputUri.equals(eventInputUri)) {
            return;
        }
        this.highlightLine(Integer.parseInt(event.getProperty("line").toString()));
    }

    public String getInputUri() {
        return this.inputUri;
    }

    @Override
    public void setSourceCode(Record[] records, int recordLength) {
        this.lastStoredSourceCode = records;
        this.maxRecordLength = recordLength;
    }

    @Override
    public Record[] getSourceCode() {
        return this.lastStoredSourceCode;
    }

    private void setPrintMarginColumn(String value) {
        this.logger.debug((miworkplace.common.debug.Option)Option.editors, "Print margin column changed to " + value);
        if (!StringUtils.isNumeric((CharSequence)value)) {
            this.logger.info((miworkplace.common.debug.Option)Option.editors, MessageFormat.format("Invalid value for print margin: {0}. Using default print margin of 80 characters.", value));
            value = DEFAULT_MARGIN;
        }
        this.marginPainter.setMarginRulerColumn(Integer.parseInt(value));
        this.marginPainter.paint(16);
    }

    private void showPrintMargin(boolean show) {
        this.logger.debug((miworkplace.common.debug.Option)Option.editors, "Displaying print margin line changed to " + show);
        SourceViewer extension = this.viewer;
        if (show) {
            extension.addPainter((IPainter)this.marginPainter);
        } else {
            extension.removePainter((IPainter)this.marginPainter);
        }
    }

    @Override
    public int getSourceViewerOffset() {
        return this.compositeRuler.getWidth();
    }

    @Override
    public IDocument getDocument() {
        return this.getViewer().getDocument();
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.getViewer().getSelectionProvider();
    }

    public SourceViewer getViewer() {
        return this.viewer;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ITextOperationTarget.class) {
            return this.viewer;
        }
        if (adapter == ITextOperationTargetExtension.class) {
            return this.viewer;
        }
        if (adapter == IRewriteTarget.class) {
            return this.viewer.getRewriteTarget();
        }
        return null;
    }

    public String getTitle() {
        String inputUri = this.getInputUri();
        String connectionName = EditorInputUriUtil.getConnectionName((String)inputUri);
        String memberPath = EditorInputUriUtil.getMemberPath((String)inputUri);
        IConnection connection = this.connectionManager.get(connectionName);
        IRemoteObject remoteObject = this.workspaceStore.get(connection, memberPath);
        Map properties = this.propertiesStore.get(remoteObject);
        String member = Objects.toString(properties.get(ObjectProperty.name), "") + "." + Objects.toString(properties.get(ObjectProperty.sourcetype), "");
        return member;
    }

    public String getContent() {
        return this.getViewer().getDocument().get();
    }

    @Override
    public void toggleBlockSelection() {
        boolean blockSelectionEnabled = this.getViewer().getTextWidget().getBlockSelection();
        this.getViewer().getTextWidget().setBlockSelection(!blockSelectionEnabled);
    }

    private void addDropSupport() {
        int operations = 19;
        DropTarget target = new DropTarget(this.viewer.getControl(), operations);
        final TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] types = new Transfer[]{textTransfer};
        target.setTransfer(types);
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
                if (textTransfer.isSupportedType(event.currentDataType)) {
                    textTransfer.nativeToJava(event.currentDataType);
                }
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                ITextSelection textSelection = (ITextSelection)RemoteEditor.this.viewer.getSelection();
                int startPosition = textSelection.getOffset();
                if (startPosition == -1) {
                    RuntimeException e = new RuntimeException("Could not execute drop of source. No valid start position for inserting text.");
                    RemoteEditor.this.logger.error(e.getMessage(), (Throwable)e);
                    return;
                }
                try {
                    if (textTransfer.isSupportedType(event.currentDataType)) {
                        String text = (String)event.data;
                        RemoteEditor.this.getDocument().replace(startPosition, 0, text);
                    }
                }
                catch (BadLocationException ble) {
                    RemoteEditor.this.logger.error("Could not execute drop of source.", (Throwable)ble);
                }
            }
        });
    }

    private void highlightLine(int line) {
        IDocument document = this.getViewer().getDocument();
        try {
            IRegion lineInformation = document.getLineInformation(line - 1);
            this.highlightCodeRange(lineInformation.getOffset(), lineInformation.getLength());
        }
        catch (BadLocationException e) {
            this.logger.error("Could not highlight line " + line + " in editor.", (Throwable)e);
        }
    }

    public void highlightCodeRange(int offset, int length) {
        this.getViewer().revealRange(offset, length);
        this.getViewer().setSelectedRange(offset, length);
    }

    public boolean isOverwriteMode() {
        return this.overwriteMode;
    }

    public void setOverwriteMode(boolean overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    @Override
    public int getRecordLength() {
        return this.maxRecordLength;
    }

    private final class ApplicationPreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private ApplicationPreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("miworkplace.ui.editor.linenumbers")) {
                RemoteEditor.this.showLineNumberRuler(Boolean.parseBoolean(event.getNewValue().toString()));
            } else if (event.getKey().equals("miworkplace.ui.editor.printmargin")) {
                RemoteEditor.this.showPrintMargin(Boolean.parseBoolean(event.getNewValue().toString()));
            } else if (event.getKey().equals("miworkplace.ui.editor.printmarginvalue")) {
                RemoteEditor.this.setPrintMarginColumn(event.getNewValue().toString());
            }
        }
    }

    class EditModeListener
    implements KeyListener {
        private final IEventBroker eventBroker;

        public EditModeListener(IEventBroker eventBroker) {
            this.eventBroker = eventBroker;
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 0x1000009) {
                RemoteEditor.this.setOverwriteMode(!RemoteEditor.this.isOverwriteMode());
                this.eventBroker.post("miworkplace/ui/editor/overwrite/changed", (Object)(RemoteEditor.this.isOverwriteMode() ? Boolean.TRUE : Boolean.FALSE));
                this.changeCaretPresentation(RemoteEditor.this.isOverwriteMode());
            }
        }

        private void changeCaretPresentation(boolean overwriteMode) {
            if (overwriteMode) {
                RemoteEditor.this.viewer.getTextWidget().setCaret(RemoteEditor.this.overwriteCaret);
            } else {
                RemoteEditor.this.viewer.getTextWidget().setCaret(RemoteEditor.this.defaultCaret);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

