/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.editor;

import java.util.HashMap;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.services.api.IDoubleClickExecutor;
import miworkplace.services.api.IDoubleClickServiceProvider;
import miworkplace.services.api.ILastUsedEditorService;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.osgi.service.log.LogService;

public class LastUsedDoubleClickExecutor
implements IDoubleClickExecutor {
    private LogService logger;
    private ILastUsedEditorService lastUsedEditorService;

    void bindLastUsedEditorService(ILastUsedEditorService service) {
        this.lastUsedEditorService = service;
    }

    void unbindLastUsedEditorService(ILastUsedEditorService service) {
        this.lastUsedEditorService = null;
    }

    void bindLogService(LogService logger) {
        this.logger = logger;
    }

    void unbindLogService(LogService logger) {
        this.logger = null;
    }

    void bindDoubleClickProvider(IDoubleClickServiceProvider service) {
        service.register((IDoubleClickExecutor)this);
    }

    void unbindDoubleClickProvider(IDoubleClickServiceProvider service) {
        service.deregister((IDoubleClickExecutor)this);
    }

    public void execute(Object obj, EHandlerService handlerService, ECommandService commandService) {
        if (obj instanceof SourceMember || obj instanceof StreamFile) {
            IRemoteObject sourceObject = (IRemoteObject)obj;
            Command command = this.determineCommand(sourceObject, commandService);
            if (command.isDefined()) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("miworkplace.ui.editor.command.parameter.selection", sourceObject.getPath());
                parameters.put("miworkplace.ui.editor.command.parameter.connection", sourceObject.getConnection().getName());
                parameters.put("miworkplace.ui.editor.command.parameter.readonly", Boolean.FALSE.toString());
                ParameterizedCommand cmd = commandService.createCommand(command.getId(), parameters);
                if (handlerService.canExecute(cmd)) {
                    this.logger.log(4, "Opening source " + sourceObject.getPath() + " with last used command " + command.getId());
                    handlerService.executeHandler(cmd);
                } else {
                    this.logger.log(1, "Cannot execute command open source member. Command Id: " + command.getId());
                }
            } else {
                this.logger.log(1, "Command for opening source member is not defined. Command Id: " + command.getId());
            }
        }
    }

    private Command determineCommand(IRemoteObject sourceObject, ECommandService commandService) {
        String commandId = this.lastUsedEditorService.getCommandId(sourceObject.getConnection().getName(), sourceObject.getPath());
        if (commandId == null) {
            return null;
        }
        Command command = commandService.getCommand(commandId);
        return command;
    }

    public boolean canExecute(ECommandService commandService, Object object) {
        if (object instanceof SourceMember || object instanceof StreamFile) {
            Command command = this.determineCommand((IRemoteObject)object, commandService);
            if (command == null) {
                return false;
            }
            return command.isDefined();
        }
        return false;
    }

    public Integer getRanking() {
        return 1;
    }
}

