/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.i18n;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;

public class CompareMessages {
    public static void main(String[] args) throws URISyntaxException, IOException {
        Map<String, String> messages = CompareMessages.load("messages.properties");
        Map<String, String> prvMessages = CompareMessages.load("messages.prv.properties");
        Map<String, String> deMessages = CompareMessages.load("messages_de.properties");
        System.out.println(messages);
        System.out.println(prvMessages);
        System.out.println("New Messages");
        System.out.println("==========");
        messages.keySet().forEach(key -> {
            if (!prvMessages.containsKey(key)) {
                System.out.println(key + "=" + (String)messages.get(key));
            }
        });
        System.out.println();
        System.out.println("Changed Messages");
        System.out.println("===========");
        messages.keySet().forEach(key -> {
            if (prvMessages.containsKey(key) && !((String)prvMessages.get(key)).equals(messages.get(key))) {
                System.out.println("o: " + key + "=" + (String)prvMessages.get(key));
                System.out.println("n: " + key + "=" + (String)messages.get(key));
                System.out.println();
            }
        });
        System.out.println();
        System.out.println("Deleted Messages");
        System.out.println("==============");
        prvMessages.keySet().forEach(key -> {
            if (!messages.containsKey(key)) {
                System.out.println((String)key);
            }
        });
        System.out.println();
        System.out.println("German Missing Messages");
        System.out.println("=====================");
        messages.keySet().forEach(key -> {
            if (!deMessages.containsKey(key)) {
                System.out.println(key + "=" + (String)messages.get(key));
            }
        });
        System.out.println();
        System.out.println("German Missing in prv");
        System.out.println("===================");
        prvMessages.keySet().forEach(key -> {
            if (!deMessages.containsKey(key)) {
                System.out.println((String)key);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> load(String pfile) throws URISyntaxException, IOException {
        System.out.println();
        System.out.println("Duplicate keys in " + pfile);
        System.out.println("================");
        TreeMap<String, String> result = new TreeMap<String, String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scanner = new Scanner(CompareMessages.class.getResourceAsStream(pfile));){
            block5: while (true) {
                if (!scanner.hasNextLine()) {
                    return result;
                }
                Object line = scanner.nextLine().trim();
                if (((String)line).isEmpty() || ((String)line).startsWith("#")) continue;
                while (true) {
                    if (!((String)line).endsWith("\\")) {
                        String[] split = ((String)line).split("=");
                        if (result.containsKey(split[0])) {
                            System.out.println(split[0]);
                        }
                        result.put(split[0], ((String)line).replaceFirst(".*?=", ""));
                        continue block5;
                    }
                    line = (String)line + scanner.nextLine().trim();
                }
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

