/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.search.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ObjectProperty;
import miworkplace.ui.api.EventFileEntry;
import miworkplace.ui.search.EventFileEntryMatch;
import miworkplace.ui.search.Match;
import miworkplace.ui.search.SearchResult;
import miworkplace.ui.search.SearchResultPart;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CopySearchResultHandler {
    @Inject
    private Display display;
    @Inject
    private IObjectPropertiesStore propertiesStore;
    @Inject
    private IWorkspaceStore workspaceStore;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell) {
        Object object = part.getObject();
        if (object instanceof SearchResultPart) {
            SearchResult searchResult = ((SearchResultPart)object).getCurrentSearchResult();
            if (searchResult == null) {
                return;
            }
            List<String> ifsPaths = searchResult.getIfsPaths();
            LinkedList<EventFileEntry> entries = new LinkedList<EventFileEntry>();
            for (String path : ifsPaths) {
                Match[] matches;
                Match[] matchArray = matches = searchResult.getMatches(path);
                int n = matches.length;
                int n2 = 0;
                while (n2 < n) {
                    Match m = matchArray[n2];
                    entries.add(((EventFileEntryMatch)m).getEntry());
                    ++n2;
                }
            }
            Clipboard cb = new Clipboard(this.display);
            String data = this.prepareSearchResultData(searchResult.getLabel(), entries, searchResult.getConnection());
            TextTransfer textTransfer = TextTransfer.getInstance();
            cb.setContents(new Object[]{data}, new Transfer[]{textTransfer});
        }
    }

    private String prepareSearchResultData(String title, List<EventFileEntry> entries, IConnection connection) {
        StringBuilder buffer = new StringBuilder();
        String newline = System.getProperty("line.separator");
        String lastPath = "";
        Collections.sort(entries);
        for (EventFileEntry entry : entries) {
            String qsysPath = entry.getQsysPath();
            if (!qsysPath.equals(lastPath)) {
                String description;
                if (entry != entries.get(0)) {
                    buffer.append(newline);
                }
                if (StringUtils.isBlank((CharSequence)(description = this.getMemberDescription(connection, qsysPath)))) {
                    buffer.append(qsysPath);
                } else {
                    buffer.append(qsysPath + " : " + description);
                }
                buffer.append(newline);
                lastPath = qsysPath;
            }
            String line = String.valueOf(entry.getLine());
            buffer.append(StringUtils.leftPad((String)line, (int)5));
            buffer.append(entry.getMessage());
            buffer.append(newline);
        }
        return buffer.toString();
    }

    private String getMemberDescription(IConnection connection, String ifsPath) {
        Map properties;
        IRemoteObject member = this.workspaceStore.get(connection, ifsPath);
        if (member != null && (properties = this.propertiesStore.get(member)) != null) {
            return properties.get(ObjectProperty.textdescription).toString();
        }
        return null;
    }
}

