/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.search.handler;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.MessageFormat;
import java.util.HashMap;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.notifications.Notifier;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.search.EventFileEntryMatch;
import miworkplace.ui.search.SearchResult;
import miworkplace.ui.search.SearchResultNode;
import miworkplace.ui.search.SearchResultPart;
import miworkplace.ui.util.LibraryLoader;
import miworkplace.ui.util.MemberLoader;
import miworkplace.ui.util.ObjectLoader;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;

public abstract class AbstractSearchHandler {
    private static final String OPEN_IFS_COMMAND_ID = "miworkplace.ui.command.ifs.open";
    private static final String OPEN_MEMBER_COMMAND_ID = "miworkplace.ui.command.openSourceMember";
    @Inject
    private IEclipseContext context;
    @Inject
    protected IEventBroker eventBroker;
    @Inject
    protected ECommandService commandService;
    @Inject
    protected EHandlerService handlerService;
    @Inject
    private IWorkspaceStore workspaceStore;
    protected Debug logger = Debug.getInstance();

    protected abstract EventFileEntryMatch getMatch(SearchResultPart var1);

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart activePart) {
        SearchResultPart part = (SearchResultPart)activePart.getObject();
        SearchResult searchResult = part.getCurrentSearchResult();
        EventFileEntryMatch match = this.getMatch(part);
        if (match != null) {
            ITreeSelection selection = part.getSelectedPath();
            TreePath[] treePaths = selection.getPaths();
            TreePath currentTreePath = treePaths[0];
            String ifsPath = this.buildIfsPath(currentTreePath);
            this.loadPath(searchResult.getConnection(), ifsPath);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("miworkplace.ui.editor.command.parameter.connection", searchResult.getConnection().getName());
            parameters.put("miworkplace.ui.editor.command.parameter.selection", ifsPath);
            String commandId = null;
            commandId = ifsPath.startsWith("/QSYS.LIB/") ? OPEN_MEMBER_COMMAND_ID : OPEN_IFS_COMMAND_ID;
            ParameterizedCommand command = this.commandService.createCommand(commandId, parameters);
            if (!command.getCommand().isDefined()) {
                RuntimeException e = new RuntimeException(MessageFormat.format("Command {0} is not available. Could not open member {1}.", commandId, ifsPath));
                this.logger.error(e.getMessage(), (Throwable)e);
                return;
            }
            if (!this.handlerService.canExecute(command)) {
                RuntimeException e = new RuntimeException(MessageFormat.format("Open Member Handler cannot execute for member {0}.", ifsPath));
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            this.handlerService.executeHandler(command);
            HashMap<String, String> eventMap = new HashMap<String, String>();
            eventMap.put("connection", searchResult.getQuery().getConnection().getName());
            eventMap.put("path", ifsPath);
            eventMap.put("line", String.valueOf(match.getLine()));
            eventMap.put("offset", String.valueOf(match.getOffset()));
            eventMap.put("length", String.valueOf(searchResult.getQuery().getSearchString().length()));
            this.eventBroker.post("miworkplace/ui/editor/selection/show", eventMap);
        }
    }

    private String buildIfsPath(TreePath treePath) {
        SearchResultNode location = (SearchResultNode)treePath.getSegment(0);
        if (location.type == SearchResultNode.NodeType.dir) {
            SearchResultNode node = (SearchResultNode)treePath.getSegment(1);
            return node.ifsPath;
        }
        SearchResultNode node = (SearchResultNode)treePath.getSegment(2);
        StringBuilder s = new StringBuilder("/QSYS.LIB/");
        s.append(treePath.getSegment(0).toString());
        s.append(".LIB/");
        s.append(treePath.getSegment(1).toString());
        s.append(".FILE/");
        s.append(node.name);
        s.append(".MBR");
        return s.toString();
    }

    private void loadPath(IConnection connection, String path) {
        if (this.workspaceStore.get(connection, path) != null) {
            return;
        }
        if (path.startsWith("/QSYS.LIB/")) {
            this.loadQSYSPath(connection, path);
        } else {
            WorkspaceUtil.load((IConnection)connection, (String)path);
        }
    }

    private void loadQSYSPath(IConnection connection, String memberPath) {
        IStatus status;
        ObjectLoader loader;
        IEclipseContext additionalContext;
        String filePath;
        QSYSObjectPathName path = new QSYSObjectPathName(memberPath);
        if (this.workspaceStore.get(connection, "/QSYS.LIB/" + path.getLibraryName() + ".LIB") == null) {
            IEclipseContext additionalContext2 = EclipseContextFactory.create();
            additionalContext2.set(IConnection.class, (Object)connection);
            additionalContext2.set("miworkplace.ui.library", (Object)path.getLibraryName());
            LibraryLoader loader2 = (LibraryLoader)ContextInjectionFactory.make(LibraryLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext2);
            IStatus status2 = loader2.run((IProgressMonitor)new NullProgressMonitor());
            if (!status2.isOK()) {
                Notifier.error((String)"Load Libraries", (String)("Could not load library " + path.getLibraryName() + ": " + status2.getMessage()));
                throw new RuntimeException(status2.getMessage());
            }
        }
        if (this.workspaceStore.get(connection, filePath = "/QSYS.LIB/" + path.getLibraryName() + ".LIB/" + path.getObjectName() + ".FILE") == null) {
            IRemoteObject library = this.workspaceStore.getLibrary(connection, path.getLibraryName());
            additionalContext = EclipseContextFactory.create();
            additionalContext.set("miworkplace.ui.library", (Object)library);
            loader = (ObjectLoader)ContextInjectionFactory.make(ObjectLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
            status = loader.run((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                Notifier.error((String)"Load Source File", (String)("Could not load source file " + path.getObjectName() + ": " + status.getMessage()));
                throw new RuntimeException(status.getMessage());
            }
        }
        if (this.workspaceStore.get(connection, memberPath) == null) {
            IRemoteObject file = this.workspaceStore.get(connection, filePath);
            additionalContext = EclipseContextFactory.create();
            additionalContext.set("miworkplace.ui.file", (Object)file);
            loader = (MemberLoader)ContextInjectionFactory.make(MemberLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext);
            status = loader.run((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                Notifier.error((String)"Load Source Members", (String)MessageFormat.format("Could not load members of source file {0}: {1}", path.getObjectName(), status.getMessage()));
                throw new RuntimeException(status.getMessage());
            }
        }
    }
}

