/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.search;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceFile;
import miworkplace.common.model.StreamFile;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.ui.api.EventFile;
import miworkplace.ui.api.EventFileEntry;
import miworkplace.ui.api.IEventFileLoader;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.search.EventFileEntryMatch;
import miworkplace.ui.search.SearchResult;
import miworkplace.ui.search.debug.Option;
import miworkplace.ui.util.ObjectLoader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class RemoteSearchQuery {
    private static final String ROOT = "/";
    private static final String _1 = "1";
    private static final String ASTRSK = "*";
    private static final String MBR = "MBR";
    private static final String EVFEVENT = "EVFEVENT";
    private static final String QGPL = "QGPL";
    private static final String QSYSLIB = "/QSYS.LIB";
    private static final String EMPTY = "";
    private static final String MATCH_CASE = "*MATCH";
    private static final String IGNORE_CASE = "*IGNORE";
    private static final String ALL = "*ALL";
    private static final String SEARCH_RECORD_LENGTH = "*RCDLEN";
    private final long fId;
    private Debug logger = Debug.getInstance();
    @Inject
    private IEventFileLoader eventFileLoader;
    @Inject
    private IWorkspaceStore fWorkSpaceStore;
    @Inject
    private IEclipseContext fContext;
    @Inject
    private IConnectionUtilities fConUtils;
    private SearchResult rs = null;
    private IConnection fConnection;
    private String fSearchString;
    private String fSearchLibrary;
    private String fSearchFile;
    private String fSearchMember;
    private boolean fCaseSensitive;
    private boolean fSearchAllColumns = true;
    private int fRangeFrom = 1;
    private int fRangeTo = 100;
    private String fSearchDirectory;
    private int fSearchEngine;
    private int fSearchDepth;

    public RemoteSearchQuery(IConnection conn, String searchString, int pSearchEngine, String pSearchDirectory, int pSearchDepth, String searchLibrary, String searchFile, String searchMember, boolean caseSensitive) {
        this.fId = System.currentTimeMillis();
        this.fConnection = conn;
        this.fSearchString = searchString.trim();
        this.fSearchEngine = pSearchEngine;
        this.fSearchDirectory = pSearchDirectory;
        this.fSearchDepth = pSearchDepth;
        this.fSearchLibrary = searchLibrary;
        this.fSearchFile = searchFile;
        this.fSearchMember = searchMember;
        this.fCaseSensitive = caseSensitive;
        this.fSearchAllColumns = true;
    }

    public RemoteSearchQuery(IConnection conn, String searchString, int pSearchEngine, String pSearchDirectory, int pSearchDepth, String searchLibrary, String searchFile, String searchMember, boolean caseSensitive, int rangeFrom, int rangeTo) {
        this.fId = System.currentTimeMillis();
        this.fConnection = conn;
        this.fSearchString = searchString;
        this.fSearchEngine = pSearchEngine;
        this.fSearchDirectory = pSearchDirectory;
        this.fSearchDepth = pSearchDepth;
        this.fSearchLibrary = searchLibrary;
        this.fSearchFile = searchFile;
        this.fSearchMember = searchMember;
        this.fCaseSensitive = caseSensitive;
        this.fRangeFrom = rangeFrom;
        this.fRangeTo = rangeTo;
        this.fSearchAllColumns = false;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        if (this.isSearchDirectory()) {
            return MessageFormat.format(Messages.search_query_labeldir, this.rs.getMatchCount(), this.fSearchDirectory);
        }
        return String.format(Messages.search_query_label, this.fSearchString, this.rs.getMatchCount(), this.fSearchLibrary, this.fSearchFile, this.fSearchMember);
    }

    public SearchResult getSearchResult() {
        if (this.rs == null) {
            this.rs = new SearchResult(this);
        }
        return this.rs;
    }

    public IStatus run(IProgressMonitor progressMonitor) throws OperationCanceledException {
        ArrayList<EventFile> results = new ArrayList<EventFile>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)String.format(Messages.search_query_monitor_title, this.fSearchString), (int)100);
        monitor.subTask(Messages.search_query_subtask);
        if (this.fSearchString.isEmpty()) {
            this.logger.error((miworkplace.common.debug.Option)Option.search, "The search string must not be empty.");
            return new Status(4, "miworkplace.ui.search", Messages.search_query_empty);
        }
        if (!this.fConnection.isConnected()) {
            this.logger.error((miworkplace.common.debug.Option)Option.search, "Could not execute search action because the connection is closed.");
            return new Status(1, "miworkplace.ui.search", Messages.search_query_closedconn);
        }
        String eventFilePath = this.fSearchEngine == 1 ? this.createEventFile() : this.createGrepFile();
        monitor.worked(1);
        monitor.subTask(Messages.search_query_subtask2);
        String[] ifsPaths = null;
        try {
            ifsPaths = this.getSourceFilePaths(monitor);
        }
        catch (Exception e) {
            this.logger.error("Could not load source file member list.", (Throwable)e);
            monitor.setCanceled(true);
            monitor.done();
            return new Status(4, "miworkplace.ui.search", Messages.search_query_nomemberlist, (Throwable)e);
        }
        monitor.worked(10);
        monitor.subTask(Messages.search_query_subtask3);
        SubMonitor findStringMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)ifsPaths.length);
        monitor.setWorkRemaining(ifsPaths.length);
        int i = 0;
        while (i < ifsPaths.length) {
            if (monitor.isCanceled()) break;
            findStringMonitor.subTask(String.format(Messages.search_query_subtask4, ifsPaths[i]));
            this.search(ifsPaths[i], eventFilePath);
            EventFile eventFile = this.parseEventFile(eventFilePath, ifsPaths[i]);
            if (eventFile != null) {
                results.add(eventFile);
            } else {
                this.logger.debug((miworkplace.common.debug.Option)Option.search, "Could not load serch result from event file of " + ifsPaths[i]);
            }
            findStringMonitor.worked(1);
            ++i;
        }
        findStringMonitor.worked(1);
        monitor.subTask(Messages.search_query_subtask5);
        if (this.rs == null) {
            this.rs = new SearchResult(this);
        }
        this.rs.removeAll();
        i = 0;
        while (i < results.size()) {
            EventFile file = (EventFile)results.get(i);
            if (file != null) {
                EventFileEntry[] entries = file.getEntries();
                int j = 0;
                while (j < entries.length) {
                    this.rs.addMatch(new EventFileEntryMatch(entries[j]));
                    ++j;
                }
            }
            ++i;
        }
        monitor.worked(1);
        monitor.done();
        return new Status(0, "miworkplace.ui.search", Messages.search_query_finished);
    }

    private String createGrepFile() {
        return MessageFormat.format("/tmp/miw_searchresult_{0}.txt", this.fConnection.getUsername());
    }

    private String createEventFile() {
        String currentLibrary = this.fConUtils.getCurrentLibrary(this.fConnection);
        QSYSObjectPathName eventFile = new QSYSObjectPathName(currentLibrary, EVFEVENT, EVFEVENT, MBR);
        try {
            this.logger.debug((miworkplace.common.debug.Option)Option.search, "Clearing event file: " + this.getClearEventFileCommand(eventFile));
            this.fConUtils.executeRemoteCommand(this.fConnection, this.getClearEventFileCommand(eventFile));
        }
        catch (Exception e) {
            this.logger.debug((miworkplace.common.debug.Option)Option.search, "Event file not cleared due to: " + e.getMessage());
        }
        return eventFile.getPath();
    }

    private EventFile parseEventFile(String eventFilePath, String pIfsPath) {
        EventFile eventFile;
        block5: {
            EventFileEntry[] entries;
            block6: {
                EventFileEntry[] entries2;
                eventFile = null;
                try {
                    eventFile = this.eventFileLoader.loadEventFile(this.fConnection, eventFilePath);
                }
                catch (Exception exception) {}
                if (eventFile == null) break block5;
                eventFile.setConnection(this.fConnection);
                eventFile.setIfsPath(pIfsPath);
                if (this.fConnection.getSystemVersion() < 730 || this.fSearchEngine != 1) break block6;
                EventFileEntry[] eventFileEntryArray = entries2 = eventFile.getEntries();
                int n = entries2.length;
                int n2 = 0;
                while (n2 < n) {
                    EventFileEntry entry = eventFileEntryArray[n2];
                    entry.setMessage(entry.getMessage().substring(this.fSearchString.length() + 1));
                    ++n2;
                }
                break block5;
            }
            if (this.fSearchEngine == 1) break block5;
            Pattern pattern = Pattern.compile((String)(this.fCaseSensitive ? this.fSearchString : "(?i)" + this.fSearchString));
            EventFileEntry[] eventFileEntryArray = entries = eventFile.getEntries();
            int n = entries.length;
            int n3 = 0;
            while (n3 < n) {
                EventFileEntry entry = eventFileEntryArray[n3];
                Matcher matcher = pattern.matcher(entry.getMessage());
                while (matcher.find()) {
                    entry.setColumnStart(matcher.start() + 1);
                    entry.setColumnEnd(matcher.end() + 1);
                }
                ++n3;
            }
        }
        return eventFile;
    }

    private String[] getSourceFilePaths(SubMonitor pMonitor) throws Exception {
        ArrayList<String> ifsPaths = new ArrayList<String>();
        if (this.isSearchDirectory()) {
            this.logger.debug((miworkplace.common.debug.Option)Option.search, MessageFormat.format("Searching {0} levels in {1}", this.fSearchDepth, this.fSearchString));
            if (this.fSearchEngine == 3 && this.fSearchDepth == -1) {
                ifsPaths.add(this.fSearchDirectory);
            } else if (this.fSearchDirectory.equalsIgnoreCase(ROOT)) {
                List files = this.fWorkSpaceStore.getStreamFiles(this.fConnection, ROOT);
                for (IRemoteObject stmf : files) {
                    if (!((StreamFile)stmf).isDirectory() || stmf.getPath().startsWith(QSYSLIB)) continue;
                    ifsPaths.addAll(this.getDirectories(pMonitor, stmf.getPath()));
                }
            } else {
                ifsPaths.addAll(this.getDirectories(pMonitor, this.fSearchDirectory));
            }
        } else if (this.fSearchLibrary.equalsIgnoreCase(ALL)) {
            for (IRemoteObject remoteObject : this.fWorkSpaceStore.getLibraries(this.fConnection)) {
                pMonitor.setTaskName(MessageFormat.format(Messages.search_query_load_lib, remoteObject.getName()));
                ifsPaths.addAll(this.getLibraryPaths(remoteObject.getName()));
            }
        } else {
            pMonitor.setTaskName(MessageFormat.format(Messages.search_query_load_lib, this.fSearchLibrary));
            ifsPaths.addAll(this.getLibraryPaths(this.fSearchLibrary));
        }
        return ifsPaths.toArray(new String[ifsPaths.size()]);
    }

    private List<String> getDirectories(SubMonitor pMonitor, String pSearchDirectory) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(pSearchDirectory);
        int counter = this.fSearchDepth;
        ArrayList<StreamFile> run = new ArrayList<StreamFile>();
        run.addAll(this.getSubDirectories(pSearchDirectory));
        while (counter != 0) {
            if (counter < -99) {
                this.logger.warning("Stopping at 99 search recursions", null);
                break;
            }
            ArrayList<StreamFile> newRun = new ArrayList<StreamFile>();
            for (StreamFile file : run) {
                pMonitor.setTaskName(MessageFormat.format(Messages.search_query_loading_dir, file.getPath()));
                result.add(file.getPath());
                newRun.addAll(this.getSubDirectories(file.getPath()));
            }
            if (--counter == -1 || (run = newRun).isEmpty()) break;
        }
        return result;
    }

    private List<String> getLibraryPaths(String pSearchLibrary) {
        ArrayList<String> ifsPaths = new ArrayList<String>();
        IRemoteObject library = this.fWorkSpaceStore.getLibrary(this.fConnection, pSearchLibrary);
        if (library == null) {
            WorkspaceUtil.load((IConnection)this.fConnection, (String)MessageFormat.format("/QSYS.LIB/{0}.LIB", pSearchLibrary.trim()));
            library = this.fWorkSpaceStore.getLibrary(this.fConnection, pSearchLibrary);
        }
        if (!library.areChildrenLoaded()) {
            ObjectLoader loader = (ObjectLoader)ContextInjectionFactory.make(ObjectLoader.class, (IEclipseContext)this.fContext);
            loader.setLibrary(library);
            loader.setSourceId(Long.valueOf(System.currentTimeMillis()));
            loader.run((IProgressMonitor)new NullProgressMonitor());
        }
        for (IRemoteObject remote : this.fWorkSpaceStore.getObjects(library)) {
            if (!(remote instanceof SourceFile) || !ASTRSK.equals(this.fSearchFile) && !ALL.equals(this.fSearchFile) && !this.fSearchFile.equalsIgnoreCase(remote.getName())) continue;
            ifsPaths.add(remote.getPath());
        }
        return ifsPaths;
    }

    private List<StreamFile> getSubDirectories(String pDirectory) {
        ArrayList<StreamFile> result = new ArrayList<StreamFile>();
        IRemoteObject dir = this.fWorkSpaceStore.get(this.fConnection, pDirectory);
        if (!dir.areChildrenLoaded()) {
            WorkspaceUtil.load((IConnection)this.fConnection, (String)pDirectory);
        }
        for (IRemoteObject remoteObject : this.fWorkSpaceStore.getStreamFiles(this.fConnection, pDirectory)) {
            this.logger.debug((miworkplace.common.debug.Option)Option.search, "getDirectories: " + String.valueOf(remoteObject));
            if (!(remoteObject instanceof StreamFile) || !((StreamFile)remoteObject).isDirectory()) continue;
            result.add((StreamFile)remoteObject);
        }
        return result;
    }

    private boolean search(String ifsPath, String pEventFile) {
        this.logger.debug((miworkplace.common.debug.Option)Option.search, MessageFormat.format("START Searching path {0} (search engine={1} 1=PDM, 2=oldgrep, 3=newgrep)", ifsPath, this.fSearchEngine));
        String command = this.fSearchEngine == 1 ? this.buildFindStringCommand(ifsPath) : (this.fSearchEngine == 2 ? this.buildOldGrepCommand(ifsPath, pEventFile) : this.buildNewGrepCommand(ifsPath, pEventFile));
        try {
            this.logger.debug((miworkplace.common.debug.Option)Option.search, "Executing search command: " + command);
            this.fConUtils.executeRemoteCommand(this.fConnection, command);
        }
        catch (Exception e) {
            try {
                this.logger.error("Could not execute command: " + command, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.logger.debug((miworkplace.common.debug.Option)Option.search, MessageFormat.format("END Searching path {0} ({1})", ifsPath, command));
                throw throwable;
            }
            this.logger.debug((miworkplace.common.debug.Option)Option.search, MessageFormat.format("END Searching path {0} ({1})", ifsPath, command));
            return false;
        }
        this.logger.debug((miworkplace.common.debug.Option)Option.search, MessageFormat.format("END Searching path {0} ({1})", ifsPath, command));
        return true;
    }

    private String getClearEventFileCommand(QSYSObjectPathName pEventfile) {
        return MessageFormat.format("CLRPFM FILE({0}/{1}) MBR({2})", pEventfile.getLibraryName().trim(), pEventfile.getObjectName().trim(), pEventfile.getMemberName().trim());
    }

    private String buildFindStringCommand(String ifsPath) {
        String rangeToString;
        String rangeFromString;
        QSYSObjectPathName path = new QSYSObjectPathName(ifsPath);
        String member = this.fSearchMember;
        if (this.fSearchMember.trim().equals(ASTRSK)) {
            member = ALL;
        }
        String caseSensitiveString = this.fCaseSensitive ? MATCH_CASE : IGNORE_CASE;
        if (this.fSearchAllColumns) {
            rangeFromString = _1;
            rangeToString = SEARCH_RECORD_LENGTH;
        } else {
            rangeFromString = String.valueOf(this.fRangeFrom);
            rangeToString = String.valueOf(this.fRangeTo);
        }
        String quoted = this.quoteSearchString(false);
        String command = MessageFormat.format("FNDSTRPDM STRING({0}) FILE({1}/{2}) MBR({3}) CASE({4}) COL({5} {6}) OPTION(*NONE) PARM(*EVENTF) PRTRCDS(*ALL *CHAR)", quoted, path.getLibraryName().trim(), path.getObjectName(), member, caseSensitiveString, rangeFromString, rangeToString);
        return command;
    }

    private String quoteSearchString(boolean pGrep) {
        String quoted;
        String string = quoted = pGrep ? this.fSearchString.replaceAll("'", "''") : this.fSearchString.replaceAll("'", "'''");
        if (pGrep) {
            return quoted;
        }
        if (!quoted.endsWith("'")) {
            quoted = MessageFormat.format("{0}''", quoted);
        }
        if (!quoted.startsWith("'")) {
            quoted = MessageFormat.format("''{0}", quoted);
        }
        return quoted;
    }

    private String buildNewGrepCommand(String ifsPath, String pSearchResultFile) {
        Object directory = ifsPath.trim();
        if (!((String)directory).endsWith(ASTRSK)) {
            directory = (String)directory + "/*";
        }
        Object options = EMPTY;
        if (!this.fCaseSensitive) {
            options = (String)options + "i";
        }
        if (this.fSearchDepth == -1) {
            options = (String)options + "r";
        }
        String searchString = this.quoteSearchString(true);
        String command = MessageFormat.format("QSH CMD(''/QOpenSys/pkgs/bin/grep -n{0} ''''{1}'''' {2} > {3}'')", options, searchString, directory, pSearchResultFile);
        return command;
    }

    private String buildOldGrepCommand(String ifsPath, String pSearchResultPath) {
        if (this.fSearchDirectory != null && !this.fSearchDirectory.trim().isEmpty()) {
            return this.buildOldGrepDirectorySearchCommand(ifsPath, pSearchResultPath);
        }
        Object caseSensitive = EMPTY;
        if (!this.fCaseSensitive) {
            caseSensitive = (String)caseSensitive + "i";
        }
        Object member = this.fSearchMember;
        member = this.fSearchMember.trim().equals(ALL) ? ASTRSK : (String)member + ASTRSK;
        Object range = EMPTY;
        if (!this.fSearchAllColumns) {
            range = ".{" + this.fRangeFrom + "}";
        }
        String command = MessageFormat.format("QSH CMD(''/usr/bin/grep -n{0} {1}{2} {3}/{4} > {5}'')", caseSensitive, range, this.fSearchString, ifsPath, member, pSearchResultPath);
        return command;
    }

    private String buildOldGrepDirectorySearchCommand(String ifsPath, String pSearchResultFile) {
        Object directory = ifsPath.trim();
        if (!((String)directory).endsWith(ASTRSK)) {
            directory = (String)directory + "/*";
        }
        Object caseSensitive = EMPTY;
        if (!this.fCaseSensitive) {
            caseSensitive = (String)caseSensitive + "i";
        }
        String searchString = this.fSearchString;
        String command = MessageFormat.format("QSH CMD(''/usr/bin/grep -rn{0} {1} {2} > {3}'')", caseSensitive, searchString, directory, pSearchResultFile);
        return command;
    }

    public IConnection getConnection() {
        return this.fConnection;
    }

    public String getSearchString() {
        return this.fSearchString;
    }

    public String getSearchLibrary() {
        return this.fSearchLibrary;
    }

    public String getSearchFile() {
        return this.fSearchFile;
    }

    public String getSearchDirectory() {
        return this.fSearchDirectory;
    }

    public boolean isSearchDirectory() {
        return !this.fSearchDirectory.trim().isEmpty();
    }

    public String getSearchMember() {
        return this.fSearchMember;
    }

    public long getId() {
        return this.fId;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.fId ^ this.fId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteSearchQuery other = (RemoteSearchQuery)obj;
        return this.fId == other.fId;
    }
}

