/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.search;

import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.ui.api.ModelUtil;
import miworkplace.ui.search.SearchResult;
import miworkplace.ui.search.SearchResultService;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;

public class LastSearchResultsMenuContribution {
    @Inject
    private SearchResultService searchResultService;
    @Inject
    private EModelService modelService;
    @Inject
    private ECommandService commandService;
    @Inject
    private MApplication application;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items, ESelectionService selectionService) {
        if (this.searchResultService.isEmpty()) {
            MDirectMenuItem item = this.createEmptyMenuItem();
            items.add((MMenuElement)item);
        } else {
            for (SearchResult searchResult : this.searchResultService.list()) {
                MHandledMenuItem dynamicItem = (MHandledMenuItem)this.modelService.createModelElement(MHandledMenuItem.class);
                dynamicItem.setContributorURI("platform:/plugin/miworkplace.ui.search");
                dynamicItem.setLabel(searchResult.getLabel());
                MCommand command = ModelUtil.getCommand((String)"miworkplace.ui.search.show", (MApplication)this.application);
                dynamicItem.setCommand(command);
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("miworkplace.ui.search.show.query.id", String.valueOf(searchResult.getQuery().getId()));
                ParameterizedCommand pcommand = this.commandService.createCommand("miworkplace.ui.search.show", parameters);
                dynamicItem.setWbCommand(pcommand);
                items.add((MMenuElement)dynamicItem);
            }
        }
    }

    private MDirectMenuItem createEmptyMenuItem() {
        MDirectMenuItem item = MMenuFactory.INSTANCE.createDirectMenuItem();
        item.setLabel(Messages.search_noresults);
        item.setEnabled(false);
        item.setVisible(true);
        return item;
    }
}

