/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import com.remainsoftware.common.util.Validate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.Key;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class PemFile {
    private PemObject pemObject;

    public PemFile(Key key, String description) {
        this.pemObject = new PemObject(description, key.getEncoded());
    }

    public PemFile(X509Certificate x509Cert, String description) throws CertificateEncodingException {
        this.pemObject = new PemObject(description, x509Cert.getEncoded());
    }

    public void write(String pemFileName) throws FileNotFoundException, IOException {
        Validate.isNotEmpty((String)pemFileName, (String)"PEM file-name must be set");
        File pemFile = new File(pemFileName);
        File parentPath = pemFile.getParentFile();
        if (parentPath != null && !parentPath.exists()) {
            parentPath.mkdirs();
        }
        PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(pemFile)));
        try {
            pemWriter.writeObject((PemObjectGenerator)this.pemObject);
            pemWriter.flush();
        }
        catch (Throwable throwable) {
            if (pemWriter != null) {
                try {
                    pemWriter.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (pemWriter != null) {
            try {
                pemWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void write(File pemFile) throws FileNotFoundException, IOException {
        Validate.isNotNull((Object)pemFile, (String)"PEM file must be set");
        File parentPath = pemFile.getParentFile();
        if (parentPath != null && !parentPath.exists()) {
            parentPath.mkdirs();
        }
        PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter(new FileOutputStream(pemFile)));
        try {
            pemWriter.writeObject((PemObjectGenerator)this.pemObject);
            pemWriter.flush();
        }
        catch (Throwable throwable) {
            if (pemWriter != null) {
                try {
                    pemWriter.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (pemWriter != null) {
            try {
                pemWriter.close();
            }
            catch (IOException iOException) {}
        }
    }
}

