/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import com.remainsoftware.common.ssl.CertificateUtils;
import com.remainsoftware.common.ssl.CustomX509TrustManager;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private static final Logger logger = LoggerFactory.getLogger(CustomX509ExtendedTrustManager.class);
    private X509ExtendedTrustManager defaultJSSEX509TrustManager;

    public CustomX509ExtendedTrustManager() throws Exception {
        TrustManager[] trustManagers;
        TrustManagerFactory trustMgrFactory = CertificateUtils.createX509TrustmanagerFactory(null);
        TrustManager[] trustManagerArray = trustManagers = trustMgrFactory.getTrustManagers();
        int n = trustManagers.length;
        int n2 = 0;
        while (n2 < n) {
            TrustManager trustManager = trustManagerArray[n2];
            if (trustManager instanceof X509ExtendedTrustManager) {
                this.defaultJSSEX509TrustManager = (X509ExtendedTrustManager)trustManager;
                return;
            }
            ++n2;
        }
        String msg = "Failed to initialize CustomX509ExtendedTrustManager, required default X509TrustManager was not found";
        logger.error(msg);
        throw new Exception(msg);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.defaultJSSEX509TrustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.defaultJSSEX509TrustManager.checkServerTrusted(chain, authType);
        }
        catch (Exception e) {
            if (e instanceof CertificateException) {
                CustomX509TrustManager.processServerTrustedException(chain, e);
            }
            throw new CertificateException(e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.defaultJSSEX509TrustManager.checkClientTrusted(chain, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.defaultJSSEX509TrustManager.checkClientTrusted(chain, authType, engine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.defaultJSSEX509TrustManager.checkServerTrusted(chain, authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.defaultJSSEX509TrustManager.checkServerTrusted(chain, authType, engine);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultJSSEX509TrustManager.getAcceptedIssuers();
    }
}

