/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import com.remainsoftware.common.ssl.CertificateUtils;
import com.remainsoftware.common.ssl.CustomX509TrustManager;
import com.remainsoftware.common.util.NetUtils;
import com.remainsoftware.common.util.StringUtils;
import com.remainsoftware.common.util.Validate;
import java.io.File;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.MessageFormat;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTrustManagerUtils {
    private static final Logger logger = LoggerFactory.getLogger(CustomTrustManagerUtils.class);
    private static volatile boolean isCustomTrustManagerSetup = false;
    private static CustomX509TrustManager customX509TrustManager = null;
    private static final Object customTrustMgrSync = new Object();
    private static SSLContext defaultSslContext = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCustomTrustManagerSetup() {
        Object object = customTrustMgrSync;
        synchronized (object) {
            return isCustomTrustManagerSetup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509TrustManager getCustomTrustManagerInstance() {
        Object object = customTrustMgrSync;
        synchronized (object) {
            if (customX509TrustManager == null) {
                CustomTrustManagerUtils.configureCustomTrustManager(null, null, null, false);
            }
            return customX509TrustManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureCustomTrustManager(String additionalTrustStorePath, String additionalTrustedHosts, String additionalCertificatesPath, boolean isOverrideDefaultCertPath) {
        Object object = customTrustMgrSync;
        synchronized (object) {
            logger.info("update SSL trust manager; trust-store-file: " + (!StringUtils.isEmpty((String)additionalTrustStorePath) ? additionalTrustStorePath : "*notset") + ", trusted-hosts: " + (!StringUtils.isEmpty((String)additionalTrustedHosts) ? additionalTrustedHosts : "*notset") + ", certificates-path: " + (!StringUtils.isEmpty((String)additionalCertificatesPath) ? additionalCertificatesPath : "*notset") + ", override-cert-path: " + isOverrideDefaultCertPath);
            if (!StringUtils.isEmpty((String)additionalCertificatesPath) && isOverrideDefaultCertPath) {
                System.setProperty("ssl.certificates.path", additionalCertificatesPath);
            }
            boolean isAlreadyInitialized = false;
            if (customX509TrustManager == null) {
                CustomTrustManagerUtils.setupForCustomizedTrustedHosts();
            } else {
                isAlreadyInitialized = true;
            }
            if (customX509TrustManager != null && !StringUtils.isEmpty((String)additionalTrustedHosts)) {
                CertificateUtils.addTrustedHosts(additionalTrustedHosts);
            }
            if (customX509TrustManager != null && !StringUtils.isEmpty((String)additionalTrustStorePath)) {
                customX509TrustManager.addX509TrustManager(additionalTrustStorePath);
            }
            if (!(customX509TrustManager == null || StringUtils.isEmpty((String)additionalCertificatesPath) || isOverrideDefaultCertPath || isAlreadyInitialized)) {
                CertificateUtils.addTrustedHostsFromCertificatesPath(additionalCertificatesPath);
            }
        }
    }

    public static void updateCustomTrustManager(String additionalTrustStorePath, String additionalTrustedHosts) {
        CustomTrustManagerUtils.configureCustomTrustManager(additionalTrustStorePath, additionalTrustedHosts, null, false);
    }

    public static void updateCustomTrustManager(String additionalTrustStorePath, String additionalTrustedHosts, String certificatesPath, boolean isOverrideDefaultCertPath) {
        CustomTrustManagerUtils.configureCustomTrustManager(additionalTrustStorePath, additionalTrustedHosts, certificatesPath, isOverrideDefaultCertPath);
    }

    public static void isValidCertificate(String hostName, X509Certificate x509Cert, String pinningIssuer, PublicKey pinningPublicKey) throws CertificateException {
        try {
            String issuerDN = CertificateUtils.getCertificateIssuerDN(x509Cert);
            if (pinningPublicKey != null) {
                if (CertificateUtils.isSelfSigned(x509Cert)) {
                    try {
                        x509Cert.verify(pinningPublicKey);
                    }
                    catch (Exception e) {
                        String message = MessageFormat.format("{0} from host: ''{1}'', issuer: ''{2}'', reason = failed to verify server''s certificate signature using the stored certificate''s public key, stored certificate may be outdated.", "Certificate error; validation failed for SSL certificate", hostName, issuerDN);
                        logger.warn(message, (Throwable)e);
                        throw new CertificateException(message);
                    }
                } else if (!x509Cert.getPublicKey().equals(pinningPublicKey)) {
                    String message = MessageFormat.format("{0} from host: ''{1}'', issuer: ''{2}'', reason = stored certificate''s public key does not match the host certificate''s public key", "Certificate error; validation failed for SSL certificate", hostName, issuerDN);
                    logger.warn(message);
                    throw new CertificateException(message);
                }
            }
            String pkAlgorithm = CertificateUtils.getPublicKeyAlgorithmName(x509Cert.getPublicKey());
            int pkLength = CertificateUtils.getPublicKeyLength(x509Cert.getPublicKey());
            if (pkLength < CertificateUtils.getMinimumAsymmetricKeyLength(pkAlgorithm) && !CertificateUtils.isAllowWeakCertificateKeyLength()) {
                String message = MessageFormat.format("{0} from host: ''{1}'', issuer: ''{2}'', reason = the host certificate''s public key length does not match the requirement (>= {3} bits, algorithm = ''{4}'')", "Certificate error; validation failed for SSL certificate", hostName, issuerDN, CertificateUtils.getMinimumAsymmetricKeyLength(pkAlgorithm), pkAlgorithm);
                logger.warn(message);
                throw new CertificateException(message);
            }
            if (!StringUtils.isEmpty((String)pinningIssuer) && !pinningIssuer.equals(issuerDN)) {
                String message = MessageFormat.format("{0} from host: ''{1}'', issuer: ''{2}'', reason = host certificate''s issuer does not match the stored certificate''s issuer: ''{3}''", "Certificate error; validation failed for SSL certificate", hostName, issuerDN, pinningIssuer);
                logger.warn(message);
                throw new CertificateException(message);
            }
            if (CertificateUtils.isExpiredCertificate(x509Cert) && !CertificateUtils.isAllowExpiredCertificate()) {
                String message = MessageFormat.format("{0} from host: ''{1}'', issuer: ''{2}'', reason = certificate expired on {3}", "Certificate error; validation failed for SSL certificate", hostName, issuerDN, x509Cert.getNotAfter().toString());
                logger.warn(message);
                throw new CertificateException(message);
            }
        }
        catch (Exception e) {
            if (e instanceof CertificateException) {
                throw (CertificateException)e;
            }
            String message = MessageFormat.format("{0} from host: ''{1}'', issuer: ''{2}'', reason = an exception occurred during validation, cause = {3}", "Certificate error; validation failed for SSL certificate", hostName, CertificateUtils.getCertificateIssuerDN(x509Cert), StringUtils.extractMessage((Exception)e));
            logger.error(message);
            throw new CertificateException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupForCustomizedTrustedHosts() {
        if (isCustomTrustManagerSetup) {
            return;
        }
        logger.info("initializing custom SSL certificate manager");
        TrustManager[] trustManagers = null;
        Object object = customTrustMgrSync;
        synchronized (object) {
            try {
                customX509TrustManager = new CustomX509TrustManager();
                trustManagers = new TrustManager[]{customX509TrustManager};
            }
            catch (Throwable t) {
                logger.error("failed to create custom SSL certificate trust-manager, reason = " + StringUtils.extractMessage((Throwable)t), t);
            }
        }
        File certPathFile = CertificateUtils.getRemainCertificatesPath();
        CustomTrustManagerUtils.loadTrustStores(certPathFile.getAbsolutePath());
        try {
            File instCertPathFile = CustomTrustManagerUtils.getProductInstallLocation();
            if (instCertPathFile == null) {
                logger.warn("could not determine installation certificates directory, reason = installation location was not resolved");
            } else {
                instCertPathFile = new File(instCertPathFile, "certificates");
            }
            CertificateUtils.loadTrustedHosts(certPathFile.getAbsolutePath(), instCertPathFile);
            if (trustManagers != null) {
                defaultSslContext = SSLContext.getInstance(CertificateUtils.getDefaultSSLContextProtocol());
                defaultSslContext.init(null, trustManagers, new SecureRandom());
                SSLContext.setDefault(defaultSslContext);
                SSLSocketFactory sslSocketFactory = defaultSslContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
            }
            HostnameVerifier hostVerifier = (hostName, session) -> CertificateUtils.isTrustedHost(hostName);
            HttpsURLConnection.setDefaultHostnameVerifier(hostVerifier);
        }
        catch (Throwable t) {
            logger.error("an exception occured while setting up certificate trusting, cause = " + t.getMessage(), t);
        }
        logger.info("completed setup of custom SSL certificate manager");
        isCustomTrustManagerSetup = true;
    }

    private static void loadTrustStores(String certPath) {
        if (customX509TrustManager == null) {
            throw new IllegalStateException("custom SSL trust manager not yet instantiated");
        }
        if (!StringUtils.isEmpty((String)certPath)) {
            File certPathFile = new File(certPath);
            if (!certPathFile.exists()) {
                certPathFile.mkdirs();
            }
            File[] fileArray = certPathFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileExt;
                File file = fileArray[n2];
                if (file.isFile() && ((fileExt = StringUtils.getFileExtension((String)file.getName()).toLowerCase()).equals("jks") || fileExt.equals("p12") || fileExt.equals("pfx"))) {
                    customX509TrustManager.addX509TrustManager(file);
                }
                ++n2;
            }
        }
    }

    public static void processTrustedHostCertificite(X509Certificate x509Cert, String hostName) throws CertificateException {
        Validate.isNotEmpty((String)hostName, (String)"host-name must be set");
        Validate.isNotNull((Object)x509Cert, (String)"X509-certificate must be set");
        Validate.isTrue((boolean)CertificateUtils.isTrustedHost(hostName), (String)("host: '" + hostName + "' is not listed as trusted"));
        if (!CertificateUtils.isSessionTrustedHost(hostName)) {
            X509Certificate trustedCert = CertificateUtils.getTrustedHostCertificate(hostName);
            if (trustedCert != null) {
                CustomTrustManagerUtils.isValidCertificate(hostName, x509Cert, CertificateUtils.getCertificateIssuerDN(x509Cert), trustedCert.getPublicKey());
            } else {
                x509Cert.checkValidity();
                if (!CertificateUtils.isExpiredCertificate(x509Cert)) {
                    CertificateUtils.addCertificateTrustedHost(hostName, x509Cert);
                    CustomTrustManagerUtils.saveCertificate(hostName, x509Cert, true);
                    if (NetUtils.isLocalAddress((String)hostName)) {
                        CertificateUtils.addLocalHostAsSessionTrusted(null);
                    }
                } else {
                    String message = MessageFormat.format("Failed to process certificate from host: {0}, issued by: {1} , reason = certificate expired on {2}", hostName, CertificateUtils.getCertificateIssuerDN(x509Cert), x509Cert.getNotAfter().toString());
                    logger.warn(message);
                    throw new CertificateException(message);
                }
            }
        }
    }

    public static boolean saveCertificate(String hostName, X509Certificate x509Cert, boolean overWrite) {
        Validate.isNotEmpty((String)hostName, (String)"host-name must be set");
        Validate.isNotNull((Object)x509Cert, (String)"X509-certificate must be set");
        File certFile = null;
        try {
            certFile = new File(CertificateUtils.getRemainCertificatesPath(), String.valueOf(CertificateUtils.replaceWildWithPound(hostName)) + ".crt");
            if (!certFile.exists() || overWrite) {
                boolean rc = CertificateUtils.writePemFile(x509Cert, "CERTIFICATE", certFile.getAbsolutePath());
                if (rc) {
                    logger.info("persisted certificate for host: '" + hostName + "', issuer: '" + CertificateUtils.getCertificateIssuerDN(x509Cert) + "'");
                }
                return rc;
            }
            return true;
        }
        catch (Exception e) {
            logger.error("failed to persist '" + hostName + "' certificate file: '" + (certFile != null ? certFile.getAbsolutePath() : "*path failure*/" + hostName + ".crt") + ", reason = " + StringUtils.extractMessage((Exception)e), (Throwable)e);
            return false;
        }
    }

    public static File getProductInstallLocation() {
        String instanceDir = System.getProperty("instance.dir");
        if (!StringUtils.isEmpty((String)instanceDir)) {
            return new File(instanceDir);
        }
        return null;
    }

    public static void main(String[] args) {
        String configTrustStorePath = "c:/temp/certificates/remaincastore";
        CustomTrustManagerUtils.updateCustomTrustManager(configTrustStorePath, "127.0.0.1, localhost");
        try {
            Class.forName("com.ibm.as400.access.AS400JDBCDriver");
            Connection con = DriverManager.getConnection("jdbc:as400://plato;naming=sql;errors=full;secure=true", "user", "password");
            con.clearWarnings();
            con.close();
        }
        catch (Exception e) {
            String msg = StringUtils.extractMessage((Exception)e);
            System.out.println(msg);
            System.out.println(e);
        }
    }
}

