/*
 * Decompiled with CFR 0.152.
 */
package com.remainsoftware.common.ssl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Scanner;
import org.apache.commons.codec.binary.Base64;

public class AuthorizedKeysDecoder {
    private static final String UNKNOWN_TYPE_DESC = "unknown type: ";
    private static final String NO_BASE64_PART_TO_DECODE_DESC = "no Base64 part to decode";
    private byte[] bytes;
    private int pos;

    public PublicKey decodePublicKey(String keyLine) throws Exception {
        this.bytes = null;
        this.pos = 0;
        String[] stringArray = keyLine.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.startsWith("AAAA")) {
                this.bytes = Base64.decodeBase64((String)part);
                break;
            }
            ++n2;
        }
        if (this.bytes == null) {
            throw new IllegalArgumentException(NO_BASE64_PART_TO_DECODE_DESC);
        }
        String type = this.decodeType();
        if (type.equals("ssh-rsa")) {
            BigInteger e = this.decodeBigInt();
            BigInteger m = this.decodeBigInt();
            RSAPublicKeySpec spec = new RSAPublicKeySpec(m, e);
            return KeyFactory.getInstance("RSA").generatePublic(spec);
        }
        if (type.equals("ssh-dss")) {
            BigInteger p = this.decodeBigInt();
            BigInteger q = this.decodeBigInt();
            BigInteger g = this.decodeBigInt();
            BigInteger y = this.decodeBigInt();
            DSAPublicKeySpec spec = new DSAPublicKeySpec(y, p, q, g);
            return KeyFactory.getInstance("DSA").generatePublic(spec);
        }
        throw new IllegalArgumentException(UNKNOWN_TYPE_DESC + type);
    }

    private String decodeType() {
        int len = this.decodeInt();
        String type = new String(this.bytes, this.pos, len);
        this.pos += len;
        return type;
    }

    private int decodeInt() {
        return (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
    }

    private BigInteger decodeBigInt() {
        int len = this.decodeInt();
        byte[] bigIntBytes = new byte[len];
        System.arraycopy(this.bytes, this.pos, bigIntBytes, 0, len);
        this.pos += len;
        return new BigInteger(bigIntBytes);
    }

    public static void main(String[] args) throws Exception {
        AuthorizedKeysDecoder decoder = new AuthorizedKeysDecoder();
        File file = new File("authorized_keys");
        try (Scanner scanner = null;){
            scanner = new Scanner(file).useDelimiter("\n");
            while (scanner.hasNext()) {
                System.out.println(decoder.decodePublicKey(scanner.next()));
            }
        }
    }

    public static String encodePublicKey(PublicKey publicKey, String user) throws IOException {
        if (publicKey.getAlgorithm().equals("RSA")) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            ByteArrayOutputStream byteOs = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(byteOs);
            dos.writeInt("ssh-rsa".getBytes().length);
            dos.write("ssh-rsa".getBytes());
            dos.writeInt(rsaPublicKey.getPublicExponent().toByteArray().length);
            dos.write(rsaPublicKey.getPublicExponent().toByteArray());
            dos.writeInt(rsaPublicKey.getModulus().toByteArray().length);
            dos.write(rsaPublicKey.getModulus().toByteArray());
            String publicKeyEncoded = new String(Base64.encodeBase64((byte[])byteOs.toByteArray()));
            return "ssh-rsa " + publicKeyEncoded + " " + user;
        }
        if (publicKey.getAlgorithm().equals("DSA")) {
            DSAPublicKey dsaPublicKey = (DSAPublicKey)publicKey;
            DSAParams dsaParams = dsaPublicKey.getParams();
            ByteArrayOutputStream byteOs = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(byteOs);
            dos.writeInt("ssh-dss".getBytes().length);
            dos.write("ssh-dss".getBytes());
            dos.writeInt(dsaParams.getP().toByteArray().length);
            dos.write(dsaParams.getP().toByteArray());
            dos.writeInt(dsaParams.getQ().toByteArray().length);
            dos.write(dsaParams.getQ().toByteArray());
            dos.writeInt(dsaParams.getG().toByteArray().length);
            dos.write(dsaParams.getG().toByteArray());
            dos.writeInt(dsaPublicKey.getY().toByteArray().length);
            dos.write(dsaPublicKey.getY().toByteArray());
            String publicKeyEncoded = new String(Base64.encodeBase64((byte[])byteOs.toByteArray()));
            return "ssh-dss " + publicKeyEncoded + " " + user;
        }
        throw new IllegalArgumentException("Unknown public key encoding: " + publicKey.getAlgorithm());
    }
}

