/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.rpgunit.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import miworkplace.common.model.IRemoteObject;
import miworkplace.rpgunit.model.CallStackEntry;
import miworkplace.rpgunit.model.UnitTestResult;

public class UnitTestCase {
    private IRemoteObject serviceprogram;
    private String name;
    private Status status;
    private int assertions;
    private UnitTestResult testResult;
    private String errorMessage;
    private Long executionTime;
    private List<CallStackEntry> callStack = new ArrayList<CallStackEntry>();

    public UnitTestCase(UnitTestResult testResult, IRemoteObject serviceprogram) {
        this.testResult = testResult;
        this.serviceprogram = serviceprogram;
    }

    public IRemoteObject getServiceprogram() {
        return this.serviceprogram;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSuccessful() {
        return this.status.equals((Object)Status.Success);
    }

    public void setSuccessful() {
        this.status = Status.Success;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setAssertions(int assertions) {
        this.assertions = assertions;
    }

    public int getAssertions() {
        return this.assertions;
    }

    public void setTestResult(UnitTestResult testResult) {
        this.testResult = testResult;
    }

    public UnitTestResult getTestResult() {
        return this.testResult;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Long getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(Long executionTime) {
        this.executionTime = executionTime;
    }

    public void addCallStackEntry(CallStackEntry entry) {
        this.callStack.add(entry);
    }

    public List<CallStackEntry> getCallStack() {
        return Collections.unmodifiableList(this.callStack);
    }

    public String toString() {
        return "UnitTestCase [serviceprogram=" + String.valueOf(this.serviceprogram) + ", name=" + this.name + ", status=" + String.valueOf((Object)this.status) + ", assertions=" + this.assertions + ", errorMessage=" + this.errorMessage + ", executionTime=" + String.valueOf(this.executionTime) + "]";
    }

    public static enum Status {
        Success("S"),
        Error("E"),
        Failure("F");

        String s;

        private Status(String s) {
            this.s = s;
        }

        public String getStatusCode() {
            return this.s;
        }

        public boolean isSuccess() {
            return this.s.equals("S");
        }
    }
}

