/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.properties;

import com.ibm.as400.access.ObjectDescription;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.HashMap;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IRemoteObject;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ObjectProperty;
import miworkplace.services.properties.ObjectPropertyValueMapper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;

public class ObjectPropertiesLoader
extends Job {
    private Debug logger = Debug.getInstance();
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IObjectPropertiesStore objectPropertiesStore;
    @Inject
    private IRemoteObject object;
    private ObjectPropertyValueMapper valueMapper;

    public ObjectPropertiesLoader() {
        super("Retrieving object description information");
        this.setPriority(20);
        this.valueMapper = new ObjectPropertyValueMapper();
    }

    @PostConstruct
    public void postConstruct() {
        this.setName("Retrieving object description information for " + this.object.getName());
    }

    public IStatus run(IProgressMonitor monitor) {
        this.logger.debug((Option)miworkplace.services.debug.Option.general, "Starting Eclipse Job: " + this.getName() + " for object " + this.object.getName());
        try {
            ObjectDescription objDesc = new ObjectDescription(this.object.getConnection().getSystem(), this.object.getPath());
            objDesc.refresh();
            HashMap<ObjectProperty, Object> properties = new HashMap<ObjectProperty, Object>();
            properties.put(ObjectProperty.attribute, this.valueMapper.map(ObjectProperty.attribute, objDesc.getValueAsString(202)));
            properties.put(ObjectProperty.auditing, this.valueMapper.map(ObjectProperty.auditing, objDesc.getValueAsString(310)));
            properties.put(ObjectProperty.changedate, this.valueMapper.map(ObjectProperty.changedate, objDesc.getValue(305)));
            properties.put(ObjectProperty.changedbyprogram, this.valueMapper.map(ObjectProperty.changedbyprogram, objDesc.getValueAsString(309)));
            properties.put(ObjectProperty.compiler, this.valueMapper.map(ObjectProperty.compiler, objDesc.getValueAsString(408)));
            properties.put(ObjectProperty.compression, this.valueMapper.map(ObjectProperty.compression, objDesc.getValueAsString(307)));
            properties.put(ObjectProperty.creationdate, this.valueMapper.map(ObjectProperty.creationdate, objDesc.getValue(304)));
            properties.put(ObjectProperty.creatorsystem, this.valueMapper.map(ObjectProperty.creatorsystem, objDesc.getValueAsString(406)));
            properties.put(ObjectProperty.creatoruserprofile, this.valueMapper.map(ObjectProperty.creatoruserprofile, objDesc.getValueAsString(405)));
            properties.put(ObjectProperty.daysused, this.valueMapper.map(ObjectProperty.daysused, objDesc.getValueAsString(603)));
            properties.put(ObjectProperty.digitallysigned, this.valueMapper.map(ObjectProperty.digitallysigned, objDesc.getValueAsString(311)));
            properties.put(ObjectProperty.domain, this.valueMapper.map(ObjectProperty.domain, objDesc.getValueAsString(303)));
            properties.put(ObjectProperty.journal, this.valueMapper.map(ObjectProperty.journal, objDesc.getValue(514)));
            properties.put(ObjectProperty.journalomittedentries, this.valueMapper.map(ObjectProperty.journalomittedentries, objDesc.getValue(517)));
            properties.put(ObjectProperty.journalimages, this.valueMapper.map(ObjectProperty.journalimages, objDesc.getValue(516)));
            properties.put(ObjectProperty.journalstartdate, this.valueMapper.map(ObjectProperty.journalstartdate, objDesc.getValueAsString(518)));
            properties.put(ObjectProperty.journalstatus, this.valueMapper.map(ObjectProperty.journalstatus, objDesc.getValue(513)));
            properties.put(ObjectProperty.lastuseddate, this.valueMapper.map(ObjectProperty.lastuseddate, objDesc.getValueAsString(601)));
            properties.put(ObjectProperty.library, this.valueMapper.map(ObjectProperty.library, objDesc.getValueAsString(10001)));
            properties.put(ObjectProperty.licensedprogram, this.valueMapper.map(ObjectProperty.licensedprogram, objDesc.getValueAsString(411)));
            properties.put(ObjectProperty.name, this.valueMapper.map(ObjectProperty.name, objDesc.getValueAsString(10000)));
            properties.put(ObjectProperty.objectsize, this.valueMapper.map(ObjectProperty.objectsize, objDesc.getValueAsString(701)));
            properties.put(ObjectProperty.ptf, this.valueMapper.map(ObjectProperty.ptf, objDesc.getValueAsString(412)));
            properties.put(ObjectProperty.resetdate, this.valueMapper.map(ObjectProperty.resetdate, objDesc.getValueAsString(602)));
            properties.put(ObjectProperty.restoredate, this.valueMapper.map(ObjectProperty.restoredate, objDesc.getValueAsString(502)));
            properties.put(ObjectProperty.saveactivedate, this.valueMapper.map(ObjectProperty.saveactivedate, objDesc.getValueAsString(512)));
            properties.put(ObjectProperty.savecommand, this.valueMapper.map(ObjectProperty.savecommand, objDesc.getValueAsString(506)));
            properties.put(ObjectProperty.savedate, this.valueMapper.map(ObjectProperty.savedate, objDesc.getValueAsString(501)));
            properties.put(ObjectProperty.savedevice, this.valueMapper.map(ObjectProperty.savedevice, objDesc.getValueAsString(508)));
            properties.put(ObjectProperty.savefile, this.valueMapper.map(ObjectProperty.savefile, objDesc.getValueAsString(509)));
            properties.put(ObjectProperty.savefilelabel, this.valueMapper.map(ObjectProperty.savefilelabel, objDesc.getValueAsString(511)));
            properties.put(ObjectProperty.savefilesequenceid, this.valueMapper.map(ObjectProperty.savefilesequenceid, objDesc.getValueAsString(505)));
            properties.put(ObjectProperty.savefilevolumeid, this.valueMapper.map(ObjectProperty.savefilevolumeid, objDesc.getValueAsString(507)));
            properties.put(ObjectProperty.sourcefile, this.valueMapper.map(ObjectProperty.sourcefile, objDesc.getValueAsString(401)));
            properties.put(ObjectProperty.sourcefileupdateddate, this.valueMapper.map(ObjectProperty.sourcefileupdateddate, objDesc.getValueAsString(404)));
            properties.put(ObjectProperty.storagestatus, this.valueMapper.map(ObjectProperty.storagestatus, objDesc.getValueAsString(306)));
            properties.put(ObjectProperty.textdescription, this.valueMapper.map(ObjectProperty.textdescription, objDesc.getValueAsString(203)));
            properties.put(ObjectProperty.type, this.valueMapper.map(ObjectProperty.type, objDesc.getValueAsString(10002)));
            properties.put(ObjectProperty.usageinfoupdated, this.valueMapper.map(ObjectProperty.usageinfoupdated, objDesc.getValueAsString(604)));
            properties.put(ObjectProperty.userchanged, this.valueMapper.map(ObjectProperty.userchanged, objDesc.getValueAsString(410)));
            properties.put(ObjectProperty.userdefinedattribute, this.valueMapper.map(ObjectProperty.userdefinedattribute, objDesc.getValueAsString(204)));
            if (this.object.getAttribute() != null) {
                if (this.object.getAttribute().equals((Object)IRemoteObject.Attribute.sourcefile)) {
                    properties.put(ObjectProperty.attribute, this.valueMapper.map(ObjectProperty.attribute, IRemoteObject.Attribute.sourcefile.attr()));
                } else if (this.object.getAttribute().equals((Object)IRemoteObject.Attribute.datafile)) {
                    properties.put(ObjectProperty.attribute, this.valueMapper.map(ObjectProperty.attribute, IRemoteObject.Attribute.datafile.attr()));
                }
            }
            properties.put(ObjectProperty.notloaded, Boolean.FALSE);
            this.objectPropertiesStore.put(this.object, properties);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org.eclipse.e4.data", this.object);
            map.put("connection", this.object.getConnection().getName());
            map.put("path", this.object.getPath());
            this.eventBroker.post("miworkplace/ui/loader/description/loaded", map);
            this.logger.debug((Option)miworkplace.services.debug.Option.general, "Ending Eclipse Job: " + this.getName());
            return new Status(0, "miworkplace.services", "Finished loading of object description of " + this.object.getName() + ".");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new Status(4, "miworkplace.services", MessageFormat.format("Error during loading of object description of {0}. Cause: {1}", this.object.getName(), e.getMessage()), (Throwable)e);
        }
    }
}

