/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.lasteditor;

import miworkplace.common.model.SourceMember;
import miworkplace.services.api.ILastUsedEditorService;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.prefs.BackingStoreException;

public class LastUsedEditorService
implements ILastUsedEditorService,
EventHandler {
    private IEclipsePreferences preferences;

    void activate() {
        this.preferences = InstanceScope.INSTANCE.getNode("miworkplace.services.lasteditor");
    }

    @Override
    public void setCommandId(String connectionName, String path, String commandId) {
        this.preferences.put(connectionName + ":" + path, commandId);
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getCommandId(String connectionName, String path) {
        String commandId = this.preferences.get(connectionName + ":" + path, null);
        if ("miworkplace.ui.editor.command.ifs.open.with.rpg".equals(commandId)) {
            return "miworkplace.ui.editor.rpg.command.ifs.open.with";
        }
        if ("miworkplace.ui.editor.command.open.with.rpg".equals(commandId)) {
            return "miworkplace.ui.editor.rpg.command.open.with";
        }
        return commandId;
    }

    public void handleEvent(Event event) {
        Object change;
        if (event.getTopic().equals("miworkplace/member/updated") && "TYPE".equals(change = event.getProperty("change"))) {
            SourceMember member = (SourceMember)event.getProperty("org.eclipse.e4.data");
            this.preferences.remove(member.getConnection().getName() + ":" + member.getPath());
            try {
                this.preferences.flush();
            }
            catch (BackingStoreException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

