/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.alive;

import java.util.HashMap;
import java.util.Map;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.services.alive.KeepAliveWorker;
import miworkplace.services.debug.Option;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class KeepAliveService
implements EventHandler {
    private Debug logger = Debug.getInstance();
    private Map<IConnection, KeepAliveWorker> workers = new HashMap<IConnection, KeepAliveWorker>();

    public void activate(BundleContext context) {
        this.logger.info((miworkplace.common.debug.Option)Option.conn, "Activating keep alive service");
    }

    public void handleEvent(Event event) {
        IConnection connection = (IConnection)event.getProperty("org.eclipse.e4.data");
        KeepAliveWorker oldWorker = this.workers.remove(connection);
        if (oldWorker != null) {
            oldWorker.stop();
        }
        KeepAliveWorker worker = new KeepAliveWorker(connection);
        this.workers.put(connection, worker);
    }
}

