/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.services.active.connection;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.services.api.IActiveConnectionService;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class ActiveConnectionService
implements IActiveConnectionService,
EventHandler {
    private Debug logger = Debug.getInstance();
    private EventAdmin eventAdmin;
    private IConnectionManager connectionManager;
    private Stack<IConnection> lastUsedConnectionStack = new Stack();

    public void activate(BundleContext context) {
        this.logger.info((Option)miworkplace.services.debug.Option.conn, "Activating active connections service");
    }

    void bindConnectionManager(IConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    void unbindConnectionManager(IConnectionManager connectionManager) {
        this.connectionManager = null;
    }

    @Override
    public IConnection getLastUsedActiveConnection() {
        return this.getCurrentActiveConnection();
    }

    private IConnection getCurrentActiveConnection() {
        return this.lastUsedConnectionStack.isEmpty() ? null : this.lastUsedConnectionStack.peek();
    }

    void bindEventService(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    void unbindEventService(EventAdmin eventAdmin) {
        this.eventAdmin = null;
    }

    @Override
    public List<IConnection> getActiveConnections() {
        LinkedList<IConnection> connections = new LinkedList<IConnection>();
        for (IConnection connection : this.connectionManager.list()) {
            if (!connection.isConnected()) continue;
            connections.add(connection);
        }
        return connections;
    }

    public void handleEvent(Event event) {
        IConnection connection = (IConnection)event.getProperty("org.eclipse.e4.data");
        if (connection == null) {
            return;
        }
        if ("miworkplace/connection/connected".equals(event.getTopic())) {
            this.addUsedConnection(connection);
        } else if ("miworkplace/connection/disconnected".equals(event.getTopic())) {
            this.removeUsedConnection(connection);
        } else if ("miworkplace/connection/used".equals(event.getTopic())) {
            this.addUsedConnection(connection);
        }
    }

    private void addUsedConnection(IConnection connection) {
        boolean changed = false;
        if (this.lastUsedConnectionStack.contains(connection)) {
            this.lastUsedConnectionStack.remove(connection);
            this.lastUsedConnectionStack.push(connection);
            changed = true;
        } else {
            this.lastUsedConnectionStack.push(connection);
            changed = true;
        }
        if (changed) {
            this.postEvent("miworkplace/services/last_used_connection", connection);
            this.logger.debug((Option)miworkplace.services.debug.Option.conn, "Current active connection: " + connection.getName());
        }
    }

    private void removeUsedConnection(IConnection connection) {
        if (!this.lastUsedConnectionStack.isEmpty()) {
            IConnection top = (IConnection)this.lastUsedConnectionStack.firstElement();
            this.lastUsedConnectionStack.remove(connection);
            if (top.equals(connection)) {
                this.postEvent("miworkplace/services/last_used_connection", this.getCurrentActiveConnection());
                this.logger.debug((Option)miworkplace.services.debug.Option.conn, "Current active connection: " + connection.getName());
            }
        }
    }

    private void postEvent(String topic, IConnection conn) {
        HashMap<String, IConnection> map = new HashMap<String, IConnection>();
        map.put("org.eclipse.e4.data", conn);
        Event event = new Event(topic, map);
        this.eventAdmin.postEvent(event);
    }
}

