/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.widgets;

import miworkplace.i18n.Messages;
import miworkplace.ui.api.IRemoteEditor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class StatusBarOverwriteControl
implements EventHandler {
    private CLabel label;

    public StatusBarOverwriteControl(Composite parent, int style) {
        this.label = new CLabel(parent, style);
    }

    public StatusBarOverwriteControl setEventBroker(IEventBroker eventBroker) {
        eventBroker.subscribe("miworkplace/ui/editor/overwrite/changed", (EventHandler)this);
        eventBroker.subscribe("miworkplace/ui/editor/focus/gained", (EventHandler)this);
        eventBroker.subscribe("miworkplace/ui/editor/closed", (EventHandler)this);
        return this;
    }

    public void setLayoutData(Object data) {
        this.label.setLayoutData(data);
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.label;
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("miworkplace/ui/editor/overwrite/changed")) {
            Boolean overwriteMode = (Boolean)event.getProperty("org.eclipse.e4.data");
            this.updateLabel(overwriteMode);
        } else if (event.getTopic().equals("miworkplace/ui/editor/focus/gained")) {
            Object data = event.getProperty("org.eclipse.e4.data");
            if (data instanceof IRemoteEditor) {
                this.updateLabel(((IRemoteEditor)data).isOverwriteMode());
            }
        } else if (event.getTopic().equals("miworkplace/ui/editor/closed")) {
            this.clearLabel();
        }
    }

    private void clearLabel() {
        if (!this.label.isDisposed()) {
            this.label.setText("");
        }
    }

    private void updateLabel(Boolean overwriteMode) {
        if (!this.label.isDisposed()) {
            this.label.setText(overwriteMode != false ? Messages.ui_statusbar_overwrite : Messages.ui_statusbar_insert);
        }
    }
}

