/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.widgets;

import com.ibm.as400.access.QSYSObjectPathName;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;

public class RemoteCheckingInputDialog
extends InputDialog {
    private IConnection connection;
    private IConnectionUtilities connUtil;
    private String sourceLibraryName;

    public RemoteCheckingInputDialog(IConnection connection, IConnectionUtilities connUtil, String sourceLibraryName, Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
        super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        this.connection = connection;
        this.connUtil = connUtil;
        this.sourceLibraryName = sourceLibraryName;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String value = StringUtils.defaultString((String)this.getText().getText());
            QSYSObjectPathName path = this.buildDestinationPath(this.sourceLibraryName, value);
            if (!this.connUtil.doesObjectExist(this.connection, path.getPath())) {
                this.setErrorMessage(String.format(Messages.ui_dialog_remote_exist_error, path.getLibraryName(), path.getObjectName()));
            } else {
                super.buttonPressed(buttonId);
            }
        } else {
            this.cancelPressed();
        }
    }

    private QSYSObjectPathName buildDestinationPath(String sourceLibraryName, String destination) {
        String[] parts = destination.split("/");
        QSYSObjectPathName name = parts.length == 1 ? new QSYSObjectPathName(sourceLibraryName, parts[0], "FILE") : new QSYSObjectPathName(parts[0], parts[1], "FILE");
        return name;
    }

    protected boolean isResizable() {
        return true;
    }
}

