/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.widgets;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import miworkplace.common.ui.MiniMessage;
import miworkplace.i18n.Messages;
import miworkplace.ui.widgets.IModifier;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class LibraryList
extends Composite {
    private Table fTable;
    private TableViewer fViewer;
    private ICellEditorValidator fValidator = value -> {
        int length = value.toString().trim().length();
        if (length > 10) {
            String message = MessageFormat.format(Messages.liblist_notvalid, value.toString(), 10);
            MiniMessage.get((int)3000).above((Control)this.fTable).open(message);
            return message;
        }
        return null;
    };
    private IModifier fModifier = value -> value.trim().toUpperCase();

    public LibraryList(Composite parent, int style, ICellEditorValidator validator) {
        this(parent, style);
        this.fValidator = validator;
        if (this.fValidator == null) {
            this.fValidator = pValue -> null;
        }
    }

    public LibraryList(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        TableColumnLayout tcl_composite = new TableColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        this.fViewer = new TableViewer(composite, 65536);
        this.fTable = this.fViewer.getTable();
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(false);
        this.fViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        DragSource dragSource = new DragSource((Control)this.fTable, 2);
        dragSource.setDragSourceEffect((DragSourceEffect)new TableDragSourceEffect(this.fTable));
        dragSource.setTransfer(types);
        dragSource.addDragListener(this.getDragListener(this.fTable));
        DropTarget dropTarget = new DropTarget((Control)this.fTable, 2);
        dropTarget.setDropTargetEffect((DropTargetEffect)new TableDropTargetEffect(this.fTable));
        dropTarget.setTransfer(types);
        dropTarget.addDropListener((DropTargetListener)this.getDropListener(this.fTable));
        final TextCellEditor cellEditor = new TextCellEditor((Composite)this.fTable);
        cellEditor.getControl().setMenu(this.getPasteMenu((Text)cellEditor.getControl()));
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.fViewer, 0);
        tableViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.fViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return cellEditor;
            }

            protected Object getValue(Object element) {
                return LibraryList.this.fModifier.modify(element.toString());
            }

            protected void setValue(Object element, Object pValue) {
                int index = LibraryList.this.getItemIndex(LibraryList.this.fViewer, (String)element);
                if (index == 0) {
                    List<String> values = Arrays.asList(pValue.toString().trim().split("(\\s+,+\\s+|\\s+|\\s+,+|,\\s+|,+)"));
                    for (String value : values) {
                        if (value.trim().isEmpty() || LibraryList.this.fValidator.isValid((Object)value) != null) continue;
                        boolean found = false;
                        TableItem[] tableItemArray = LibraryList.this.fViewer.getTable().getItems();
                        int n = tableItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem item = tableItemArray[n2];
                            if (item.getText().equals(value)) {
                                found = true;
                                break;
                            }
                            ++n2;
                        }
                        if (found) continue;
                        LibraryList.this.fViewer.insert((Object)LibraryList.this.fModifier.modify(value), -1);
                    }
                } else if (LibraryList.this.fValidator.isValid(pValue) == null) {
                    if (pValue.toString().trim().isEmpty()) {
                        LibraryList.this.fViewer.remove(element);
                    } else {
                        LibraryList.this.fViewer.replace((Object)LibraryList.this.fModifier.modify(pValue.toString()), index);
                    }
                }
            }
        });
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return element.toString().isEmpty() ? Messages.liblist_newentries : element.toString();
            }

            public Color getBackground(Object pElement) {
                return pElement.toString().isEmpty() ? LibraryList.this.getDisplay().getSystemColor(38) : null;
            }
        });
        TableColumn tblclmnCol = tableViewerColumn.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnCol, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
    }

    private Menu getPasteMenu(Text pParent) {
        Menu menu = new Menu((Control)pParent);
        MenuItem item = new MenuItem(menu, 0);
        item.addListener(13, e -> {
            TextTransfer textTransfer;
            Clipboard clipboard = new Clipboard(this.getDisplay());
            String textData = (String)clipboard.getContents((Transfer)(textTransfer = TextTransfer.getInstance()));
            if (textData != null) {
                textData = textData.replaceAll(System.lineSeparator(), " ");
                textData = textData.replaceAll("\\s{2,}", " ");
            }
            pParent.setText(textData);
            clipboard.dispose();
        });
        item.setText(Messages.ui_paste);
        this.addDisposeListener(e -> menu.dispose());
        return menu;
    }

    private DropTargetAdapter getDropListener(final Table ptable) {
        return new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                event.feedback = 24;
                if (event.item != null) {
                    TableItem item = (TableItem)event.item;
                    Point pt = ptable.getDisplay().map(null, (Control)ptable, event.x, event.y);
                    Rectangle bounds = item.getBounds();
                    event.feedback = pt.y < bounds.y + bounds.height / 3 ? (event.feedback |= 2) : (pt.y > bounds.y + 2 * bounds.height / 3 ? (event.feedback |= 4) : (event.feedback |= 1));
                }
            }

            public void drop(DropTargetEvent event) {
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                if (event.item != null) {
                    int index = LibraryList.this.getItemIndex(LibraryList.this.fViewer, (String)event.item.getData());
                    if (index == 0) {
                        index = 1;
                    }
                    LibraryList.this.fViewer.remove(event.data);
                    LibraryList.this.fViewer.insert(event.data, index);
                }
            }
        };
    }

    private int getItemIndex(TableViewer pViewer, String pItem) {
        int index = 0;
        while (index < pViewer.getTable().getItemCount()) {
            if (pViewer.getElementAt(index).equals(pItem)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private DragSourceListener getDragListener(final Table ptable) {
        final TableItem[] dragSourceItem = new TableItem[1];
        return new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                TableItem[] selection = ptable.getSelection();
                if (selection.length == 1 && !selection[0].getText().trim().isEmpty()) {
                    event.doit = true;
                    dragSourceItem[0] = selection[0];
                } else {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = dragSourceItem[0].getText();
            }

            public void dragFinished(DragSourceEvent event) {
                dragSourceItem[0] = null;
            }
        };
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout(1, true));
        final LibraryList c2 = new LibraryList((Composite)shell, 2048);
        GridData gridData = new GridData(4, 4, true, true);
        c2.setLayoutData(gridData);
        c2.setInput(new String[]{"AAAA", "bbb", "ccc", "ddd", "eee", "fff", "ggg", "hhh"});
        Button button = new Button((Composite)shell, 8);
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.setText("List");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] elements = c2.getElements();
                int i = 0;
                while (i < elements.length) {
                    System.out.println(elements[i]);
                    ++i;
                }
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public String[] getElements() {
        if (this.fTable.getItemCount() == 0) {
            return new String[0];
        }
        ArrayList<String> elements = new ArrayList<String>();
        int i = 0;
        while (i < this.fTable.getItemCount() - 1) {
            String lib = this.fViewer.getElementAt(i + 1).toString();
            if (!elements.contains(lib)) {
                elements.add(lib);
            }
            ++i;
        }
        return elements.toArray(new String[0]);
    }

    public TableViewer getViewer() {
        return this.fViewer;
    }

    public void setInput(String[] pInput) {
        ArrayList<String> input = new ArrayList<String>();
        input.add("");
        String[] stringArray = pInput;
        int n = pInput.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (this.fValidator.isValid((Object)element) == null && !element.trim().isEmpty()) {
                input.add(element);
            }
            ++n2;
        }
        this.fViewer.setInput((Object)input.toArray());
    }

    public LibraryList setModifier(IModifier pModifier) {
        this.fModifier = pModifier;
        return this;
    }
}

