/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.widgets;

import miworkplace.ui.api.Position;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EditorPositionControl
implements EventHandler {
    private CLabel label;

    public EditorPositionControl(Composite parent, int style) {
        this.label = new CLabel(parent, style);
    }

    public EditorPositionControl setEventBroker(IEventBroker eventBroker) {
        eventBroker.subscribe("miworkplace/ui/editor/position/changed", (EventHandler)this);
        eventBroker.subscribe("miworkplace/ui/editor/closed", (EventHandler)this);
        return this;
    }

    public void setLayoutData(Object data) {
        this.label.setLayoutData(data);
    }

    public void dispose() {
    }

    public Control getControl() {
        return this.label;
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("miworkplace/ui/editor/position/changed")) {
            Position position = (Position)event.getProperty("org.eclipse.e4.data");
            this.updateLabel(position);
        } else if (event.getTopic().equals("miworkplace/ui/editor/closed")) {
            this.clearLabel();
        }
    }

    private void clearLabel() {
        if (!this.label.isDisposed()) {
            this.label.setText("");
        }
    }

    private void updateLabel(Position position) {
        if (!this.label.isDisposed()) {
            this.label.setText(position.x + " : " + position.y);
        }
    }
}

