/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class SwtTreeHelper {
    private SwtTreeHelper() {
    }

    public static Point getLocation(Control container, Control control) {
        Point containerLocation = container.toDisplay(0, 0);
        Point controlLocation = control.toDisplay(0, 0);
        return new Point(controlLocation.x - containerLocation.x, controlLocation.y - containerLocation.y);
    }

    public static boolean isVisible(TreeViewer treeViewer, Object item, TreeItemDataComparator itemComparator) {
        TreeItem visibleItem = SwtTreeHelper.getVisibleItem(treeViewer, item, itemComparator);
        return itemComparator.matchedItem(visibleItem, item);
    }

    public static TreeItem getVisibleItem(TreeViewer treeViewer, Object item, TreeItemDataComparator itemComparator) {
        TreePath[] expandedTreePaths = treeViewer.getExpandedTreePaths();
        treeViewer.expandToLevel(item, 0);
        treeViewer.setExpandedTreePaths(expandedTreePaths);
        TreeItem foundItem = SwtTreeHelper.findExpand(treeViewer, item, itemComparator);
        TreeItem visibleItem = SwtTreeHelper.visibleItem(foundItem);
        return visibleItem;
    }

    public static Point getItemPoint(TreeViewer treeViewer, Object item, TreeItemDataComparator itemComparator) {
        Tree tree = treeViewer.getTree();
        TreePath[] expandedTreePaths = treeViewer.getExpandedTreePaths();
        treeViewer.expandToLevel(item, 0);
        treeViewer.setExpandedTreePaths(expandedTreePaths);
        int headerHeight = tree.getHeaderVisible() ? tree.getHeaderHeight() : 0;
        int lineWidth = tree.getLinesVisible() ? tree.getGridLineWidth() : 0;
        int itemHeight = tree.getItemHeight() + lineWidth;
        int itemOffset = tree.getVerticalBar().getSelection();
        TreeItem foundItem = SwtTreeHelper.findExpand(treeViewer, item, itemComparator);
        TreeItem visibleItem = SwtTreeHelper.visibleItem(foundItem);
        TreeItem[] expandedItemsBefore = SwtTreeHelper.expandedItemsBefore(visibleItem);
        int countElementsBefore = expandedItemsBefore != null ? expandedItemsBefore.length : 0;
        int index = countElementsBefore - itemOffset;
        int lowerBound = index * (itemHeight - lineWidth);
        int upperBound = (index + 1) * (itemHeight - lineWidth);
        return new Point(headerHeight + lowerBound, headerHeight + upperBound);
    }

    public static TreePath findPath(TreeViewer treeViewer, Object data, IElementComparer comparer) {
        IContentProvider contentProvider = treeViewer.getContentProvider();
        if (contentProvider instanceof ITreeContentProvider) {
            ITreeContentProvider tcp = (ITreeContentProvider)contentProvider;
            Object[] elements = tcp.getElements(treeViewer.getInput());
            TreePath path = SwtTreeHelper.createPath(data, tcp, elements, TreePath.EMPTY, comparer);
            return path;
        }
        return null;
    }

    private static TreeItem findExpand(TreeViewer treeViewer, Object data, TreeItemDataComparator compare) {
        TreeItem result = SwtTreeHelper.find(data, compare, treeViewer.getTree().getItems());
        if (result != null) {
            treeViewer.expandToLevel((Object)result, 0);
        }
        return result;
    }

    private static TreeItem find(Object data, TreeItemDataComparator compare, TreeItem[] items) {
        HashSet<TreeItem> visitedObjects = new HashSet<TreeItem>();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem != null && !visitedObjects.contains(treeItem)) {
                visitedObjects.add(treeItem);
                if (compare.matchedItem(treeItem, data)) {
                    return treeItem;
                }
                TreeItem[] children = treeItem.getItems();
                TreeItem found = SwtTreeHelper.find(data, compare, children);
                if (found != null) {
                    return found;
                }
            }
            ++n2;
        }
        return null;
    }

    private static TreeItem visibleItem(TreeItem item) {
        TreeItem[] treePath = SwtTreeHelper.treePath(item);
        int i = 0;
        while (i < treePath.length) {
            TreeItem current = treePath[i];
            if (current == item) {
                return item;
            }
            if (!current.getExpanded()) {
                return current;
            }
            ++i;
        }
        return treePath.length > 0 ? treePath[0] : null;
    }

    private static TreeItem[] treePath(TreeItem item) {
        ArrayList<TreeItem> itemList = new ArrayList<TreeItem>();
        TreeItem current = item;
        while (current != null) {
            itemList.add(0, current);
            current = current.getParentItem();
        }
        return itemList.toArray(new TreeItem[itemList.size()]);
    }

    private static TreeItem[] expandedItemsBefore(TreeItem item) {
        ArrayList<TreeItem> list = new ArrayList<TreeItem>();
        SwtTreeHelper.fillItemsBefore(item, list);
        return list.toArray(new TreeItem[list.size()]);
    }

    private static void fillItemsBefore(TreeItem item, List<TreeItem> list) {
        if (item != null) {
            TreeItem[] siblingsBefore = SwtTreeHelper.siblingsBefore(item);
            int i = siblingsBefore.length - 1;
            while (i >= 0) {
                TreeItem sibling = siblingsBefore[i];
                if (sibling.getExpanded()) {
                    List<TreeItem> children = SwtTreeHelper.children(sibling);
                    list.addAll(0, children);
                }
                list.add(0, sibling);
                --i;
            }
            TreeItem parentItem = item.getParentItem();
            if (parentItem != null) {
                list.add(0, parentItem);
                if (parentItem.getExpanded()) {
                    SwtTreeHelper.fillItemsBefore(parentItem, list);
                }
            }
        }
    }

    private static TreeItem[] siblingsBefore(TreeItem item) {
        int indexOf;
        TreeItem parentItem = item.getParentItem();
        if (parentItem != null) {
            int indexOf2 = parentItem.indexOf(item);
            if (indexOf2 > 0) {
                TreeItem[] items = parentItem.getItems();
                TreeItem[] result = new TreeItem[indexOf2];
                System.arraycopy(items, 0, result, 0, indexOf2);
                return result;
            }
        } else if (item.getParent() != null && (indexOf = item.getParent().indexOf(item)) > 0) {
            TreeItem[] items = item.getParent().getItems();
            TreeItem[] result = new TreeItem[indexOf];
            System.arraycopy(items, 0, result, 0, indexOf);
            return result;
        }
        return new TreeItem[0];
    }

    private static List<TreeItem> children(TreeItem item) {
        TreeItem[] items;
        ArrayList<TreeItem> children = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray = items = item.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem.getData() != null) {
                children.add(treeItem);
                if (treeItem.getExpanded()) {
                    children.addAll(SwtTreeHelper.children(treeItem));
                }
            }
            ++n2;
        }
        return children;
    }

    private static TreePath createPath(Object data, ITreeContentProvider cp, Object[] elements, TreePath parentPath, IElementComparer comparer) {
        if (elements != null) {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object != null && !SwtTreeHelper.contains(parentPath, object, comparer)) {
                    TreePath path = parentPath.createChildPath(object);
                    if (SwtTreeHelper.equals(data, object, comparer)) {
                        return path;
                    }
                    Object[] children = cp.getChildren(object);
                    TreePath result = SwtTreeHelper.createPath(data, cp, children, path, comparer);
                    if (result != null) {
                        return result;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private static boolean contains(TreePath p, Object data, IElementComparer comparer) {
        int i = 0;
        while (i < p.getSegmentCount()) {
            Object segment = p.getSegment(i);
            if (SwtTreeHelper.equals(segment, data, comparer)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean equals(Object o1, Object o2, IElementComparer comparer) {
        if (comparer != null) {
            return comparer.equals(o1, o2);
        }
        return Objects.equals(o1, o2);
    }

    public static interface TreeItemDataComparator
    extends IElementComparer {
        public static final TreeItemDataComparator DEFAULT_COMPARATOR = new TreeItemDataComparator(){

            @Override
            public boolean matchedItem(TreeItem item, Object data) {
                return item != null && this.equals(item.getData(), data);
            }

            public boolean equals(Object a, Object b) {
                return Objects.equals(a, b);
            }

            public int hashCode(Object element) {
                return element != null ? element.hashCode() : 0;
            }
        };

        public boolean matchedItem(TreeItem var1, Object var2);
    }
}

