/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.util;

import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.UserSpace;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import miworkplace.common.ObjectNotFoundException;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.QSYSObject;
import miworkplace.common.model.RemoteObject;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ObjectProperty;
import miworkplace.services.util.ObjectHelper;
import miworkplace.ui.Constants;
import miworkplace.ui.api.WorkspaceUtil;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;

public class ObjectLoader
extends Job {
    private final int OFFSET_US_LISTSECTION = 124;
    private final int OFFSET_US_LIST_ENTRIES = 132;
    private final int OFFSET_US_LIST_ENTRY_SIZE = 136;
    private final int OFFSET_LIST_OBJECT_NAME = 0;
    private final int OFFSET_LIST_OBJECT_LIBRARY = 10;
    private final int OFFSET_LIST_OBJECT_TYPE = 20;
    private final int OFFSET_LIST_OBJECT_ATTR = 31;
    private final int OFFSET_LIST_OBJECT_TEXT_DESCR = 41;
    private final int OFFSET_LIST_OBJECT_USER_DEFINED_ATTR = 91;
    private final int OFFSET_LIST_OBJECT_OWNER = 112;
    private final int OFFSET_LIST_OBJECT_DOMAIN = 122;
    private final int OFFSET_LIST_OBJECT_CREATION_DATE = 124;
    private final int OFFSET_LIST_OBJECT_CHANGE_DATE = 132;
    private final int OFFSET_LIST_OBJECT_STORAGE = 140;
    private final int OFFSET_LIST_OBJECT_COMPRESSION_STATUS = 150;
    private final int OFFSET_LIST_OBJECT_ALLOW_CHANGE_BY_PROGRAM = 151;
    private final int OFFSET_LIST_OBJECT_CHANGED_BY_PROGRAM = 152;
    private final int OFFSET_LIST_OBJECT_AUDITING_VALUE = 153;
    private final int OFFSET_LIST_OBJECT_DIGITALLY_SIGNED = 163;
    private Debug logger = Debug.getInstance();
    @Inject
    private UISynchronize sync;
    @Inject
    private IEclipseContext context;
    @Inject
    private IConnectionUtilities connUtil;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IObjectPropertiesStore objectPropertiesStore;
    private AS400Bin4 as400Binary;
    private CharConverter conv;
    @Inject
    @Named(value="miworkplace.ui.library")
    @Optional
    private IRemoteObject library;
    private Long sourceId = -1L;

    public ObjectLoader() {
        super(MessageFormat.format(Messages.ui_objloader_title, "*NOTSET"));
        this.setPriority(20);
    }

    public IStatus run(IProgressMonitor monitor) {
        this.logger.traceEntry((Option)miworkplace.ui.debug.Option.loading, new Object[]{monitor});
        IStatus status = this.doRun(monitor);
        this.logger.traceExit((Option)miworkplace.ui.debug.Option.loading, (Object)status);
        return status;
    }

    private IStatus doRun(IProgressMonitor pMonitor) {
        try {
            List<IRemoteObject> files = null;
            if (this.getLibrary().areChildrenLoaded()) {
                files = this.workspaceStore.getObjects(this.getLibrary());
            } else {
                this.logger.info((Option)miworkplace.ui.debug.Option.loading, "Loading " + this.getLibrary().getName());
                files = this.loadFiles(this.getLibrary());
                List objects = this.workspaceStore.getObjects(this.getLibrary());
                for (IRemoteObject ro : objects) {
                    this.workspaceStore.remove(ro);
                }
                for (IRemoteObject file : files) {
                    this.workspaceStore.add(file);
                }
            }
            this.library.setChildrenLoaded(true);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("org.eclipse.e4.data", files);
            map.put("viewerId", this.getSourceId());
            map.put("connection", this.getLibrary().getConnection().getName());
            map.put("path", this.getLibrary().getPath());
            this.eventBroker.post("miworkplace/ui/loader/objects/loaded", map);
            return new Status(0, Constants.PLUGIN_ID, String.format(Messages.ui_objloader_success, this.getLibrary().getName()));
        }
        catch (ObjectNotFoundException onfe) {
            this.sync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Notifier.warn((String)Messages.ui_objloader_notify_title, (String)onfe.getMessage());
                }
            });
            return new Status(2, Constants.PLUGIN_ID, onfe.getMessage());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return new Status(4, Constants.PLUGIN_ID, String.format(Messages.ui_objloader_error, this.getLibrary().getName()), (Throwable)e);
        }
    }

    public List<IRemoteObject> loadFiles(IRemoteObject library) throws Exception {
        if (!this.connUtil.doesObjectExist(library.getConnection(), library.getPath())) {
            throw new ObjectNotFoundException(String.format(Messages.ui_objloader_notfound, library.getName()));
        }
        ArrayList<IRemoteObject> files = new ArrayList<IRemoteObject>(20);
        byte[] byteArr = new byte[4];
        byte[] userSpaceBytes = new byte[65535];
        int entrySize = 0;
        int listPosition = 0;
        int listEntries = 0;
        UserSpace us = new UserSpace(library.getConnection().getSystem(), QSYSObjectPathName.toPath((String)"QTEMP", (String)"QUSLOBJ", (String)"USRSPC"));
        us.setMustUseProgramCall(true);
        try {
            us.create(327675, true, "MIWORKPLAC", (byte)0, "Userspace for MiWorkplace loading objects", "*ALL");
            this.as400Binary = new AS400Bin4();
            this.conv = null;
            try {
                this.conv = new CharConverter(library.getConnection().getSystem().getCcsid(), library.getConnection().getSystem());
            }
            catch (Exception e) {
                throw new RuntimeException("Error during CharConverter building.", e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error during userspace creation in method loadObjects.", e);
        }
        ProgramCall program = new ProgramCall(library.getConnection().getSystem());
        String programName = "/QSYS.LIB/QUSLOBJ.PGM";
        ProgramParameter[] parameterList = new ProgramParameter[4];
        AS400Text text = new AS400Text(20, library.getConnection().getSystem());
        parameterList[0] = new ProgramParameter(text.toBytes((Object)"QUSLOBJ   QTEMP     "));
        parameterList[1] = new ProgramParameter(text.toBytes((Object)"OBJL0300"));
        parameterList[3] = new ProgramParameter(text.toBytes((Object)"*ALL      "));
        int userspacePosition = 0;
        int userspaceOffset = 0;
        int entryPosition = 0;
        QSYSObjectPathName objBuffer = new QSYSObjectPathName(library.getName(), "*ALL", "*ALL");
        try {
            if (library.getConnection().isConnected() && us.exists()) {
                parameterList[2] = new ProgramParameter(text.toBytes((Object)objBuffer.toQualifiedObjectName()));
                program.setProgram(programName, parameterList);
                if (program.run()) {
                    us.read(userSpaceBytes, userspacePosition);
                    System.arraycopy(userSpaceBytes, 124, byteArr, 0, 4);
                    listPosition = this.as400Binary.toInt(byteArr);
                    System.arraycopy(userSpaceBytes, 132, byteArr, 0, 4);
                    listEntries = this.as400Binary.toInt(byteArr);
                    System.arraycopy(userSpaceBytes, 136, byteArr, 0, 4);
                    entrySize = this.as400Binary.toInt(byteArr);
                    String name = null;
                    String type = null;
                    String attr = null;
                    String textDesc = null;
                    String creationDate = null;
                    String changeDate = null;
                    userspaceOffset = listPosition;
                    int i = 0;
                    while (i < listEntries) {
                        if (entryPosition * entrySize + 31 + userspaceOffset + 10 > userSpaceBytes.length) {
                            userspacePosition = us.read(userSpaceBytes, i * entrySize + listPosition);
                            userspaceOffset = 0;
                            entryPosition = 0;
                        }
                        name = this.conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + 0 + userspaceOffset, 10).trim();
                        type = this.conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + 20 + userspaceOffset, 10).trim();
                        attr = this.conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + 31 + userspaceOffset, 10).trim();
                        textDesc = this.conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + 41 + userspaceOffset, 50).trim();
                        int arrayStart = entryPosition * entrySize + 124 + userspaceOffset;
                        int arrayEnd = arrayStart + 8;
                        creationDate = Hex.encodeHexString((byte[])Arrays.copyOfRange(userSpaceBytes, arrayStart, arrayEnd));
                        arrayStart = entryPosition * entrySize + 132 + userspaceOffset;
                        arrayEnd = arrayStart + 8;
                        changeDate = Hex.encodeHexString((byte[])Arrays.copyOfRange(userSpaceBytes, arrayStart, arrayEnd));
                        IResource fileResource = WorkspaceUtil.buildObjectResource(library, name, RemoteObject.getTypeByValue((String)type));
                        IRemoteObject object = QSYSObject.create((IConnection)library.getConnection(), (IResource)fileResource, (IRemoteObject.Type)RemoteObject.getTypeByValue((String)type), (String)type, null, (String)attr);
                        HashMap<ObjectProperty, Object> properties = new HashMap<ObjectProperty, Object>();
                        properties.put(ObjectProperty.notloaded, Boolean.TRUE);
                        properties.put(ObjectProperty.name, name);
                        properties.put(ObjectProperty.library, library.getName());
                        properties.put(ObjectProperty.rawcreationdate, creationDate);
                        properties.put(ObjectProperty.rawchangedate, changeDate);
                        properties.put(ObjectProperty.type, type);
                        properties.put(ObjectProperty.attribute, attr);
                        properties.put(ObjectProperty.textdescription, textDesc);
                        if (this.objectPropertiesStore.contains(object, properties)) {
                            if (type.equals(IRemoteObject.Type.file.abbr())) {
                                Map objDescProperties = this.objectPropertiesStore.get(object);
                                try {
                                    Object value = objDescProperties.get(ObjectProperty.attribute);
                                    IRemoteObject.Attribute attribute = null;
                                    IRemoteObject.Attribute[] attributeArray = IRemoteObject.Attribute.values();
                                    int n = attributeArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IRemoteObject.Attribute at = attributeArray[n2];
                                        if (at.attr().equals(value)) {
                                            attribute = at;
                                            break;
                                        }
                                        ++n2;
                                    }
                                    if (attribute != null) {
                                        object = QSYSObject.create((IConnection)library.getConnection(), (IResource)fileResource, (IRemoteObject.Type)RemoteObject.getTypeByValue((String)type), (String)type, attribute, (String)attr);
                                    }
                                    object.setAttribute(attribute);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {}
                            }
                        } else {
                            if (type.equals(IRemoteObject.Type.file.abbr())) {
                                if (attr.equals(IRemoteObject.Attribute.physicalfile.attr())) {
                                    try {
                                        if (ObjectHelper.isSourceFile((IRemoteObject)object)) {
                                            object = QSYSObject.create((IConnection)library.getConnection(), (IResource)fileResource, (IRemoteObject.Type)RemoteObject.getTypeByValue((String)type), (String)type, (IRemoteObject.Attribute)IRemoteObject.Attribute.sourcefile, (String)attr);
                                            object.setAttribute(IRemoteObject.Attribute.sourcefile);
                                        } else {
                                            object = QSYSObject.create((IConnection)library.getConnection(), (IResource)fileResource, (IRemoteObject.Type)RemoteObject.getTypeByValue((String)type), (String)type, (IRemoteObject.Attribute)IRemoteObject.Attribute.datafile, (String)attr);
                                            object.setAttribute(IRemoteObject.Attribute.datafile);
                                        }
                                    }
                                    catch (Exception e) {
                                        object = QSYSObject.create((IConnection)library.getConnection(), (IResource)fileResource, (IRemoteObject.Type)RemoteObject.getTypeByValue((String)type), (String)type, (IRemoteObject.Attribute)IRemoteObject.Attribute.datafile, (String)attr);
                                        object.setAttribute(IRemoteObject.Attribute.datafile);
                                        this.logger.warning(MessageFormat.format("Could not determine if {0} is source file. Assume database file.", name), (Throwable)e);
                                    }
                                    properties.put(ObjectProperty.attribute, object.getAttribute().attr());
                                } else if (attr.equals(IRemoteObject.Attribute.logicalfile.attr())) {
                                    object.setAttribute(IRemoteObject.Attribute.logicalfile);
                                } else if (attr.equals(IRemoteObject.Attribute.savefile.attr())) {
                                    object.setAttribute(IRemoteObject.Attribute.savefile);
                                } else if (attr.equals(IRemoteObject.Attribute.printerfile.attr())) {
                                    object.setAttribute(IRemoteObject.Attribute.printerfile);
                                } else if (attr.equals(IRemoteObject.Attribute.displayfile.attr())) {
                                    object.setAttribute(IRemoteObject.Attribute.displayfile);
                                }
                            }
                            this.objectPropertiesStore.put(object, properties);
                        }
                        object.setRawCreationDate(creationDate);
                        object.setRawChangeDate(changeDate);
                        files.add(object);
                        ++entryPosition;
                        ++i;
                    }
                } else {
                    AS400Message[] msgList = program.getMessageList();
                    StringBuilder as400ErrorMsg = new StringBuilder();
                    int j = 0;
                    while (j < msgList.length) {
                        as400ErrorMsg.append(MessageFormat.format("{0} - {1} ", msgList[j].getID(), msgList[j].getText()));
                        ++j;
                    }
                    Exception e = new Exception(String.format(Messages.ui_objloader_pgmcall_error, library.getName()));
                    this.logger.error(MessageFormat.format("Error during loading of objects in library {0}. Messages are: {1}", library.getName(), as400ErrorMsg.toString()), (Throwable)e);
                }
            }
            us.delete();
        }
        catch (Exception e) {
            throw new Exception(String.format(Messages.ui_objloader_error, library.getName()), e);
        }
        return files;
    }

    public IRemoteObject getLibrary() {
        return this.library;
    }

    public void setLibrary(IRemoteObject library) {
        this.library = library;
        this.setName(MessageFormat.format(Messages.ui_objloader_title, library.getName()));
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public boolean belongsTo(Object family) {
        return this.library.getConnection().getName().equals(family);
    }
}

