/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.task;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.Map;
import miworkplace.common.model.Task;
import miworkplace.common.model.Tasklist;
import miworkplace.i18n.Messages;
import miworkplace.ui.api.IRemoteEditor;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.service.event.Event;

public class TaskView {
    private static final String PREF_TABLE_COLUMN_DESCRIPTION = "tableColumnDescription";
    private static final String PREF_TABLE_COLUMN_SOURCE = "tableColumnSource";
    private static final String PREF_TABLE_COLUMN_LINE = "tableColumnLine";
    private static final String POPUPMENU_ID = "miworkplace.ui.menu.popup.task";
    private int tableColumnWidthDescription = 400;
    private int tableColumnWidthSource = 150;
    private int tableColumnWidthLine = 100;
    private StackLayout mainLayout;
    private TableViewer viewer;
    private Composite noEntriesLabel;
    private Composite parentComposite;
    private String latestEditorUri;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private ECommandService commandService;

    @Inject
    public TaskView(MPart part) {
        Map persistedState = part.getPersistedState();
        this.loadTableColumnWidth(persistedState);
    }

    private void loadTableColumnWidth(Map<String, String> persistedState) {
        if (persistedState.containsKey(PREF_TABLE_COLUMN_LINE)) {
            this.tableColumnWidthLine = Integer.valueOf(persistedState.get(PREF_TABLE_COLUMN_LINE));
        }
        if (persistedState.containsKey(PREF_TABLE_COLUMN_DESCRIPTION)) {
            this.tableColumnWidthDescription = Integer.valueOf(persistedState.get(PREF_TABLE_COLUMN_DESCRIPTION));
        }
        if (persistedState.containsKey(PREF_TABLE_COLUMN_SOURCE)) {
            this.tableColumnWidthSource = Integer.valueOf(persistedState.get(PREF_TABLE_COLUMN_SOURCE));
        }
    }

    @PostConstruct
    public void postConstruct(Composite parent, EMenuService menuService, final ESelectionService selectionService) {
        this.parentComposite = parent;
        this.mainLayout = new StackLayout();
        parent.setLayout((Layout)this.mainLayout);
        this.viewer = new TableViewer(parent, 66308);
        this.buildTable();
        this.noEntriesLabel = this.buildNoEntriesLabel(parent);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                selectionService.setSelection((Object)event.getSelection());
            }
        });
        this.viewer.setComparator((ViewerComparator)new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Task t1 = (Task)e1;
                Task t2 = (Task)e2;
                return t1.line - t2.line;
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    String commandId = "miworkplace.ui.command.task.goto";
                    ParameterizedCommand command = TaskView.this.commandService.createCommand(commandId, null);
                    TaskView.this.handlerService.executeHandler(command);
                }
            }
        });
        this.mainLayout.topControl = this.noEntriesLabel;
        menuService.registerContextMenu((Object)this.viewer.getControl(), POPUPMENU_ID);
    }

    private void buildTable() {
        Table table = this.viewer.getTable();
        TableColumn col1 = new TableColumn(table, 16384);
        col1.setText(Messages.ui_task_col_desc);
        col1.setWidth(this.tableColumnWidthDescription);
        TableColumn col2 = new TableColumn(table, 16384);
        col2.setText(Messages.ui_task_col_source);
        col2.setWidth(this.tableColumnWidthSource);
        TableColumn col3 = new TableColumn(table, 16384);
        col3.setText(Messages.ui_task_col_line);
        col3.setWidth(this.tableColumnWidthLine);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
    }

    private Composite buildNoEntriesLabel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.ui_task_notasks);
        return form;
    }

    @PersistState
    void persist(MPart part) {
        Map persistedState = part.getPersistedState();
        persistedState.put(PREF_TABLE_COLUMN_LINE, String.valueOf(this.tableColumnWidthLine));
        persistedState.put(PREF_TABLE_COLUMN_DESCRIPTION, String.valueOf(this.tableColumnWidthDescription));
        persistedState.put(PREF_TABLE_COLUMN_SOURCE, String.valueOf(this.tableColumnWidthSource));
    }

    @Inject
    @Optional
    public void notifiedPartActivation(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/activate") Event event, @Named(value="e4ActivePart") MPart part) {
        this.getEditorUri(part);
        this.processUiLifecycleEvent(part);
    }

    @Inject
    @Optional
    public void notifiedPartBringToTop(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event, @Named(value="e4ActivePart") MPart part) {
        this.getEditorUri(part);
        this.processUiLifecycleEvent(part);
    }

    @Inject
    @Optional
    public void notifiedAstChanged(@UIEventTopic(value="miworkplace/editor/reconciled") Event event, EPartService partService) {
        Collection parts = partService.getParts();
        for (MPart part : parts) {
            IRemoteEditor editor;
            Object object = part.getObject();
            if (object == null || !(object instanceof IRemoteEditor) || !(editor = (IRemoteEditor)object).getInputUri().equals(this.latestEditorUri)) continue;
            this.fillTaskViewFromEditorPart(part);
            break;
        }
    }

    private void getEditorUri(MPart part) {
        if (part == null || part.getObject() == null) {
            return;
        }
        Object o = part.getObject();
        if (o instanceof IRemoteEditor) {
            IRemoteEditor editor = (IRemoteEditor)o;
            this.latestEditorUri = editor.getInputUri();
        }
    }

    private void processUiLifecycleEvent(MPart part) {
        if (part == null || part.getObject() == null) {
            return;
        }
        this.fillTaskViewFromEditorPart(part);
    }

    private void fillTaskViewFromEditorPart(MPart part) {
        if (part.getObject() instanceof IAdaptable) {
            IAdaptable a = (IAdaptable)part.getObject();
            Object adaptedObject = a.getAdapter(Tasklist.class);
            if (adaptedObject == null) {
                this.viewer.setInput(null);
                this.viewer.refresh();
            } else {
                this.viewer.setInput((Object)((Tasklist)adaptedObject));
                this.viewer.refresh(true);
            }
        }
    }

    @Focus
    public void onFocus() {
        this.viewer.getControl().setFocus();
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        private Object[] noObjects = new Object[0];

        ViewContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Tasklist) {
                Tasklist tasklist = (Tasklist)inputElement;
                return tasklist.tasks;
            }
            return this.noObjects;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                TaskView.this.mainLayout.topControl = TaskView.this.noEntriesLabel;
            } else {
                Tasklist tasklist = (Tasklist)newInput;
                TaskView.this.mainLayout.topControl = tasklist.tasks == null || tasklist.tasks.length == 0 ? TaskView.this.noEntriesLabel : viewer.getControl();
            }
            TaskView.this.parentComposite.layout();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Task) {
                Task task = (Task)element;
                switch (columnIndex) {
                    case 0: {
                        return task.description;
                    }
                    case 1: {
                        return task.source;
                    }
                    case 2: {
                        return String.valueOf(task.line);
                    }
                }
                return null;
            }
            return null;
        }
    }
}

