/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.pref;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import miworkplace.i18n.Messages;
import miworkplace.services.api.ICompileSettingsProvider;
import miworkplace.services.api.ITextAttributeService;
import miworkplace.ui.pref.ColorsFontsPreferenceNode;
import miworkplace.ui.pref.CompilerPreferenceNode;
import miworkplace.ui.pref.UserActionPreferenceNode;
import miworkplace.ui.pref.api.FilePreference;
import miworkplace.ui.pref.api.IPreferenceNode;
import miworkplace.ui.pref.api.IPreferenceProvider;
import miworkplace.ui.pref.api.IPreferencesService;
import miworkplace.ui.pref.api.Preference;
import miworkplace.ui.pref.api.PreferenceNode;
import miworkplace.ui.pref.api.SelectionPreference;
import miworkplace.ui.themes.Theme;
import miworkplace.ui.useraction.IUserActionStore;

public class PreferenceProvider
implements IPreferenceProvider {
    private IPreferencesService preferenceService;
    private ITextAttributeService textAttributeService;
    private IUserActionStore userActionStore;
    private ICompileSettingsProvider compileSettingsProvider;
    private List<IPreferenceNode> preferenceNodes;

    public void activate() {
        this.preferenceNodes = new LinkedList<IPreferenceNode>();
        PreferenceNode generalNode = (PreferenceNode)new PreferenceNode().setId("miworkplace.ui.general").setName(Messages.ui_pref_node_general).setOrder(1);
        generalNode.setPreferences(this.buildGeneralPreferences());
        this.preferenceNodes.add((IPreferenceNode)generalNode);
        PreferenceNode networkNode = (PreferenceNode)new PreferenceNode().setId("miworkplace.ui.general.network").setName(Messages.ui_pref_node_network).setParentId("miworkplace.ui.general");
        networkNode.setPreferences(this.buildNetworkPreferences());
        this.preferenceNodes.add((IPreferenceNode)networkNode);
        PreferenceNode appearanceNode = (PreferenceNode)new PreferenceNode().setId("miworkplace.ui.appearance").setName(Messages.ui_pref_node_appearance);
        appearanceNode.setPreferences(this.buildAppearancePreferences());
        this.preferenceNodes.add((IPreferenceNode)appearanceNode);
        IPreferenceNode colorsFontsNode = new ColorsFontsPreferenceNode(this.textAttributeService).setId("miworkplace.ui.appearance.colorsfonts").setName(Messages.ui_pref_node_cf).setParentId("miworkplace.ui.appearance");
        this.preferenceNodes.add(colorsFontsNode);
        PreferenceNode printNode = (PreferenceNode)new PreferenceNode().setId("miworkplace.ui.print").setName(Messages.ui_pref_node_print);
        printNode.setPreferences(this.buildPrintPreferences());
        this.preferenceNodes.add((IPreferenceNode)printNode);
        PreferenceNode compileNode = (PreferenceNode)new PreferenceNode().setId("miworkplace.ui.compile").setName(Messages.ui_pref_compile);
        compileNode.setPreferences(this.buildCompilePreferences());
        this.preferenceNodes.add((IPreferenceNode)compileNode);
        PreferenceNode debugNode = (PreferenceNode)new PreferenceNode().setId("miworkplace.ui.debug").setName(Messages.ui_pref_node_debug);
        debugNode.setPreferences(this.buildDebugPreferences());
        this.preferenceNodes.add((IPreferenceNode)debugNode);
        this.preferenceNodes.add((IPreferenceNode)new CompilerPreferenceNode(this.compileSettingsProvider));
        this.preferenceNodes.add((IPreferenceNode)new UserActionPreferenceNode(this.userActionStore));
        PreferenceNode jobNode = (PreferenceNode)new PreferenceNode().setId("miworkplace.ui.jobs").setName(Messages.ui_jobs);
        jobNode.setPreferences(this.buildJobPreferences());
        this.preferenceNodes.add((IPreferenceNode)jobNode);
        PreferenceNode messagesNode = (PreferenceNode)new PreferenceNode().setId("miworkplace.ui.messages").setName(Messages.ui_message);
        messagesNode.setPreferences(this.buildMessagesPreferences());
        this.preferenceNodes.add((IPreferenceNode)messagesNode);
        if (this.preferenceService != null) {
            for (IPreferenceNode n : this.preferenceNodes) {
                this.preferenceService.add(n);
            }
        }
    }

    private Set<Preference> buildJobPreferences() {
        HashSet<Preference> preferences = new HashSet<Preference>();
        Preference preference = new Preference();
        preference.setId("miworkplace.ui.jobs.endjob.timeout");
        preference.setType(Integer.class);
        preference.setName(Messages.ui_pref_jobs_timeout);
        preference.setValue("30");
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.jobs.start");
        preference.setType(Boolean.class);
        preference.setName(Messages.ui_pref_jobs_start);
        preference.setValue(Boolean.FALSE.toString());
        preference.setDescription(Messages.ui_pref_jobs_start_desc);
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.jobs.interval");
        preference.setType(Integer.class);
        preference.setName(Messages.ui_pref_jobs_interval);
        preference.setValue("30");
        preference.setDescription(Messages.ui_pref_jobs_interval_desc);
        preferences.add(preference);
        return preferences;
    }

    private Set<Preference> buildMessagesPreferences() {
        HashSet<Preference> preferences = new HashSet<Preference>();
        Preference preference = new Preference();
        preference.setId("miworkplace.ui.messages.start");
        preference.setType(Boolean.class);
        preference.setName(Messages.ui_pref_messages_start);
        preference.setValue(Boolean.FALSE.toString());
        preference.setDescription(Messages.ui_pref_messages_start_desc);
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.messages.interval");
        preference.setType(Integer.class);
        preference.setName(Messages.ui_pref_messages_interval);
        preference.setValue("30");
        preference.setDescription(Messages.ui_pref_messages_interval_desc);
        preferences.add(preference);
        return preferences;
    }

    private Set<Preference> buildDebugPreferences() {
        HashSet<Preference> preferences = new HashSet<Preference>();
        FilePreference preference = new FilePreference();
        preference.setId("miworkplace.ui.debug.jtopen");
        preference.setName(Messages.ui_pref_node_debug_name);
        preference.setDescription(Messages.ui_pref_node_debug_desc);
        preference.setSelectFolder(true);
        preference.setValue("");
        preferences.add((Preference)preference);
        return preferences;
    }

    private Set<Preference> buildCompilePreferences() {
        HashSet<Preference> preferences = new HashSet<Preference>();
        Preference preference = new Preference();
        preference.setId("miworkplace.ui.editor.ignore.no.eventfile");
        preference.setType(Boolean.class);
        preference.setName(Messages.ui_pref_node_compile_eventf_name);
        preference.setDescription(Messages.ui_pref_node_compile_eventf_desc);
        preference.setValue(Boolean.FALSE.toString());
        preference.setOrder(Integer.valueOf(8));
        preferences.add(preference);
        return preferences;
    }

    private Set<Preference> buildGeneralPreferences() {
        HashSet<Preference> preferences = new HashSet<Preference>();
        Preference preference = new Preference();
        preference.setId("miworkplace.ui.general.promptonexit");
        preference.setType(Boolean.class);
        preference.setName(Messages.ui_pref_node_general_exit);
        preference.setValue(Boolean.TRUE.toString());
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.general.versioncheck");
        preference.setType(Boolean.class);
        preference.setName(Messages.ui_pref_node_general_versioncheck);
        preference.setValue(Boolean.TRUE.toString());
        preferences.add(preference);
        return preferences;
    }

    private Set<Preference> buildNetworkPreferences() {
        HashSet<Preference> preferences = new HashSet<Preference>();
        Preference preference = new Preference();
        preference.setId("miworkplace.ui.general.network.http.proxy");
        preference.setType(Boolean.class);
        preference.setName(Messages.ui_pref_node_network_http_proxy_name);
        preference.setValue(Boolean.FALSE.toString());
        preference.setOrder(Integer.valueOf(1));
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.general.network.http.proxy.host");
        preference.setType(String.class);
        preference.setName(Messages.ui_pref_node_network_http_proxy_host);
        preference.setValue("proxy");
        preference.setOrder(Integer.valueOf(2));
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.general.network.http.proxy.port");
        preference.setType(Integer.class);
        preference.setName(Messages.ui_pref_node_network_http_proxy_port);
        preference.setValue("3128");
        preference.setOrder(Integer.valueOf(3));
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.general.network.socks.proxy");
        preference.setType(Boolean.class);
        preference.setName(Messages.ui_pref_node_network_proxy_name);
        preference.setValue(Boolean.FALSE.toString());
        preference.setOrder(Integer.valueOf(4));
        preference.setDescription(Messages.ui_pref_node_network_proxy_desc);
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.general.network.socks.proxy.host");
        preference.setType(String.class);
        preference.setName(Messages.ui_pref_node_network_proxy_host);
        preference.setValue("localhost");
        preference.setOrder(Integer.valueOf(5));
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.general.network.socks.proxy.port");
        preference.setType(Integer.class);
        preference.setName(Messages.ui_pref_node_network_proxy_port);
        preference.setValue("1080");
        preference.setOrder(Integer.valueOf(6));
        preferences.add(preference);
        return preferences;
    }

    private Set<Preference> buildAppearancePreferences() {
        HashSet<Preference> preferences = new HashSet<Preference>();
        SelectionPreference preference = new SelectionPreference();
        preference.setId("miworkplace.ui.appearance.theme");
        preference.setType(String.class);
        preference.setName(Messages.ui_pref_node_appearance_theme);
        preference.setValue(Theme.Classic.name());
        Theme[] themeArray = Theme.values();
        int n = themeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Theme theme = themeArray[n2];
            preference.addSuggestion(theme.name());
            ++n2;
        }
        preferences.add((Preference)preference);
        return preferences;
    }

    private Set<Preference> buildPrintPreferences() {
        HashSet<Preference> preferences = new HashSet<Preference>();
        Preference preference = new Preference();
        preference.setId("miworkplace.ui.print.linenumbers");
        preference.setType(Boolean.class);
        preference.setName(Messages.ui_pref_node_print_linenumbers);
        preference.setValue(Boolean.TRUE.toString());
        preference.setOrder(Integer.valueOf(1));
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.print.header");
        preference.setType(Boolean.class);
        preference.setName(Messages.ui_pref_node_print_pageheader);
        preference.setValue(Boolean.TRUE.toString());
        preference.setOrder(Integer.valueOf(2));
        preferences.add(preference);
        preference = new Preference();
        preference.setId("miworkplace.ui.print.footer");
        preference.setType(Boolean.class);
        preference.setName(Messages.ui_pref_node_print_pagenumbers);
        preference.setValue(Boolean.TRUE.toString());
        preference.setOrder(Integer.valueOf(3));
        preferences.add(preference);
        return preferences;
    }

    public void bindPreferenceService(IPreferencesService service) {
        this.preferenceService = service;
        if (this.preferenceNodes != null) {
            for (IPreferenceNode n : this.preferenceNodes) {
                this.preferenceService.add(n);
            }
        }
    }

    public void unbindPreferenceService(IPreferencesService service) {
        this.preferenceService = null;
    }

    public void bindTextAttributeService(ITextAttributeService service) {
        this.textAttributeService = service;
    }

    public void unbindTextAttributeService(ITextAttributeService service) {
        this.textAttributeService = null;
    }

    public void bindCompileSettingsProvider(ICompileSettingsProvider compileSettingsProvider) {
        this.compileSettingsProvider = compileSettingsProvider;
    }

    public void unbindCompileSettingsProvider(ICompileSettingsProvider compileSettingsProvider) {
        this.compileSettingsProvider = null;
    }

    public void bindUserActionStore(IUserActionStore userActionStore) {
        this.userActionStore = userActionStore;
    }

    public void unbindUserActionStore(IUserActionStore userActionStore) {
        this.userActionStore = null;
    }
}

