/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.jobs;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import miworkplace.i18n.Messages;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class JobStatusControl
implements EventHandler {
    @Inject
    private IResourcePool imagePool;
    @Inject
    private IEventBroker eventBroker;
    private CLabel label;

    @Inject
    public JobStatusControl(Composite parent) {
        this.label = new CLabel(parent, 0x1000000);
    }

    @PostConstruct
    private void postConstruct() {
        this.eventBroker.subscribe("miworkplace/ui/jobs/thread/ended", (EventHandler)this);
        this.eventBroker.subscribe("miworkplace/ui/jobs/thread/running", (EventHandler)this);
        this.eventBroker.subscribe("miworkplace/ui/jobs/thread/sleeping", (EventHandler)this);
        this.setEnded();
    }

    public void dispose() {
        if (!this.label.isDisposed()) {
            this.label.dispose();
        }
        this.eventBroker.unsubscribe((EventHandler)this);
    }

    public void setLayoutData(Object data) {
        this.label.setLayoutData(data);
    }

    public Control getControl() {
        return this.label;
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("miworkplace/ui/jobs/thread/ended")) {
            this.setEnded();
        } else if (event.getTopic().equals("miworkplace/ui/jobs/thread/running")) {
            this.setRunning();
        } else if (event.getTopic().equals("miworkplace/ui/jobs/thread/sleeping")) {
            this.setSleeping();
        }
    }

    private void setRunning() {
        if (!this.label.isDisposed()) {
            this.label.setImage(this.imagePool.getImageUnchecked("IMAGE_JOBS"));
            this.label.setToolTipText(Messages.ui_jobs_widget_running);
            this.label.update();
        }
    }

    private void setSleeping() {
        if (!this.label.isDisposed()) {
            this.label.setImage(this.imagePool.getImageUnchecked("IMAGE_SLEEP"));
            this.label.setToolTipText(Messages.ui_jobs_widget_sleeping);
            this.label.update();
        }
    }

    private void setEnded() {
        if (!this.label.isDisposed()) {
            this.label.setImage(this.imagePool.getImageUnchecked("IMAGE_JOBS_DISABLED"));
            this.label.setToolTipText(Messages.ui_jobs_widget_ended);
            this.label.update();
        }
    }
}

