/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.jobs;

import com.ibm.as400.access.Job;
import jakarta.inject.Named;
import miworkplace.i18n.Messages;
import miworkplace.ui.jobs.EndJob;
import miworkplace.ui.jobs.JobHandler;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class EndJobHandler
extends JobHandler {
    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") IStructuredSelection selection) {
        if (!MessageDialog.openConfirm((Shell)shell, (String)Messages.ui_jobs_end_confirm_title, (String)Messages.ui_jobs_end_confirm)) {
            return;
        }
        super.execute(selection);
    }

    @Override
    protected boolean test(Job pJob) throws Exception {
        return !pJob.getStatus().equals("*OUTQ");
    }

    @Override
    protected void performAction(Job pJob) throws Exception {
        int timeout = this.getApplicationPreferences().getInt("miworkplace.ui.jobs.endjob.timeout", 30);
        new EndJob(pJob, timeout, this.getDebug()).schedule();
    }

    @Override
    protected void failed(Job pJob, Exception e) {
        this.getDebug().error("Could not determine job status for job " + pJob.toString(), (Throwable)e);
    }
}

