/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.handler;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.List;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.OpenSourceDialog;
import miworkplace.ui.util.MemberLoader;
import miworkplace.ui.util.ObjectLoader;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class OpenFastAccessDialogHandler {
    private static final String OPEN_MEMBER_COMMAND_ID = "miworkplace.ui.command.openSourceMember";
    @Inject
    private IEclipseContext context;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IConnectionUtilities connUtilFacade;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private LogService logger;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private EPartService partService;
    @Inject
    private MApplication application;

    @CanExecute
    public boolean canExecute() {
        return this.isAnyConnected();
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell) {
        IEclipseContext activeChild = this.application.getContext().getActiveChild();
        IEclipseContext additionalContext = EclipseContextFactory.create();
        additionalContext.set(Shell.class, (Object)shell);
        OpenSourceDialog dialog = (OpenSourceDialog)((Object)ContextInjectionFactory.make(OpenSourceDialog.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
        if (dialog.open() == 0) {
            activeChild.setParent(this.application.getContext());
            activeChild.activateBranch();
            Object[] result = dialog.getResult();
            String inputUri = result[0].toString();
            String connectionName = EditorInputUriUtil.getConnectionName((String)inputUri);
            IConnection connection = this.connectionManager.get(connectionName);
            String memberPath = EditorInputUriUtil.getMemberPath((String)inputUri);
            try {
                this.loadPath(connection, memberPath);
                if (this.connUtilFacade.doesMemberExist(connection, memberPath)) {
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("miworkplace.ui.editor.command.parameter.connection", connectionName);
                    parameters.put("miworkplace.ui.editor.command.parameter.selection", memberPath);
                    ParameterizedCommand command = this.commandService.createCommand(OPEN_MEMBER_COMMAND_ID, parameters);
                    if (!command.getCommand().isDefined()) {
                        this.logger.log(1, "Command miworkplace.ui.command.openSourceMember is not available. Could not open member " + memberPath + ".");
                        return;
                    }
                    if (!this.handlerService.canExecute(command)) {
                        this.logger.log(1, "Open Member Handler cannot execute for member " + memberPath + ".");
                    } else {
                        IEclipseContext handlerContext = this.context.createChild(OpenFastAccessDialogHandler.class.getName());
                        handlerContext.set(IConnectionManager.class, (Object)this.connectionManager);
                        handlerContext.set(IConnection.class, (Object)connection);
                        handlerContext.set("memberPath", (Object)memberPath);
                        handlerContext.set(LogService.class, (Object)this.logger);
                        handlerContext.set(EPartService.class, (Object)this.partService);
                        this.handlerService.executeHandler(command, handlerContext);
                        handlerContext.dispose();
                    }
                } else {
                    Notifier.warn((String)Messages.ui_handler_openfast_title, (String)String.format(Messages.ui_handler_openfast_notexist, memberPath));
                }
            }
            catch (Exception e) {
                this.logger.log(1, "Could not open member via fast access dialog.", (Throwable)e);
                Notifier.notify((Shell)shell, (String)Messages.ui_handler_openfast_title, (String)e.getMessage(), (Notifier.Type)Notifier.Type.ERROR, (boolean)false, (int)10000);
            }
        }
    }

    private boolean isAnyConnected() {
        for (IConnection connection : this.connectionManager.list()) {
            if (!connection.isConnected()) continue;
            return true;
        }
        return false;
    }

    private void loadPath(IConnection connection, String memberPath) {
        String filePath;
        IRemoteObject sourceFile;
        if (this.workspaceStore.get(connection, memberPath) != null) {
            return;
        }
        QSYSObjectPathName path = new QSYSObjectPathName(memberPath);
        String libraryPath = "/QSYS.LIB/" + path.getLibraryName() + ".LIB";
        IRemoteObject library = this.workspaceStore.get(connection, libraryPath);
        if (library == null) {
            List libraries = this.workspaceStore.getLibraries(connection);
            for (IRemoteObject l : libraries) {
                if (!l.getName().equals(path.getLibraryName())) continue;
                this.workspaceStore.remove(library);
                break;
            }
            this.workspaceStore.addLibrary(connection, path.getLibraryName());
            library = this.workspaceStore.getLibrary(connection, path.getLibraryName());
        }
        if ((sourceFile = this.workspaceStore.get(connection, filePath = "/QSYS.LIB/" + path.getLibraryName() + ".LIB/" + path.getObjectName() + ".FILE")) == null || !library.areChildrenLoaded()) {
            IEclipseContext additionalContext = EclipseContextFactory.create();
            additionalContext.set("miworkplace.ui.library", (Object)library);
            ObjectLoader loader = (ObjectLoader)((Object)ContextInjectionFactory.make(ObjectLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
            IStatus status = loader.run((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                throw new RuntimeException("Could not load source file " + path.getObjectName() + ": " + status.getMessage());
            }
        }
        if (this.workspaceStore.get(connection, memberPath) == null) {
            IRemoteObject file = this.workspaceStore.get(connection, filePath);
            IEclipseContext additionalContext = EclipseContextFactory.create();
            additionalContext.set("miworkplace.ui.file", (Object)file);
            MemberLoader loader = (MemberLoader)((Object)ContextInjectionFactory.make(MemberLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
            IStatus status = loader.run((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                throw new RuntimeException("Could not load members of source file " + path.getObjectName() + ": " + status.getMessage());
            }
        }
    }
}

