/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SourceMemberWizardPage
extends WizardPage {
    private static final String NEW_MEMBER_ATTRIBUTES = "NEW_MEMBER_ATTRIBUTES";
    private static final String NEW_MEMBER_DEFAULT_ATTRIBUTE = "NEW_MEMBER_DEFAULT_ATTRIBUTE";
    private Text txtMemberName = null;
    private Combo cmbLibraryName = null;
    private Combo cmbConnection = null;
    private Text txtDescription = null;
    private Combo cmbAttribute = null;
    private Combo cmbSourceFile = null;
    private IWorkspaceStore workspaceStore;
    private IConnectionManager connectionManager;
    private String[] connectionNames;
    private IConnection connection;
    private IRemoteObject library;
    private IRemoteObject file;

    public SourceMemberWizardPage(IWorkspaceStore workspaceStore, IConnectionManager connectionManager, IConnection connection, IRemoteObject library, IRemoteObject file) {
        super(Messages.ui_wizard_member_title);
        this.workspaceStore = workspaceStore;
        this.connectionManager = connectionManager;
        this.connection = connection;
        this.library = library;
        this.file = file;
        this.setTitle(Messages.ui_wizard_member_title);
        this.setDescription(Messages.ui_wizard_member_desc);
        LinkedList<String> names = new LinkedList<String>();
        for (IConnection conn : connectionManager.list()) {
            if (!conn.isConnected()) continue;
            names.add(conn.getName());
        }
        this.connectionNames = names.toArray(new String[names.size()]);
    }

    public void createControl(Composite parent) {
        Composite controls = new Composite(parent, 0);
        controls.setLayout((Layout)new GridLayout(3, false));
        Label lblConnection = new Label(controls, 0);
        lblConnection.setText(Messages.ui_wizard_member_conn);
        this.cmbConnection = new Combo(controls, 8);
        this.cmbConnection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cmbConnection.setItems(this.connectionNames);
        this.cmbConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IConnection connection = SourceMemberWizardPage.this.connectionManager.get(SourceMemberWizardPage.this.cmbConnection.getText());
                SourceMemberWizardPage.this.updateSelection(connection);
            }
        });
        new Label(controls, 0);
        new Label(controls, 0);
        new Label(controls, 0);
        Label lblLibraryName = new Label(controls, 0);
        lblLibraryName.setText(Messages.ui_wizard_member_lib);
        this.cmbLibraryName = new Combo(controls, 8);
        this.cmbLibraryName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.cmbLibraryName.pack();
        this.cmbLibraryName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SourceMemberWizardPage.this.updateSourceFiles(SourceMemberWizardPage.this.cmbLibraryName.getText());
            }
        });
        Label lblSourceFileName = new Label(controls, 0);
        lblSourceFileName.setText(Messages.ui_wizard_member_file);
        this.cmbSourceFile = new Combo(controls, 8);
        this.cmbSourceFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Label lblMemberName = new Label(controls, 0);
        lblMemberName.setText(Messages.ui_wizard_member_name);
        this.txtMemberName = new Text(controls, 2048);
        this.txtMemberName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.txtMemberName.setTextLimit(10);
        Label lblAttribute = new Label(controls, 0);
        lblAttribute.setText(Messages.ui_wizard_member_att);
        lblAttribute.pack();
        this.cmbAttribute = new Combo(controls, 4);
        this.cmbAttribute.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cmbAttribute.setItems(this.getMemberAttributes());
        this.cmbAttribute.setText(this.getDefaultMemberAttribute());
        Button attrReset = new Button(controls, 0);
        attrReset.setToolTipText(Messages.ui_wizard_resetAttributesTip);
        attrReset.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        attrReset.setText(Messages.ui_wizard_reset);
        attrReset.addListener(13, e -> this.resetAttributes());
        Label lblDescription = new Label(controls, 0);
        lblDescription.setText(Messages.ui_wizard_member_description);
        lblDescription.pack();
        this.txtDescription = new Text(controls, 2048);
        this.txtDescription.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.txtDescription.setTextLimit(50);
        this.setControl((Control)controls);
        if (this.connection != null && this.connection.isConnected()) {
            this.cmbConnection.select(this.cmbConnection.indexOf(this.connection.getName()));
            this.updateSelection(this.connection);
            if (this.library != null) {
                this.cmbLibraryName.select(this.cmbLibraryName.indexOf(this.library.getName()));
                this.updateSourceFiles(this.cmbLibraryName.getText());
                if (this.file != null) {
                    this.cmbSourceFile.select(this.cmbSourceFile.indexOf(this.file.getName()));
                    this.txtMemberName.setFocus();
                }
            }
        }
    }

    private void resetAttributes() {
        this.connectionManager.setPreference(this.connection, NEW_MEMBER_ATTRIBUTES, null);
        this.cmbAttribute.setItems(this.getMemberAttributes());
    }

    private String getDefaultMemberAttribute() {
        return this.connectionManager.getPreference(this.connection, NEW_MEMBER_DEFAULT_ATTRIBUTE, "RPGLE");
    }

    private void setDefaultMemberAttribute(String attribute) {
        this.connectionManager.setPreference(this.connection, NEW_MEMBER_DEFAULT_ATTRIBUTE, attribute);
    }

    private String[] getMemberAttributes() {
        String result = this.connectionManager.getPreference(this.connection, NEW_MEMBER_ATTRIBUTES, null);
        if (result == null) {
            return new String[]{"BND", "C", "CBL", "CBLLE", "CBL38", "CL", "CLLE", "CLP", "CLP38", "CMD", "CMD38", "DDL", "DSPF", "DSPF38", "H", "LF", "LF38", "MENU", "MNUCMD", "MNUDDS", "MSGF", "OCL36", "PF", "PFSQL", "PF38", "PNLGRP", "PRTF", "PRTF38", "REXX", "RPG", "RPGLE", "RPG36", "RPG38", "SQL", "SQLCBL", "SQLCBLLE", "SQLRPG", "SQLRPGLE", "TXT", "XML"};
        }
        return result.substring(1, result.length() - 1).split(",");
    }

    private void addMemberAttribute(String newAttribute) {
        ArrayList<String> attrs = new ArrayList<String>(Arrays.asList(this.getMemberAttributes()));
        if (attrs.contains(newAttribute.toUpperCase())) {
            return;
        }
        attrs.add(newAttribute.toUpperCase());
        Collections.sort(attrs);
        Object[] attrsArray = attrs.toArray(new String[0]);
        this.connectionManager.setPreference(this.connection, NEW_MEMBER_ATTRIBUTES, Arrays.toString(attrsArray).replace(" ", "").replace(" ", ""));
    }

    private void updateSourceFiles(String libraryName) {
        IConnection connection = this.connectionManager.get(this.cmbConnection.getText());
        IRemoteObject library = this.workspaceStore.getLibrary(connection, libraryName);
        List objects = this.workspaceStore.getObjects(library);
        LinkedList<String> sourceFileNames = new LinkedList<String>();
        for (IRemoteObject object : objects) {
            if (object.getType() != IRemoteObject.Type.file || object.getAttribute() != IRemoteObject.Attribute.sourcefile) continue;
            sourceFileNames.add(object.getName());
        }
        Collections.sort(sourceFileNames);
        this.cmbSourceFile.removeAll();
        this.cmbSourceFile.setItems(sourceFileNames.toArray(new String[sourceFileNames.size()]));
        if (this.cmbSourceFile.getItemCount() > 0) {
            this.cmbSourceFile.select(0);
        }
    }

    private void updateSelection(IConnection connection) {
        List libraries = this.workspaceStore.getLibraries(connection);
        if (libraries != null) {
            String[] libraryNames = new String[libraries.size()];
            int i = 0;
            while (i < libraries.size()) {
                libraryNames[i] = ((IRemoteObject)libraries.get(i)).getName();
                ++i;
            }
            this.cmbLibraryName.setItems(libraryNames);
            this.cmbLibraryName.select(0);
            this.updateSourceFiles(this.cmbLibraryName.getText());
        } else {
            this.cmbLibraryName.removeAll();
            this.cmbSourceFile.removeAll();
        }
    }

    public String getConnectionName() {
        return this.cmbConnection.getText();
    }

    public String getLibraryName() {
        return this.cmbLibraryName.getText();
    }

    public String getSourceFileName() {
        return this.cmbSourceFile.getText();
    }

    public String getDescriptionText() {
        return this.txtDescription.getText();
    }

    public String getAttribute() {
        return this.cmbAttribute.getText();
    }

    public String getMemberName() {
        return this.txtMemberName.getText().toUpperCase();
    }

    public void storeValuesInPreferences() {
        this.setDefaultMemberAttribute(this.getAttribute());
        this.addMemberAttribute(this.getAttribute());
    }
}

