/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.MessageFormat;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.api.ConnectionRule;
import miworkplace.ui.useraction.UserAction;
import miworkplace.ui.useraction.UserActionCommandBuilder;
import miworkplace.ui.useraction.UserActionJob;
import miworkplace.ui.util.Prompter;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UserActionHandler {
    private Debug logger = Debug.getInstance();
    @Inject
    private IEclipseContext context;
    @Inject
    private IConnectionUtilities connectionUtilities;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") TreeSelection selection) {
        if (selection == null) {
            return false;
        }
        if (selection.isEmpty()) {
            return false;
        }
        Object element = selection.getFirstElement();
        if (element instanceof IConnection) {
            return ((IConnection)element).isConnected();
        }
        return true;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Optional MMenuItem menuItem, @Named(value="org.eclipse.ui.selection") TreeSelection selection) {
        UserAction userAction = (UserAction)menuItem.getTransientData().get("useraction");
        IConnection connection = this.getConnection(selection);
        if (connection == null) {
            this.logger.info((Option)miworkplace.ui.debug.Option.userActions, MessageFormat.format("Could not resolve connection to selection {0}. Abort execution of user action {1}", selection.getFirstElement(), userAction.getName()));
            return;
        }
        selection.forEach(object -> this.processSelection(shell, object, userAction, connection));
    }

    private void processSelection(Shell shell, Object selection, final UserAction userAction, final IConnection connection) {
        UserActionCommandBuilder commandBuilder = (UserActionCommandBuilder)ContextInjectionFactory.make(UserActionCommandBuilder.class, (IEclipseContext)this.context);
        String command = commandBuilder.buildCommand(userAction.getCommand(), selection);
        if (userAction.isPrompt()) {
            String prompted = Prompter.prompt(connection, command);
            if (prompted == null) {
                return;
            }
            command = prompted;
        }
        if (userAction.isBatch()) {
            UserActionJob job = new UserActionJob(connection, userAction.getName(), command);
            ContextInjectionFactory.inject((Object)((Object)job), (IEclipseContext)this.context);
            job.setRule(new ConnectionRule(connection.getName()));
            job.schedule();
        } else {
            final String commandFinal = command;
            BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        UserActionHandler.this.connectionUtilities.executeRemoteCommand(connection, commandFinal);
                        Notifier.info((String)Messages.ui_handler_useraction_title, (String)String.format(Messages.ui_handler_useraction_success, userAction.getName()));
                    }
                    catch (Exception e) {
                        UserActionHandler.this.logger.error((Option)miworkplace.ui.debug.Option.userActions, MessageFormat.format("The user action could not execute the command successfully. Command: {0}", commandFinal), (Throwable)e);
                        Notifier.error((String)Messages.ui_handler_useraction_title, (String)Messages.ui_handler_useraction_error);
                    }
                }
            });
        }
    }

    private IConnection getConnection(TreeSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof IConnection) {
            return (IConnection)element;
        }
        if (element instanceof IRemoteObject) {
            return ((IRemoteObject)element).getConnection();
        }
        return null;
    }
}

