/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.ui.explorer.wizard.SourceMemberWizard;
import miworkplace.ui.util.MemberLoader;
import miworkplace.ui.util.ObjectLoader;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class SourceMemberWizardHandler {
    private final String OPEN_MEMBER_COMMAND_ID = "miworkplace.ui.command.openSourceMember";
    @Inject
    private IEclipseContext context;
    @Inject
    private ESelectionService selectionService;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private LogService logger;
    @Inject
    private IConnectionManager connectionManager;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        return true;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, EPartService partService, MApplication application) {
        SourceMember member;
        IEclipseContext activeChild = application.getContext().getActiveChild();
        IEclipseContext additionalContext = EclipseContextFactory.create();
        additionalContext.set(ESelectionService.class, (Object)this.selectionService);
        SourceMemberWizard wizard = (SourceMemberWizard)((Object)ContextInjectionFactory.make(SourceMemberWizard.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.open();
        if (activeChild != null) {
            activeChild.setParent(application.getContext());
            activeChild.activateBranch();
        }
        if ((member = wizard.getSourceMember()) != null) {
            this.openMember(member.getConnection(), member.getPath(), partService);
        }
    }

    private void openMember(IConnection connection, String memberPath, EPartService partService) {
        this.loadPath(connection, memberPath);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("miworkplace.ui.editor.command.parameter.connection", connection.getName());
        parameters.put("miworkplace.ui.editor.command.parameter.selection", memberPath);
        ParameterizedCommand command = this.commandService.createCommand("miworkplace.ui.command.openSourceMember", parameters);
        if (!command.getCommand().isDefined()) {
            this.logger.log(1, "Command miworkplace.ui.command.openSourceMember is not available. Could not open member " + memberPath + ".");
            return;
        }
        if (!this.handlerService.canExecute(command)) {
            this.logger.log(1, "Open Member Handler cannot execute for member " + memberPath + ".");
        } else {
            IEclipseContext handlerContext = this.context.createChild(this.getClass().getName());
            handlerContext.set(IConnectionManager.class, (Object)this.connectionManager);
            handlerContext.set(IConnection.class, (Object)connection);
            handlerContext.set("memberPath", (Object)memberPath);
            handlerContext.set(LogService.class, (Object)this.logger);
            handlerContext.set(EPartService.class, (Object)partService);
            this.handlerService.executeHandler(command, handlerContext);
            handlerContext.dispose();
        }
    }

    private void loadPath(IConnection connection, String memberPath) {
        String filePath;
        IRemoteObject sourceFile;
        if (this.workspaceStore.get(connection, memberPath) != null) {
            return;
        }
        QSYSObjectPathName path = new QSYSObjectPathName(memberPath);
        String libraryPath = "/QSYS.LIB/" + path.getLibraryName() + ".LIB";
        IRemoteObject library = this.workspaceStore.get(connection, libraryPath);
        if (library == null) {
            List libraries = this.workspaceStore.getLibraries(connection);
            for (IRemoteObject l : libraries) {
                if (!l.getName().equals(path.getLibraryName())) continue;
                this.workspaceStore.remove(library);
                break;
            }
            this.workspaceStore.addLibrary(connection, path.getLibraryName());
            library = this.workspaceStore.getLibrary(connection, path.getLibraryName());
        }
        if ((sourceFile = this.workspaceStore.get(connection, filePath = "/QSYS.LIB/" + path.getLibraryName() + ".LIB/" + path.getObjectName() + ".FILE")) == null || !library.areChildrenLoaded()) {
            IEclipseContext additionalContext = EclipseContextFactory.create();
            additionalContext.set("miworkplace.ui.library", (Object)library);
            ObjectLoader loader = (ObjectLoader)((Object)ContextInjectionFactory.make(ObjectLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
            IStatus status = loader.run((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                throw new RuntimeException(String.format(Messages.ui_handler_member_wizard_error_srcf, path.getObjectName(), status.getMessage()));
            }
        }
        if (this.workspaceStore.get(connection, memberPath) == null) {
            IRemoteObject file = this.workspaceStore.get(connection, filePath);
            IEclipseContext additionalContext = EclipseContextFactory.create();
            additionalContext.set("miworkplace.ui.file", (Object)file);
            MemberLoader loader = (MemberLoader)((Object)ContextInjectionFactory.make(MemberLoader.class, (IEclipseContext)this.context, (IEclipseContext)additionalContext));
            IStatus status = loader.run((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                throw new RuntimeException(String.format(Messages.ui_handler_member_wizard_error_members, path.getObjectName(), status.getMessage()));
            }
        }
    }
}

