/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.StreamFile;
import miworkplace.common.ui.ListDialog;
import miworkplace.i18n.Messages;
import miworkplace.services.api.ICompileSettings;
import miworkplace.services.api.ICompileSettingsProvider;
import miworkplace.ui.compile.CompileSettingsProvider;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;

public class SetCompileCommandHandler {
    @Inject
    private CompileSettingsProvider memberCsProvider;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        return true;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, ICompileSettingsProvider compileSettingsProvider, @Optional @Named(value="org.eclipse.ui.selection") IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        IRemoteObject member = (IRemoteObject)selection.getFirstElement();
        List<Object> compileSettings = new ArrayList(compileSettingsProvider.list());
        compileSettings = compileSettings.stream().filter(cs -> {
            if (member instanceof StreamFile) {
                return cs.isIfsSetting();
            }
            return !cs.isIfsSetting();
        }).collect(Collectors.toList());
        Collections.sort(compileSettings, new Comparator<ICompileSettings>(){

            @Override
            public int compare(ICompileSettings cs1, ICompileSettings cs2) {
                return cs1.getName().compareTo(cs2.getName());
            }
        });
        Properties properties = this.memberCsProvider.get(member);
        ListDialog dialog = new ListDialog(shell);
        dialog.setInput(compileSettings);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setLabelProvider((ILabelProvider)new CompileSettingsLabelProvider());
        dialog.setMessage(Messages.ui_handler_compile_command_message);
        dialog.setTitle(Messages.ui_handler_compile_command_title);
        if (properties.containsKey("command.id")) {
            dialog.setInitialSelections(new Object[]{compileSettingsProvider.get(properties.get("command.id").toString())});
        }
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length > 0) {
            ICompileSettings settings = (ICompileSettings)result[0];
            properties.put("command.id", settings.getId());
            this.memberCsProvider.save(member, properties);
        }
    }

    class CompileSettingsLabelProvider
    extends LabelProvider {
        CompileSettingsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ICompileSettings) {
                ICompileSettings compileSetting = (ICompileSettings)element;
                if (StringUtils.isEmpty((CharSequence)compileSetting.getCompileCommand())) {
                    return ((ICompileSettings)element).getName();
                }
                return compileSetting.getName() + " (" + compileSetting.getCompileCommand() + ")";
            }
            return super.getText(element);
        }
    }
}

