/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.HashMap;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.QSYSObject;
import miworkplace.common.model.SourceFile;
import miworkplace.common.model.SourceMember;
import miworkplace.common.validator.ObjectNameValidator;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.util.ObjectHelper;
import miworkplace.ui.api.WorkspaceUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class RenameHandler {
    @Inject
    private LogService logger;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IConnectionUtilities connUtilFacade;
    @Inject
    private IWorkspaceStore workspaceStore;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        return true;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, ESelectionService selectionService) {
        IStructuredSelection selection = (IStructuredSelection)selectionService.getSelection();
        if (!selection.isEmpty()) {
            Object element = selection.getFirstElement();
            if (element instanceof SourceMember) {
                SourceMember member = (SourceMember)element;
                this.renameMember(shell, member);
            } else if (element instanceof IRemoteObject) {
                IRemoteObject remoteObject = (IRemoteObject)element;
                switch (remoteObject.getType()) {
                    case library: {
                        break;
                    }
                    default: {
                        this.renameObject(shell, remoteObject);
                    }
                }
            }
        }
    }

    private void renameObject(Shell shell, IRemoteObject remoteObject) {
        InputDialog dialog = new InputDialog(shell, Messages.ui_handler_rename_object_title, Messages.ui_handler_rename_object_newname, remoteObject.getName(), (IInputValidator)new ObjectNameValidator(Arrays.asList(remoteObject.getName())));
        if (dialog.open() == 0) {
            String newObjectName = dialog.getValue().trim().toUpperCase();
            if (newObjectName.equals(remoteObject.getName())) {
                Notifier.info((String)Messages.ui_handler_rename_object_title, (String)Messages.ui_handler_rename_object_samename);
            } else {
                try {
                    this.connUtilFacade.renameObject(remoteObject.getConnection(), remoteObject.getPath(), newObjectName);
                    IRemoteObject library = this.workspaceStore.getLibrary(remoteObject);
                    IResource file = WorkspaceUtil.buildObjectResource(library, newObjectName, remoteObject.getType());
                    IRemoteObject renamedObject = QSYSObject.create((IConnection)remoteObject.getConnection(), (IResource)file, (IRemoteObject.Type)remoteObject.getType(), (String)remoteObject.getRealType(), (IRemoteObject.Attribute)remoteObject.getAttribute(), (String)remoteObject.getRealAttribute());
                    this.workspaceStore.remove(remoteObject);
                    this.workspaceStore.add(renamedObject);
                    if (renamedObject.getType() == IRemoteObject.Type.file) {
                        if (ObjectHelper.isSourceFile((IRemoteObject)renamedObject)) {
                            renamedObject.setAttribute(IRemoteObject.Attribute.sourcefile);
                        } else {
                            renamedObject.setAttribute(IRemoteObject.Attribute.datafile);
                        }
                    }
                    HashMap<String, IRemoteObject> map = new HashMap<String, IRemoteObject>();
                    map.put("new.object", renamedObject);
                    map.put("old.object", remoteObject);
                    map.put("library", library);
                    this.eventBroker.post("miworkplace/object/renamed", map);
                }
                catch (Exception e) {
                    this.logger.log(1, "Error renaming object " + remoteObject.getName(), (Throwable)e);
                    Notifier.error((String)Messages.ui_handler_rename_object_title, (String)String.format(Messages.ui_handler_rename_object_error, remoteObject.getName()));
                }
            }
        }
    }

    private void renameMember(Shell shell, SourceMember member) {
        InputDialog dialog = new InputDialog(shell, Messages.ui_handler_rename_member_title, Messages.ui_handler_rename_member_newname, member.getName(), (IInputValidator)new ObjectNameValidator(Arrays.asList(member.getName())));
        if (dialog.open() == 0) {
            String newMemberName = dialog.getValue().trim().toUpperCase();
            try {
                this.connUtilFacade.renameMember(member.getConnection(), member.getPath(), newMemberName);
                SourceFile sourceFile = this.workspaceStore.getSourceFile(member.getConnection(), member);
                IFile file = WorkspaceUtil.buildMemberFile((IRemoteObject)sourceFile, newMemberName);
                SourceMember newMember = new SourceMember(member.getConnection(), (IResource)file, null);
                newMember.setSourceType(member.getSourceType());
                this.workspaceStore.remove((IRemoteObject)member);
                this.workspaceStore.add((IRemoteObject)newMember);
                HashMap<String, SourceMember> map = new HashMap<String, SourceMember>();
                map.put("new.member", newMember);
                map.put("old.member", member);
                this.eventBroker.post("miworkplace/member/renamed", map);
            }
            catch (RuntimeException re) {
                this.logger.log(1, "Error rename member " + member.getName(), (Throwable)re);
                Notifier.error((String)Messages.ui_handler_rename_member_title, (String)String.format(Messages.ui_handler_rename_member_error, member.getName()));
            }
        }
    }
}

