/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Dictionary;
import java.util.Hashtable;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class ChangeMemberTypeHandler {
    @Inject
    private LogService logger;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IConnectionUtilities connUtilFacade;
    @Inject
    private IWorkspaceStore workspaceStore;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") @Optional ITreeSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object element = selection.getFirstElement();
        return element != null && element instanceof SourceMember;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        SourceMember member = (SourceMember)selection.getFirstElement();
        InputDialog dialog = new InputDialog(shell, Messages.ui_handler_chgmbrtype_title, Messages.ui_handler_chgmbrtype_prompt, member.getSourceType(), new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() == 0) {
                    return Messages.ui_handler_chgmbrtype_empty_error;
                }
                if (newText.length() > 10) {
                    return Messages.ui_handler_chgmbrtype_limit_error;
                }
                if (!newText.substring(0, 1).matches("[a-zA-Z]")) {
                    return Messages.ui_handler_chgmbrtype_invalidstart;
                }
                return null;
            }
        });
        if (dialog.open() == 0) {
            String newType = dialog.getValue().trim().toUpperCase();
            if (newType.equals(member.getSourceType())) {
                Notifier.info((String)Messages.ui_handler_chgmbrtype_title, (String)Messages.ui_handler_chgmbrtype_samevalue_error);
            } else {
                try {
                    this.connUtilFacade.changeMemberType(member.getConnection(), member.getPath(), newType);
                    this.workspaceStore.remove((IRemoteObject)member);
                    member.setSourceType(newType);
                    this.workspaceStore.add((IRemoteObject)member);
                    Hashtable<String, Object> map = new Hashtable<String, Object>();
                    ((Dictionary)map).put("org.eclipse.e4.data", member);
                    ((Dictionary)map).put("change", "TYPE");
                    this.eventBroker.post("miworkplace/member/updated", map);
                }
                catch (Exception e) {
                    this.logger.log(1, "Error changing member type for " + member.getName() + ". Cause: " + e.getMessage());
                    Notifier.error((String)Messages.ui_handler_chgmbrtype_title, (String)String.format(Messages.ui_handler_chgmbrtype_error, member.getName()));
                }
            }
        }
    }
}

