/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.filter;

import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import miworkplace.i18n.Messages;
import miworkplace.ui.explorer.filter.Filter;
import miworkplace.ui.explorer.filter.FilterManager;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;

public class FilterMenuContributor {
    private static final String TOGGLE_KEY = "toggle";
    private static final String NAME_KEY = "name";
    @Inject
    @Preference(nodePath="miworkplace.application/explorer")
    private IEclipsePreferences prefs;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items, FilterManager manager) {
        boolean ifs = !this.prefs.get("miworkplace.ui.explorer.viewer.showing", "qsys").equals("qsys");
        HashMap<String, List<String>> subMenus = new HashMap<String, List<String>>();
        String splitter = " / ";
        String[] stringArray = manager.getFilterNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filterName2 = stringArray[n2];
            Filter filter = manager.getFilter(filterName2);
            if (filter.isIfs() == ifs) {
                String[] split = filterName2.split(splitter);
                if (split.length > 1) {
                    String subMenu = split[0];
                    this.add(subMenus, filterName2, subMenu);
                } else {
                    this.add(subMenus, filterName2, "");
                }
            }
            ++n2;
        }
        for (String subMenuLabel : subMenus.keySet()) {
            if (subMenuLabel.isEmpty()) {
                items.add((MMenuElement)this.createToggleItem());
                ((List)subMenus.get(subMenuLabel)).forEach(filterName -> {
                    boolean bl = items.add((MMenuElement)this.createMenuItem(manager.getFilter((String)filterName), (String)filterName));
                });
                continue;
            }
            MMenu subMenu = MMenuFactory.INSTANCE.createMenu();
            subMenu.getChildren().add(this.createToggleItem());
            int[] active = new int[1];
            int count = ((List)subMenus.get(subMenuLabel)).size();
            ((List)subMenus.get(subMenuLabel)).forEach(label -> {
                Filter filter = manager.getFilter(subMenuLabel + splitter + label);
                if (filter.isActive()) {
                    nArray[0] = active[0] + 1;
                }
                subMenu.getChildren().add(this.createMenuItem(filter, (String)label));
            });
            subMenu.setLabel(MessageFormat.format("{0} ({1}/{2})", subMenuLabel, active[0], count));
            items.add((MMenuElement)subMenu);
        }
    }

    private MDirectMenuItem createToggleItem() {
        MDirectMenuItem dynamicItem = MMenuFactory.INSTANCE.createDirectMenuItem();
        dynamicItem.getTransientData().put(TOGGLE_KEY, "true");
        dynamicItem.setIconURI("platform:/plugin/miworkplace.images/icons/switch.png");
        dynamicItem.setLabel(Messages.FilterMenuContributor_toggle);
        dynamicItem.setContributorURI("platform:/plugin/miworkplace.ui");
        dynamicItem.setContributionURI("bundleclass://miworkplace.ui/" + this.getClass().getName());
        dynamicItem.setType(ItemType.CHECK);
        dynamicItem.setSelected(false);
        return dynamicItem;
    }

    private MDirectMenuItem createMenuItem(Filter filter, String label) {
        MDirectMenuItem dynamicItem = MMenuFactory.INSTANCE.createDirectMenuItem();
        dynamicItem.getTransientData().put(NAME_KEY, filter.getName());
        dynamicItem.setLabel(label);
        dynamicItem.setContributorURI("platform:/plugin/miworkplace.ui");
        dynamicItem.setContributionURI("bundleclass://miworkplace.ui/" + this.getClass().getName());
        dynamicItem.setType(ItemType.CHECK);
        dynamicItem.setSelected(filter.isActive());
        return dynamicItem;
    }

    private void add(Map<String, List<String>> subMenus, String filterName, String subMenu) {
        List<String> menu = subMenus.get(subMenu);
        if (menu == null) {
            menu = new ArrayList<String>();
            subMenus.put(subMenu, menu);
        }
        menu.add(filterName.replaceFirst(subMenu + " / ", ""));
    }

    @Execute
    private void filterSelected(MDirectMenuItem item, FilterManager manager, IEclipseContext context) {
        if (item.getTransientData().get(TOGGLE_KEY) != null) {
            this.handleToggleItems(item, manager);
        } else {
            this.handleSelectFilter(item, manager, context);
        }
    }

    private void handleSelectFilter(MDirectMenuItem item, FilterManager manager, IEclipseContext context) {
        String filterName = item.getTransientData().get(NAME_KEY).toString();
        manager.getFilter(filterName).setActive(item.isSelected()).save();
        context.set(FilterManager.KEY_LAST_SELECTED_FILTER, (Object)filterName);
        manager.notifyListeners();
    }

    private void handleToggleItems(MDirectMenuItem item, FilterManager manager) {
        boolean newState = this.getNewToggleState(item);
        item.getParent().getChildren().forEach(e -> {
            if (e instanceof MDirectMenuItem && e.getTransientData().get(NAME_KEY) != null) {
                manager.getFilter(e.getTransientData().get(NAME_KEY).toString()).setActive(newState).save();
            }
        });
        manager.notifyListeners();
    }

    private boolean getNewToggleState(MDirectMenuItem element) {
        int[] onOff = new int[2];
        element.getParent().getChildren().forEach(e -> {
            if (e instanceof MDirectMenuItem) {
                if (e.getTransientData().get(NAME_KEY) != null) {
                    if (((MDirectMenuItem)e).isSelected()) {
                        nArray[0] = onOff[0] + 1;
                    } else {
                        nArray[1] = onOff[1] + 1;
                    }
                }
                if (onOff[0] > 0 && onOff[1] > 0) {
                    nArray[0] = 0;
                }
            }
        });
        return onOff[1] > 0;
    }
}

