/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.filter;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.InputStream;
import java.text.MessageFormat;
import miworkplace.common.ui.MiniMessage;
import miworkplace.i18n.Messages;
import miworkplace.images.service.Factory;
import miworkplace.ui.explorer.filter.Filter;
import miworkplace.ui.explorer.filter.FilterManager;
import miworkplace.ui.explorer.filter.NewFilterDialog;
import miworkplace.ui.widgets.LibraryList;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;

public class FilterDialog
extends TitleAreaDialog {
    private static final int APPLY = 502;
    private static final int EXPORT = 501;
    private static final int IMPORT = 500;
    @Inject
    private IResourcePool fImagePool;
    @Inject
    EHelpService fHelpService;
    @Inject
    private FilterManager fFilterManager;
    @Inject
    private IEclipseContext fContext;
    private Button fSourcesOnly;
    private Combo fFilterName;
    private LibraryList fLibraries;
    private LibraryList fObjectsList;
    private LibraryList fObjectTypesList;
    private LibraryList fDirectoryList;
    private LibraryList fExtensionList;
    private LibraryList fMembersList;
    private LibraryList fMemberTypeList;
    private LibraryList fObjectAttributes;
    private Filter fFilter;
    private Button fActiveBtn;
    private Button fIfsBtn;
    private TabFolder fLibsTabFolder;
    private Composite fTabComposite;
    private TabFolder fIFSTabFolder;

    @Inject
    public FilterDialog(@Named(value="activeShell") Shell shell) {
        super(shell);
    }

    public boolean close() {
        this.fFilterManager.notifyListeners();
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ui_filter_title);
        this.setMessage(Messages.ui_filter_desc);
        this.setTitleImage(Factory.create((Widget)parent, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/icons/filter-wizard.png")));
        Composite root = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.getShell().getDisplay().getPrimaryMonitor().getBounds().height / 3;
        gridData.widthHint = this.getShell().getDisplay().getPrimaryMonitor().getBounds().width / 3;
        root.setLayoutData((Object)gridData);
        root.setLayout((Layout)new GridLayout(4, false));
        Label lblFilterName = new Label(root, 0);
        lblFilterName.setText(Messages.ui_filter_regex_title);
        new Label(root, 0);
        new Label(root, 0);
        new Label(root, 0);
        this.fFilterName = new Combo(root, 2056);
        this.fFilterName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fFilterName.addListener(13, e -> this.selectFilter());
        Button btnAdd = new Button(root, 0x800000);
        btnAdd.setImage(this.fImagePool.getImageUnchecked("IMAGE_ADD"));
        btnAdd.addListener(13, e -> this.addFilter());
        Button btnDel = new Button(root, 0x800000);
        btnDel.setImage(this.fImagePool.getImageUnchecked("IMAGE_DELETE"));
        btnDel.addListener(13, e -> this.deleteFilter());
        this.fActiveBtn = new Button(root, 32);
        this.fActiveBtn.setText(Messages.FilterDialog_active);
        this.fIfsBtn = new Button(root, 32);
        this.fIfsBtn.setText(Messages.FilterDialog_ifs);
        this.fIfsBtn.addListener(13, e -> this.ifsButtonClicked());
        new Label(root, 0);
        new Label(root, 0);
        this.fTabComposite = new Composite(root, 0);
        this.fTabComposite.setLayout((Layout)new StackLayout());
        this.fTabComposite.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.fLibsTabFolder = new TabFolder(this.fTabComposite, 0);
        TabItem tbtmQsys = new TabItem(this.fLibsTabFolder, 0);
        tbtmQsys.setText(Messages.FilterDialog_libraries);
        Composite qsysComposite = new Composite((Composite)this.fLibsTabFolder, 0);
        tbtmQsys.setControl((Control)qsysComposite);
        qsysComposite.setLayout((Layout)new GridLayout(1, true));
        Label l2_1 = new Label(qsysComposite, 0);
        l2_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        l2_1.setText(Messages.FilterDialog_lib_generic);
        this.fLibraries = new LibraryList(qsysComposite, 0);
        this.fLibraries.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        TabItem tbtmObjects = new TabItem(this.fLibsTabFolder, 0);
        tbtmObjects.setText(Messages.FilterDialog_objects);
        Composite objectsComposite = new Composite((Composite)this.fLibsTabFolder, 0);
        tbtmObjects.setControl((Control)objectsComposite);
        objectsComposite.setLayout((Layout)new GridLayout(3, false));
        this.fSourcesOnly = new Button(objectsComposite, 32);
        this.fSourcesOnly.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.fSourcesOnly.setSize(83, 16);
        this.fSourcesOnly.setText(Messages.ui_filter_srcf);
        new Label(objectsComposite, 0);
        Label lblObjGen = new Label(objectsComposite, 0);
        lblObjGen.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblObjGen.setText(Messages.FilterDialog_objects_gen);
        lblObjGen.setBounds(0, 0, 100, 15);
        Label lbl_objType = new Label(objectsComposite, 0);
        lbl_objType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lbl_objType.setText(Messages.FilterDialog_obj_types);
        Label lblAttributes = new Label(objectsComposite, 0);
        lblAttributes.setText(Messages.FilterDialog_attr_gen);
        this.fObjectsList = new LibraryList(objectsComposite, 0);
        this.fObjectsList.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.fObjectTypesList = new LibraryList(objectsComposite, 0);
        this.fObjectTypesList.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.fObjectTypesList.setSize(200, 77);
        this.fObjectAttributes = new LibraryList(objectsComposite, 0);
        this.fObjectAttributes.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        TabItem tbtmMembers = new TabItem(this.fLibsTabFolder, 0);
        tbtmMembers.setText(Messages.FilterDialog_members_tab);
        Composite membersComposite = new Composite((Composite)this.fLibsTabFolder, 0);
        tbtmMembers.setControl((Control)membersComposite);
        membersComposite.setLayout((Layout)new GridLayout(2, false));
        Label lblMembersgeneric = new Label(membersComposite, 0);
        lblMembersgeneric.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblMembersgeneric.setText(Messages.FilterDialog_mbrs_gen);
        Label lblMemberTypes = new Label(membersComposite, 0);
        lblMemberTypes.setText(Messages.FilterDialog_mbr_types_gen);
        this.fMembersList = new LibraryList(membersComposite, 0);
        this.fMembersList.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.fMemberTypeList = new LibraryList(membersComposite, 0);
        this.fMemberTypeList.setLayoutData(new GridData(4, 4, true, false, 1, 1));
        this.fIFSTabFolder = new TabFolder(this.fTabComposite, 0);
        TabItem tbtmIfs = new TabItem(this.fIFSTabFolder, 0);
        tbtmIfs.setText(Messages.FilterDialog_ifs);
        Composite ifsComposite = new Composite((Composite)this.fIFSTabFolder, 0);
        tbtmIfs.setControl((Control)ifsComposite);
        ifsComposite.setLayout((Layout)new GridLayout(4, true));
        Label lbl_ifs = new Label(ifsComposite, 0);
        lbl_ifs.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        lbl_ifs.setText(Messages.ui_filter_regex_example);
        Label l3 = new Label(ifsComposite, 0);
        l3.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        l3.setText(Messages.FilterDialog_extens_gen);
        this.fDirectoryList = new LibraryList(ifsComposite, 0, null);
        this.fDirectoryList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        this.fDirectoryList.setModifier(value -> value.trim());
        this.fExtensionList = new LibraryList(ifsComposite, 0);
        this.fExtensionList.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.fExtensionList.setModifier(value -> value.trim());
        this.loadFilters();
        this.fHelpService.setHelp((Object)parent, "miworkplace.help.MIW: Remote Explorer/Filters");
        return root;
    }

    private void ifsButtonClicked() {
        ((StackLayout)this.fTabComposite.getLayout()).topControl = this.fIfsBtn.getSelection() ? this.fIFSTabFolder : this.fLibsTabFolder;
        this.fTabComposite.requestLayout();
    }

    private void deleteFilter() {
        String name = this.fFilterName.getText();
        Filter filter = this.fFilterManager.getFilter(name);
        if (filter == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.FilterDialog_dlt_filters, (String)Messages.FilterDialog_dlt_confirm);
            return;
        }
        boolean confirm = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.FilterDialog_dlt_filters, (String)MessageFormat.format(Messages.FilterDialog_dlt_confirm_2, name));
        if (confirm) {
            this.fFilterManager.deleteFilter(filter);
            this.fFilterName.setItems(this.fFilterManager.getFilterNames());
            this.fFilterName.setText("");
        }
    }

    private void addFilter() {
        NewFilterDialog dialog;
        int open;
        Object name = "";
        if (this.fFilter != null) {
            name = this.fFilter.getName() + " " + Messages.FilterDialog_copy;
        }
        if ((open = (dialog = new NewFilterDialog(this.getShell()).setFilterName((String)name).setFilterManager(this.fFilterManager)).open()) == 0) {
            Filter filter = this.fFilter == null ? new Filter() : this.fFilter.clone();
            filter.setName(dialog.getFilterName());
            this.fFilterManager.addFilter(filter);
            this.fFilterName.setItems(this.fFilterManager.getFilterNames());
            this.fFilterName.setText(filter.getName());
            this.selectFilter();
        }
    }

    private void loadFilters() {
        Object filterName;
        this.fFilterName.setItems(this.fFilterManager.getFilterNames());
        if (this.fFilter == null && (filterName = this.fContext.get(FilterManager.KEY_LAST_SELECTED_FILTER)) != null) {
            this.fFilter = this.fFilterManager.getFilter(filterName.toString());
        }
        if (this.fFilter == null) {
            this.fFilterName.setText("");
        } else {
            this.fFilterName.setText(this.fFilter.getName());
        }
        this.selectFilter();
    }

    private void selectFilter() {
        this.fFilter = this.fFilterManager.getFilter(this.fFilterName.getText());
        if (this.fFilter != null) {
            this.fLibraries.setInput(this.fFilter.getLibraries());
            this.fDirectoryList.setInput(this.fFilter.getDirectories());
            this.fExtensionList.setInput(this.fFilter.getExtensions());
            this.fMembersList.setInput(this.fFilter.getMembers());
            this.fMemberTypeList.setInput(this.fFilter.getMemberTypes());
            this.fObjectAttributes.setInput(this.fFilter.getObjectAttributes());
            this.fObjectTypesList.setInput(this.fFilter.getObjectTypes());
            this.fObjectsList.setInput(this.fFilter.getObjects());
            this.fSourcesOnly.setSelection(this.fFilter.isSelectSourceFiles());
            this.fActiveBtn.setSelection(this.fFilter.isActive());
            this.fIfsBtn.setSelection(this.fFilter.isIfs());
            this.ifsButtonClicked();
            this.enableControls(true);
            this.fContext.set(FilterManager.KEY_LAST_SELECTED_FILTER, (Object)this.fFilter.getName());
        } else {
            this.fIfsBtn.setSelection(false);
            this.ifsButtonClicked();
            this.enableControls(false);
        }
    }

    private void enableControls(boolean pEnable) {
        this.fActiveBtn.setEnabled(pEnable);
        this.fIfsBtn.setEnabled(pEnable);
        this.fLibraries.setEnabled(pEnable);
        this.fDirectoryList.setEnabled(pEnable);
        this.fExtensionList.setEnabled(pEnable);
        this.fMembersList.setEnabled(pEnable);
        this.fMemberTypeList.setEnabled(pEnable);
        this.fObjectAttributes.setEnabled(pEnable);
        this.fObjectTypesList.setEnabled(pEnable);
        this.fObjectsList.setEnabled(pEnable);
        this.fSourcesOnly.setEnabled(pEnable);
    }

    protected void okPressed() {
        this.saveFilter();
        super.okPressed();
    }

    private void saveFilter() {
        String name = this.fFilterName.getText().trim();
        if (!name.isEmpty()) {
            Filter filter = new Filter();
            filter.setName(name);
            filter.setLibraries(this.fLibraries.getElements());
            filter.setMembers(this.fMembersList.getElements());
            filter.setMemberTypes(this.fMemberTypeList.getElements());
            filter.setDirectories(this.fDirectoryList.getElements());
            filter.setExtensions(this.fExtensionList.getElements());
            filter.setObjectAttributes(this.fObjectAttributes.getElements());
            filter.setObjects(this.fObjectsList.getElements());
            filter.setObjectTypes(this.fObjectTypesList.getElements());
            filter.setSelectSourceFiles(this.fSourcesOnly.getSelection());
            filter.setActive(this.fActiveBtn.getSelection());
            filter.setIfs(this.fIfsBtn.getSelection());
            filter.setActive(this.fActiveBtn.getSelection());
            this.fFilterManager.addFilter(filter);
        }
    }

    protected void createButtonsForButtonBar(Composite pParent) {
        this.createButton(pParent, 500, Messages.FilterDialog_import, false);
        this.createButton(pParent, 501, Messages.FilterDialog_export, false);
        this.createButton(pParent, 502, Messages.FilterDialog_apply, false);
        super.createButtonsForButtonBar(pParent);
    }

    protected void buttonPressed(int pButtonId) {
        if (pButtonId == 500) {
            this.fFilterManager.importFilters(this.getShell());
            this.loadFilters();
        } else if (pButtonId == 501) {
            this.fFilterManager.exportFilters(this.getShell());
            this.loadFilters();
        } else if (pButtonId == 502) {
            this.saveFilter();
            MiniMessage.get((int)2000).above((Control)this.getButton(502)).submit(Messages.FilterDialog_msg_saved);
        }
        super.buttonPressed(pButtonId);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 1) {
            return null;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        parent.pack();
        return content;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Rectangle bounds = this.getShell().getBounds();
        Point location = this.getInitialLocation(new Point(bounds.width, bounds.height));
        this.getShell().setBounds(location.x, location.y, bounds.width, bounds.height);
    }

    protected Point getInitialLocation(Point initialSize) {
        Composite parent = this.getShell().getParent();
        Monitor monitor = this.getShell().getDisplay().getPrimaryMonitor();
        if (parent != null) {
            monitor = parent.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = parent != null ? Geometry.centerPoint((Rectangle)parent.getBounds()) : Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    protected boolean isResizable() {
        return true;
    }
}

