/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.ui.explorer.MemberDescription;

public class MemberList {
    private static final String MEMBERLIST_USER_SPACE = "/QSYS.LIB/QTEMP.LIB/JT4QUSLMBR.USRSPC";
    private static final String ALL = "*ALL";
    private static final SimpleDateFormat osDateTimeFormat = new SimpleDateFormat("yyMMddHHmmss");
    private static final String QUSLMBR_FORMAT_100 = "MBRL0100";
    private static final String QUSLMBR_FORMAT_200 = "MBRL0200";
    private AS400 system;
    private QSYSObjectPathName path;
    private String memberSelection = "*ALL";
    private final Map members = new HashMap();
    private final List attributes = new ArrayList();
    private static final int OFFSET_CREATION_DATE_TIME = 20;
    private static final int OFFSET_LAST_SOURCE_CHANGE_DATE = 33;
    private static final int OFFSET_MEMBER_NAME = 0;
    private static final int OFFSET_MEMBER_TEXT_DESCRIPTION = 46;
    private static final int OFFSET_SOURCE_TYPE = 10;
    private static final int OFFSET_MEMBER_TEXT_DESCRIPTION_CCSID = 96;
    private final AS400Bin4 intConverter = new AS400Bin4();
    private static Debug logger = Debug.getInstance();

    public MemberList(AS400 system, QSYSObjectPathName path) {
        if (system == null) {
            throw new NullPointerException("AS400 system object is null.");
        }
        if (path == null) {
            throw new NullPointerException("IFS path object is null.");
        }
        this.system = system;
        this.path = path;
        this.memberSelection = path.getMemberName().length() == 0 ? ALL : path.getMemberName();
    }

    private String lookupFormat(int attribute) {
        return switch (attribute) {
            case 7 -> QUSLMBR_FORMAT_100;
            case 1, 6, 8, 10, 28 -> QUSLMBR_FORMAT_200;
            default -> QUSLMBR_FORMAT_200;
        };
    }

    public void clear() {
        this.members.clear();
    }

    public void clearAttributeList() {
        this.attributes.clear();
    }

    public void addAttribute(int attribute) {
        this.attributes.add(attribute);
    }

    public void refresh() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, Exception {
        this.clear();
        this.load();
    }

    public void load() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, Exception {
        logger.debug((Option)miworkplace.ui.debug.Option.loading, "Start member load");
        String format = this.getFormat();
        CharConverter charConverter = new CharConverter(this.system.getCcsid(), this.system);
        byte[] byteArr = new byte[4];
        byte[] userSpaceBytes = new byte[65535];
        int entrySize = 0;
        int listPosition = 0;
        int listEntries = 0;
        int userspacePosition = 0;
        int userspaceOffset = 0;
        int entryPosition = 0;
        logger.debug((Option)miworkplace.ui.debug.Option.loading, "Creating user space for member load");
        UserSpace us = new UserSpace(this.system, MEMBERLIST_USER_SPACE);
        us.setMustUseProgramCall(true);
        us.create(327675, true, "JT400", (byte)0, "Userspace for loading members", ALL);
        ProgramCall program = new ProgramCall(this.system, "/QSYS.LIB/QUSLMBR.PGM", this.buildProgramParameters());
        if (!this.system.isConnected()) {
            throw new IOException("Client is not connected to the server.");
        }
        if (!us.exists()) {
            throw new Exception("The userspace object JT4QUSLMBR in library QTEMP does not exist.");
        }
        logger.debug((Option)miworkplace.ui.debug.Option.loading, "Filling user space for member load");
        if (program.run()) {
            logger.debug((Option)miworkplace.ui.debug.Option.loading, "Done filling user space for member load");
            us.read(userSpaceBytes, userspacePosition);
            System.arraycopy(userSpaceBytes, 124, byteArr, 0, 4);
            listPosition = this.intConverter.toInt(byteArr);
            System.arraycopy(userSpaceBytes, 132, byteArr, 0, 4);
            listEntries = this.intConverter.toInt(byteArr);
            System.arraycopy(userSpaceBytes, 136, byteArr, 0, 4);
            entrySize = this.intConverter.toInt(byteArr);
            byte[] libraryBytes = new byte[10];
            System.arraycopy(userSpaceBytes, 116, byteArr, 0, 4);
            int headerSectionOffset = this.intConverter.toInt(byteArr);
            System.arraycopy(userSpaceBytes, headerSectionOffset + 10, libraryBytes, 0, 10);
            String usedLibraryName = charConverter.byteArrayToString(libraryBytes).trim();
            byte[] entryBytes = new byte[entrySize];
            logger.debug((Option)miworkplace.ui.debug.Option.loading, "Parsing user space for member load. Entries: " + listEntries);
            userspaceOffset = listPosition;
            int i = 0;
            while (i < listEntries) {
                if (entryPosition * entrySize + entrySize + userspaceOffset > userSpaceBytes.length) {
                    userspacePosition = us.read(userSpaceBytes, i * entrySize + listPosition);
                    userspaceOffset = 0;
                    entryPosition = 0;
                }
                System.arraycopy(userSpaceBytes, entryPosition * entrySize + userspaceOffset, entryBytes, 0, entrySize);
                this.readMemberInfoFromUserspaceEntry(entryBytes, format, charConverter, usedLibraryName);
                ++entryPosition;
                ++i;
            }
        } else {
            throw new AS400Exception(program.getMessageList());
        }
    }

    private ProgramParameter[] buildProgramParameters() {
        QSYSObjectPathName filePath = new QSYSObjectPathName(this.path.getLibraryName(), this.path.getObjectName(), "FILE");
        ProgramParameter[] parameterList = new ProgramParameter[]{new ProgramParameter(CharConverter.stringToByteArray((AS400)this.system, (String)"JT4QUSLMBRQTEMP     ")), new ProgramParameter(CharConverter.stringToByteArray((AS400)this.system, (String)this.getFormat())), new ProgramParameter(CharConverter.stringToByteArray((AS400)this.system, (String)filePath.toQualifiedObjectName())), new ProgramParameter(new AS400Text(10).toBytes((Object)this.memberSelection)), new ProgramParameter(CharConverter.stringToByteArray((AS400)this.system, (String)"1"))};
        return parameterList;
    }

    private void readMemberInfoFromUserspaceEntry(byte[] entryBytes, String format, CharConverter charConverter, String usedLibraryName) throws PropertyVetoException {
        String memberName = charConverter.byteArrayToString(entryBytes, 0, 10).trim();
        MemberDescription memberDescription = (MemberDescription)this.members.get(memberName);
        if (memberDescription == null) {
            QSYSObjectPathName memberPath = new QSYSObjectPathName(this.path.getPath());
            memberPath.setMemberName(memberName);
            memberPath.setLibraryName(usedLibraryName);
            memberDescription = new MemberDescription(this.system, memberPath);
            memberDescription.setAttribute(7, memberName);
            this.members.put(memberName, memberDescription);
        }
        if (format.equals(QUSLMBR_FORMAT_200)) {
            memberDescription.setAttribute(10, charConverter.byteArrayToString(entryBytes, 10, 10).trim());
            memberDescription.setAttribute(8, charConverter.byteArrayToString(entryBytes, 46, 50).trim());
            memberDescription.setAttribute(28, new Integer(this.intConverter.toInt(entryBytes, 96)));
            memberDescription.setAttribute(6, this.transformDate(charConverter.byteArrayToString(entryBytes, 33, 13)));
            memberDescription.setAttribute(1, this.transformDate(charConverter.byteArrayToString(entryBytes, 20, 13)));
        }
    }

    public MemberDescription[] getMemberDescriptions() {
        return this.members.values().toArray(new MemberDescription[this.members.size()]);
    }

    private String getFormat() {
        String format = QUSLMBR_FORMAT_100;
        Iterator iter = this.attributes.iterator();
        while (iter.hasNext()) {
            String tmpFormat = this.lookupFormat((Integer)iter.next());
            if (format.compareTo(tmpFormat) >= 0) continue;
            format = tmpFormat;
        }
        return format;
    }

    private Date transformDate(String osDateString) {
        Date retVal = null;
        if (osDateString != null && !osDateString.equals("")) {
            try {
                retVal = osDateTimeFormat.parse(osDateString.substring(1));
            }
            catch (ParseException parseException) {}
        }
        return retVal;
    }
}

