/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.dialog;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.UserSpace;
import java.text.SimpleDateFormat;
import miworkplace.common.model.IConnection;
import miworkplace.ui.dialog.BoundModule;
import miworkplace.ui.dialog.BoundServiceProgram;
import miworkplace.ui.dialog.ServiceProgramInfo;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.log.LogService;

class ServiceProgramInfoRetriever
implements Runnable {
    private final int OFFSET_US_LISTSECTION = 124;
    private final int OFFSET_US_LIST_ENTRIES = 132;
    private final int OFFSET_US_LIST_ENTRY_SIZE = 136;
    private IConnection connection;
    private ServiceProgramInfo info;
    private String ifsPath;
    private LogService logger;

    public ServiceProgramInfoRetriever(IConnection connection, ServiceProgramInfo info, String ifsPath, LogService logger) {
        this.connection = connection;
        this.info = info;
        this.ifsPath = ifsPath;
        this.logger = logger;
    }

    @Override
    public void run() {
        AS400 system = this.connection.getSystem();
        UserSpace us = null;
        try {
            try {
                us = new UserSpace(this.connection.getSystem(), "/QSYS.LIB/QTEMP.LIB/MIWSRVPGM.USRSPC");
                us.setMustUseProgramCall(true);
                if (us.exists()) {
                    us.delete();
                }
                us.create(65535, true, "MIWORKPLAC", (byte)0, "Userspace for loading Service Program Info", "*ALL");
                AS400Bin4 int400 = new AS400Bin4();
                CharConverter conv = new CharConverter(this.connection.getSystem().getCcsid(), this.connection.getSystem());
                this.getServiceProgramInformation(this.info, system, int400, conv, this.ifsPath);
                this.getServiceProgramBounded(this.info, system, us, int400, conv, this.ifsPath);
                this.getServiceProgramDataExports(this.info, system, us, int400, conv, this.ifsPath);
                this.getServiceProgramSignatures(this.info, system, us, int400, conv, this.ifsPath);
                this.getServiceProgramCopyrights(this.info, system, us, int400, conv, this.ifsPath);
                this.getServiceProgramProcedures(this.info, system, us, int400, conv, this.ifsPath);
                this.getServiceProgramModules(this.info, system, us, int400, conv, this.ifsPath);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                if (us != null && us.exists()) {
                    us.delete();
                }
            }
            catch (Exception e) {
                this.logger.log(2, "Could not clean up after getting service program information.", (Throwable)e);
            }
        }
    }

    private void getServiceProgramInformation(ServiceProgramInfo info, AS400 system, AS400Bin4 int400, CharConverter conv, String ifsPath) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
        QSYSObjectPathName serviceProgramPath = new QSYSObjectPathName(ifsPath);
        ProgramCall program = new ProgramCall(system);
        String programName = "/QSYS.LIB/QBNRSPGM.PGM";
        ProgramParameter[] parameterList = new ProgramParameter[5];
        AS400Text text400 = new AS400Text(20, system);
        parameterList[0] = new ProgramParameter(1024);
        parameterList[1] = new ProgramParameter(int400.toBytes(1024));
        parameterList[2] = new ProgramParameter(text400.toBytes((Object)"SPGI0100"));
        parameterList[3] = new ProgramParameter(text400.toBytes((Object)serviceProgramPath.toQualifiedObjectName()));
        parameterList[4] = new ProgramParameter(int400.toBytes(0));
        program.setProgram(programName, parameterList);
        if (!program.run()) {
            String message = this.buildExceptionMessage(program);
            throw new RuntimeException(message);
        }
        byte[] byteArr = new byte[4];
        byte[] outputData = parameterList[0].getOutputData();
        info.name = conv.byteArrayToString(outputData, 8, 10).trim();
        info.library = conv.byteArrayToString(outputData, 18, 10).trim();
        info.owner = conv.byteArrayToString(outputData, 28, 10).trim();
        info.attribute = conv.byteArrayToString(outputData, 38, 10).trim();
        info.created = dateFormat.parse(conv.byteArrayToString(outputData, 48, 13).substring(1));
        info.exportSourceName = conv.byteArrayToString(outputData, 61, 10).trim();
        info.exportSourceLibrary = conv.byteArrayToString(outputData, 71, 10).trim();
        info.exportSourceMember = conv.byteArrayToString(outputData, 81, 10).trim();
        info.activationGroup = conv.byteArrayToString(outputData, 91, 30).trim();
        info.currentSignature = conv.byteArrayToString(outputData, 121, 16).trim();
        info.userProfile = conv.byteArrayToString(outputData, 137, 1).equals("O") ? "owner" : "current user";
        System.arraycopy(outputData, 140, byteArr, 0, 4);
        info.ccsid = int400.toInt(byteArr);
        info.description = conv.byteArrayToString(outputData, 156, 50).trim();
        info.sharedActivationGroup = conv.byteArrayToString(outputData, 206, 1).equals("Y");
        info.allowUpdate = conv.byteArrayToString(outputData, 207, 1).equals("Y");
        System.arraycopy(outputData, 208, byteArr, 0, 4);
        info.numberUnresolvedReferences = int400.toInt(byteArr);
        info.useAdoptedAuthority = conv.byteArrayToString(outputData, 212, 1).equals("Y");
        info.allowBoundServiceProgramLibraryUpdate = conv.byteArrayToString(outputData, 213, 1).equals("Y");
        String storageModel = conv.byteArrayToString(outputData, 225, 1);
        info.storageModel = storageModel.equals("0") ? "single-level storage" : (storageModel.equals("1") ? "teraspace" : "inherit");
        info.domain = conv.byteArrayToString(outputData, 307, 1).equals("S") ? "system domain" : "user domain";
        String state = conv.byteArrayToString(outputData, 307, 1);
        info.state = state.equals("I") ? "inherit state" : (state.equals("S") ? "system state" : "user state");
        System.arraycopy(outputData, 308, byteArr, 0, 4);
        info.associatedSpaceSize = int400.toInt(byteArr);
        System.arraycopy(outputData, 312, byteArr, 0, 4);
        info.staticStorageSize = int400.toInt(byteArr);
        System.arraycopy(outputData, 316, byteArr, 0, 4);
        info.size = int400.toInt(byteArr);
        info.releaseCreated = conv.byteArrayToString(outputData, 320, 6).trim();
        info.releaseEarliestRun = conv.byteArrayToString(outputData, 326, 6).trim();
        info.releaseCreatedFor = conv.byteArrayToString(outputData, 332, 6).trim();
        info.allowStaticStorageInitialization = conv.byteArrayToString(outputData, 338, 1).equals("Y");
    }

    private String buildExceptionMessage(ProgramCall program) {
        StringBuffer buffer = new StringBuffer();
        AS400Message[] messagelist = program.getMessageList();
        int i = 0;
        while (i < messagelist.length) {
            buffer.append(messagelist[i].toString());
            if (i + 1 < messagelist.length) {
                buffer.append(System.getProperty("line.separator"));
            }
            ++i;
        }
        return buffer.toString();
    }

    private void getServiceProgramSignatures(ServiceProgramInfo info, AS400 system, UserSpace us, AS400Bin4 int400, CharConverter conv, String ifsPath) throws Exception {
        int OFFSET_LIST_SIGNATURE_SRVPGM_SIGNATURE = 20;
        QSYSObjectPathName serviceProgramPath = new QSYSObjectPathName(ifsPath);
        QSYSObjectPathName usPath = new QSYSObjectPathName(us.getPath());
        ProgramCall program = new ProgramCall(system);
        String programName = "/QSYS.LIB/QBNLSPGM.PGM";
        ProgramParameter[] parameterList = new ProgramParameter[4];
        AS400Text text400 = new AS400Text(20, system);
        parameterList[0] = new ProgramParameter(text400.toBytes((Object)(StringUtils.rightPad((String)us.getName(), (int)10) + StringUtils.rightPad((String)usPath.getLibraryName(), (int)10))));
        parameterList[1] = new ProgramParameter(text400.toBytes((Object)"SPGL0800"));
        parameterList[2] = new ProgramParameter(text400.toBytes((Object)serviceProgramPath.toQualifiedObjectName()));
        parameterList[3] = new ProgramParameter(int400.toBytes(0));
        byte[] byteArr = new byte[4];
        byte[] userSpaceBytes = new byte[65535];
        int entrySize = 0;
        int listPosition = 0;
        int listEntries = 0;
        int userspacePosition = 0;
        int userspaceOffset = 0;
        int entryPosition = 0;
        program.setProgram(programName, parameterList);
        if (program.run()) {
            us.read(userSpaceBytes, userspacePosition);
            System.arraycopy(userSpaceBytes, 124, byteArr, 0, 4);
            listPosition = int400.toInt(byteArr);
            System.arraycopy(userSpaceBytes, 132, byteArr, 0, 4);
            listEntries = int400.toInt(byteArr);
            System.arraycopy(userSpaceBytes, 136, byteArr, 0, 4);
            entrySize = int400.toInt(byteArr);
            userspaceOffset = listPosition;
            int i = 0;
            while (i < listEntries) {
                if (entryPosition * entrySize + OFFSET_LIST_SIGNATURE_SRVPGM_SIGNATURE + userspaceOffset + 10 > userSpaceBytes.length) {
                    userspacePosition = us.read(userSpaceBytes, i * entrySize + listPosition);
                    userspaceOffset = 0;
                    entryPosition = 0;
                }
                String signature = conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + OFFSET_LIST_SIGNATURE_SRVPGM_SIGNATURE + userspaceOffset, 16).trim();
                info.signatures.add(signature);
                ++entryPosition;
                ++i;
            }
        } else {
            String message = this.buildExceptionMessage(program);
            throw new RuntimeException(message);
        }
    }

    private void getServiceProgramBounded(ServiceProgramInfo info, AS400 system, UserSpace us, AS400Bin4 int400, CharConverter conv, String ifsPath) throws Exception {
        int OFFSET_LIST_BOUND_SRVPGM_NAME = 20;
        int OFFSET_LIST_BOUND_SRVPGM_LIBRARY = 30;
        int OFFSET_LIST_BOUND_SRVPGM_SIGNATURE = 40;
        int OFFSET_LIST_BOUND_SRVPGM_ACTIVATION = 56;
        QSYSObjectPathName serviceProgramPath = new QSYSObjectPathName(ifsPath);
        QSYSObjectPathName usPath = new QSYSObjectPathName(us.getPath());
        ProgramCall program = new ProgramCall(system);
        String programName = "/QSYS.LIB/QBNLSPGM.PGM";
        ProgramParameter[] parameterList = new ProgramParameter[4];
        AS400Text text400 = new AS400Text(20, system);
        parameterList[0] = new ProgramParameter(text400.toBytes((Object)(StringUtils.rightPad((String)us.getName(), (int)10) + StringUtils.rightPad((String)usPath.getLibraryName(), (int)10))));
        parameterList[1] = new ProgramParameter(text400.toBytes((Object)"SPGL0200"));
        parameterList[2] = new ProgramParameter(text400.toBytes((Object)serviceProgramPath.toQualifiedObjectName()));
        parameterList[3] = new ProgramParameter(int400.toBytes(0));
        byte[] byteArr = new byte[4];
        byte[] userSpaceBytes = new byte[65535];
        int entrySize = 0;
        int listPosition = 0;
        int listEntries = 0;
        int userspacePosition = 0;
        int userspaceOffset = 0;
        int entryPosition = 0;
        program.setProgram(programName, parameterList);
        if (program.run()) {
            us.read(userSpaceBytes, userspacePosition);
            System.arraycopy(userSpaceBytes, 124, byteArr, 0, 4);
            listPosition = int400.toInt(byteArr);
            System.arraycopy(userSpaceBytes, 132, byteArr, 0, 4);
            listEntries = int400.toInt(byteArr);
            System.arraycopy(userSpaceBytes, 136, byteArr, 0, 4);
            entrySize = int400.toInt(byteArr);
            userspaceOffset = listPosition;
            int i = 0;
            while (i < listEntries) {
                if (entryPosition * entrySize + OFFSET_LIST_BOUND_SRVPGM_ACTIVATION + userspaceOffset + 10 > userSpaceBytes.length) {
                    userspacePosition = us.read(userSpaceBytes, i * entrySize + listPosition);
                    userspaceOffset = 0;
                    entryPosition = 0;
                }
                String name = conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + OFFSET_LIST_BOUND_SRVPGM_NAME + userspaceOffset, 10).trim();
                String library = conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + OFFSET_LIST_BOUND_SRVPGM_LIBRARY + userspaceOffset, 10).trim();
                if (StringUtils.isBlank((CharSequence)library)) {
                    library = "*LIBL";
                }
                String signature = conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + OFFSET_LIST_BOUND_SRVPGM_SIGNATURE + userspaceOffset, 16).trim();
                String activation = conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + OFFSET_LIST_BOUND_SRVPGM_ACTIVATION + userspaceOffset, 10).trim();
                BoundServiceProgram bound = new BoundServiceProgram().setActivation(activation).setLibrary(library).setServiceProgram(name).setSignature(signature);
                info.bounded.add(bound);
                ++entryPosition;
                ++i;
            }
        } else {
            String message = this.buildExceptionMessage(program);
            throw new RuntimeException(message);
        }
    }

    private void getServiceProgramDataExports(ServiceProgramInfo info, AS400 system, UserSpace us, AS400Bin4 int400, CharConverter conv, String ifsPath) throws Exception {
        int OFFSET_LIST_DATA_NAME_LENGTH = 24;
        int OFFSET_LIST_DATA_NAME = 28;
        QSYSObjectPathName serviceProgramPath = new QSYSObjectPathName(ifsPath);
        QSYSObjectPathName usPath = new QSYSObjectPathName(us.getPath());
        ProgramCall program = new ProgramCall(system);
        String programName = "/QSYS.LIB/QBNLSPGM.PGM";
        ProgramParameter[] parameterList = new ProgramParameter[4];
        AS400Text text400 = new AS400Text(20, system);
        parameterList[0] = new ProgramParameter(text400.toBytes((Object)(StringUtils.rightPad((String)us.getName(), (int)10) + StringUtils.rightPad((String)usPath.getLibraryName(), (int)10))));
        parameterList[1] = new ProgramParameter(text400.toBytes((Object)"SPGL0700"));
        parameterList[2] = new ProgramParameter(text400.toBytes((Object)serviceProgramPath.toQualifiedObjectName()));
        parameterList[3] = new ProgramParameter(int400.toBytes(0));
        byte[] byteArr = new byte[4];
        byte[] userSpaceBytes = new byte[65535];
        int entrySize = 0;
        int listPosition = 0;
        int listEntries = 0;
        int userspacePosition = 0;
        int userspaceOffset = 0;
        int entryPosition = 0;
        program.setProgram(programName, parameterList);
        if (program.run()) {
            us.read(userSpaceBytes, userspacePosition);
            System.arraycopy(userSpaceBytes, 124, byteArr, 0, 4);
            listPosition = int400.toInt(byteArr);
            System.arraycopy(userSpaceBytes, 132, byteArr, 0, 4);
            listEntries = int400.toInt(byteArr);
            System.arraycopy(userSpaceBytes, 136, byteArr, 0, 4);
            entrySize = int400.toInt(byteArr);
            userspaceOffset = listPosition;
            int i = 0;
            while (i < listEntries) {
                if (entryPosition * entrySize + OFFSET_LIST_DATA_NAME + userspaceOffset + 10 > userSpaceBytes.length) {
                    userspacePosition = us.read(userSpaceBytes, i * entrySize + listPosition);
                    userspaceOffset = 0;
                    entryPosition = 0;
                }
                System.arraycopy(userSpaceBytes, entryPosition * entrySize + userspaceOffset + OFFSET_LIST_DATA_NAME_LENGTH, byteArr, 0, 4);
                int nameLength = int400.toInt(byteArr);
                if (nameLength > 0) {
                    String name = conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + OFFSET_LIST_DATA_NAME + userspaceOffset, nameLength).trim();
                    info.dataExports.add(name);
                }
                ++entryPosition;
                ++i;
            }
        } else {
            String message = this.buildExceptionMessage(program);
            throw new RuntimeException(message);
        }
    }

    private void getServiceProgramCopyrights(ServiceProgramInfo info, AS400 system, UserSpace us, AS400Bin4 int400, CharConverter conv, String ifsPath) throws Exception {
        int OFFSET_LIST_COPYRIGHT_LENGTH = 24;
        int OFFSET_LIST_COPYRIGHT_TEXT = 28;
        QSYSObjectPathName serviceProgramPath = new QSYSObjectPathName(ifsPath);
        QSYSObjectPathName usPath = new QSYSObjectPathName(us.getPath());
        ProgramCall program = new ProgramCall(system);
        String programName = "/QSYS.LIB/QBNLSPGM.PGM";
        ProgramParameter[] parameterList = new ProgramParameter[4];
        AS400Text text400 = new AS400Text(20, system);
        parameterList[0] = new ProgramParameter(text400.toBytes((Object)(StringUtils.rightPad((String)us.getName(), (int)10) + StringUtils.rightPad((String)usPath.getLibraryName(), (int)10))));
        parameterList[1] = new ProgramParameter(text400.toBytes((Object)"SPGL0500"));
        parameterList[2] = new ProgramParameter(text400.toBytes((Object)serviceProgramPath.toQualifiedObjectName()));
        parameterList[3] = new ProgramParameter(int400.toBytes(0));
        byte[] byteArr = new byte[4];
        byte[] userSpaceBytes = new byte[65535];
        int entrySize = 0;
        int listPosition = 0;
        int listEntries = 0;
        int userspacePosition = 0;
        int userspaceOffset = 0;
        int entryPosition = 0;
        program.setProgram(programName, parameterList);
        if (program.run()) {
            us.read(userSpaceBytes, userspacePosition);
            System.arraycopy(userSpaceBytes, 124, byteArr, 0, 4);
            listPosition = int400.toInt(byteArr);
            System.arraycopy(userSpaceBytes, 132, byteArr, 0, 4);
            listEntries = int400.toInt(byteArr);
            System.arraycopy(userSpaceBytes, 136, byteArr, 0, 4);
            entrySize = int400.toInt(byteArr);
            userspaceOffset = listPosition;
            int i = 0;
            while (i < listEntries) {
                if (entryPosition * entrySize + OFFSET_LIST_COPYRIGHT_TEXT + userspaceOffset + 10 > userSpaceBytes.length) {
                    userspacePosition = us.read(userSpaceBytes, i * entrySize + listPosition);
                    userspaceOffset = 0;
                    entryPosition = 0;
                }
                System.arraycopy(userSpaceBytes, entryPosition * entrySize + userspaceOffset + OFFSET_LIST_COPYRIGHT_LENGTH, byteArr, 0, 4);
                int textLength = int400.toInt(byteArr);
                String copyright = conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + OFFSET_LIST_COPYRIGHT_TEXT + userspaceOffset, textLength).trim();
                info.copyrights.add(copyright);
                ++entryPosition;
                ++i;
            }
        } else {
            String message = this.buildExceptionMessage(program);
            throw new RuntimeException(message);
        }
    }

    private void getServiceProgramProcedures(ServiceProgramInfo info, AS400 system, UserSpace us, AS400Bin4 int400, CharConverter conv, String ifsPath) throws Exception {
        int OFFSET_LIST_PROCEDURE_NAME_LENGTH = 24;
        int OFFSET_LIST_PROCEDURE_NAME = 28;
        QSYSObjectPathName serviceProgramPath = new QSYSObjectPathName(ifsPath);
        QSYSObjectPathName usPath = new QSYSObjectPathName(us.getPath());
        ProgramCall program = new ProgramCall(system);
        String programName = "/QSYS.LIB/QBNLSPGM.PGM";
        ProgramParameter[] parameterList = new ProgramParameter[4];
        AS400Text text400 = new AS400Text(20, system);
        parameterList[0] = new ProgramParameter(text400.toBytes((Object)(StringUtils.rightPad((String)us.getName(), (int)10) + StringUtils.rightPad((String)usPath.getLibraryName(), (int)10))));
        parameterList[1] = new ProgramParameter(text400.toBytes((Object)"SPGL0600"));
        parameterList[2] = new ProgramParameter(text400.toBytes((Object)serviceProgramPath.toQualifiedObjectName()));
        parameterList[3] = new ProgramParameter(int400.toBytes(0));
        byte[] byteArr = new byte[4];
        byte[] userSpaceBytes = new byte[65535];
        int entrySize = 0;
        int listPosition = 0;
        int listEntries = 0;
        int userspacePosition = 0;
        int userspaceOffset = 0;
        int entryPosition = 0;
        program.setProgram(programName, parameterList);
        if (program.run()) {
            us.read(userSpaceBytes, userspacePosition);
            System.arraycopy(userSpaceBytes, 124, byteArr, 0, 4);
            listPosition = int400.toInt(byteArr);
            System.arraycopy(userSpaceBytes, 132, byteArr, 0, 4);
            listEntries = int400.toInt(byteArr);
            System.arraycopy(userSpaceBytes, 136, byteArr, 0, 4);
            entrySize = int400.toInt(byteArr);
            userspaceOffset = listPosition;
            int i = 0;
            while (i < listEntries) {
                if (entryPosition * entrySize + OFFSET_LIST_PROCEDURE_NAME + userspaceOffset + 10 > userSpaceBytes.length) {
                    userspacePosition = us.read(userSpaceBytes, i * entrySize + listPosition);
                    userspaceOffset = 0;
                    entryPosition = 0;
                }
                System.arraycopy(userSpaceBytes, entryPosition * entrySize + userspaceOffset + OFFSET_LIST_PROCEDURE_NAME_LENGTH, byteArr, 0, 4);
                int nameLength = int400.toInt(byteArr);
                if (nameLength > 0) {
                    String procedure = conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + OFFSET_LIST_PROCEDURE_NAME + userspaceOffset, nameLength).trim();
                    info.procedures.add(procedure);
                }
                ++entryPosition;
                ++i;
            }
        } else {
            String message = this.buildExceptionMessage(program);
            throw new RuntimeException(message);
        }
    }

    private void getServiceProgramModules(ServiceProgramInfo info, AS400 system, UserSpace us, AS400Bin4 int400, CharConverter conv, String ifsPath) throws Exception {
        int OFFSET_LIST_MODULE_NAME = 20;
        int OFFSET_LIST_MODULE_LIBRARY = 30;
        QSYSObjectPathName serviceProgramPath = new QSYSObjectPathName(ifsPath);
        QSYSObjectPathName usPath = new QSYSObjectPathName(us.getPath());
        ProgramCall program = new ProgramCall(system);
        String programName = "/QSYS.LIB/QBNLSPGM.PGM";
        ProgramParameter[] parameterList = new ProgramParameter[4];
        AS400Text text400 = new AS400Text(20, system);
        parameterList[0] = new ProgramParameter(text400.toBytes((Object)(StringUtils.rightPad((String)us.getName(), (int)10) + StringUtils.rightPad((String)usPath.getLibraryName(), (int)10))));
        parameterList[1] = new ProgramParameter(text400.toBytes((Object)"SPGL0100"));
        parameterList[2] = new ProgramParameter(text400.toBytes((Object)serviceProgramPath.toQualifiedObjectName()));
        parameterList[3] = new ProgramParameter(int400.toBytes(0));
        byte[] byteArr = new byte[4];
        byte[] userSpaceBytes = new byte[65535];
        int entrySize = 0;
        int listPosition = 0;
        int listEntries = 0;
        int userspacePosition = 0;
        int userspaceOffset = 0;
        int entryPosition = 0;
        program.setProgram(programName, parameterList);
        if (program.run()) {
            us.read(userSpaceBytes, userspacePosition);
            System.arraycopy(userSpaceBytes, 124, byteArr, 0, 4);
            listPosition = int400.toInt(byteArr);
            System.arraycopy(userSpaceBytes, 132, byteArr, 0, 4);
            listEntries = int400.toInt(byteArr);
            System.arraycopy(userSpaceBytes, 136, byteArr, 0, 4);
            entrySize = int400.toInt(byteArr);
            userspaceOffset = listPosition;
            int i = 0;
            while (i < listEntries) {
                if (entryPosition * entrySize + OFFSET_LIST_MODULE_LIBRARY + userspaceOffset + 10 > userSpaceBytes.length) {
                    userspacePosition = us.read(userSpaceBytes, i * entrySize + listPosition);
                    userspaceOffset = 0;
                    entryPosition = 0;
                }
                String module = conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + OFFSET_LIST_MODULE_NAME + userspaceOffset, 10).trim();
                String library = conv.byteArrayToString(userSpaceBytes, entryPosition * entrySize + OFFSET_LIST_MODULE_LIBRARY + userspaceOffset, 10).trim();
                if (StringUtils.isBlank((CharSequence)library)) {
                    library = "*LIBL";
                }
                info.modules.add(new BoundModule().setLibrary(library).setName(module));
                ++entryPosition;
                ++i;
            }
        } else {
            String message = this.buildExceptionMessage(program);
            throw new RuntimeException(message);
        }
    }
}

