/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.connection.wizard;

import miworkplace.i18n.Messages;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConnectionWizardPage
extends WizardPage {
    private Text txtConnectionName;
    private Text txtServer;
    private Text txtUsername;
    private EHelpService fHelpService;
    private Button fSecureBtn;

    public ConnectionWizardPage(EHelpService pHelpService) {
        super(Messages.ui_conn_wiz_page_title);
        this.fHelpService = pHelpService;
        this.setTitle(Messages.ui_conn_wiz_page_title);
        this.setDescription(Messages.ui_conn_wiz_page_desc);
    }

    public void createControl(Composite parent) {
        Composite controls = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        controls.setLayout((Layout)gridLayout);
        Label lblConnection = new Label(controls, 0);
        lblConnection.setText(Messages.ui_conn_wiz_page_conn);
        this.txtConnectionName = new Text(controls, 2048);
        this.txtConnectionName.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.txtConnectionName.addListener(24, event -> this.testPageComplete());
        Label lblServer = new Label(controls, 0);
        lblServer.setText(Messages.ui_conn_wiz_page_host);
        this.txtServer = new Text(controls, 2048);
        this.txtServer.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.txtServer.addListener(24, event -> this.testPageComplete());
        Label lblSecure = new Label(controls, 0);
        lblSecure.setText(Messages.ui_conn_wiz_page_secure);
        this.fSecureBtn = new Button(controls, 32);
        this.fSecureBtn.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.fSecureBtn.addListener(13, event -> this.testPageComplete());
        Label lblUsername = new Label(controls, 0);
        lblUsername.setText(Messages.ui_conn_wiz_page_user);
        this.txtUsername = new Text(controls, 2048);
        this.txtUsername.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.txtUsername.addListener(24, event -> this.testPageComplete());
        this.setControl((Control)controls);
        this.txtConnectionName.setFocus();
        this.txtConnectionName.setText(Messages.ui_conn_wiz_page_host_default);
        this.txtConnectionName.selectAll();
    }

    public void performHelp() {
        this.fHelpService.displayHelp("miworkplace.help.MIW: Connections");
    }

    private void testPageComplete() {
        if (this.txtConnectionName.getText().trim().isEmpty() || this.txtServer.getText().trim().isEmpty()) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    public String getServername() {
        return this.txtServer.getText();
    }

    public String getUsername() {
        return this.txtUsername.getText();
    }

    public String getConnectionName() {
        return this.txtConnectionName.getText();
    }

    public boolean isSecure() {
        return this.fSecureBtn.getSelection();
    }
}

