/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.connection.wizard;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import miworkplace.common.IProductRegistry;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.ui.connection.wizard.ConnectionCustomLibraryListWizardPage;
import miworkplace.ui.connection.wizard.ConnectionLibrariesWizardPage;
import miworkplace.ui.connection.wizard.ConnectionWizardPage;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.log.LogService;

public class ConnectionWizard
extends Wizard
implements IWizard {
    public static final String ID = "miworkplace.ui.wizard.connection";
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private LogService logger;
    @Inject
    private IResourcePool imagePool;
    @Inject
    EHelpService fHelpService;
    @Inject
    IProductRegistry fProductRegistry;
    private ConnectionWizardPage wizPageConn = null;
    private ConnectionLibrariesWizardPage wizPageLibraries = null;
    private ConnectionCustomLibraryListWizardPage wizPageCustomLibraries = null;

    public ConnectionWizard() {
        this.setWindowTitle(Messages.ui_conn_wiz_title);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("/icons/server-wizard.png")));
    }

    @PostConstruct
    public void postConstruct() {
    }

    public static ControlDecoration addDecorator(Control control, String text) {
        ControlDecoration deco = new ControlDecoration(control, 16512);
        InputStream in = ConnectionWizard.class.getClassLoader().getResourceAsStream("/icons/information.gif");
        Image image = new Image((Device)control.getDisplay(), in);
        deco.setImage(image);
        control.addDisposeListener(e -> image.dispose());
        deco.setDescriptionText(text);
        deco.setShowOnlyOnFocus(false);
        return deco;
    }

    public boolean performFinish() {
        boolean retVal = true;
        if (this.wizPageConn.getServername().equals("")) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage(Messages.ui_conn_wiz_error_nohost);
            retVal = false;
        } else if (this.wizPageConn.getConnectionName().equals("")) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage(Messages.ui_conn_wiz_error_noconn);
            retVal = false;
        } else if (this.connectionManager.get(this.wizPageConn.getConnectionName()) != null) {
            ((WizardPage)this.getContainer().getCurrentPage()).setErrorMessage(Messages.ui_conn_wiz_error_duplicate);
            retVal = false;
        }
        if (retVal && retVal) {
            IConnection connection = null;
            try {
                connection = this.connectionManager.create(this.wizPageConn.getConnectionName(), this.wizPageConn.getServername(), this.wizPageConn.isSecure());
                if (connection == null) {
                    this.wizPageConn.setErrorMessage(Messages.ui_conn_wiz_error);
                    retVal = false;
                } else {
                    connection.setUsername(this.wizPageConn.getUsername());
                    connection.setListedLibraries(new HashSet<String>(this.wizPageLibraries.getListedLibraries()));
                    connection.setReplaceUserLibraryList(this.wizPageCustomLibraries.replaceLibraries());
                    connection.setCustomUserLibraries(new LinkedList<String>(this.wizPageCustomLibraries.getCustomLibraries()));
                    connection.setShowLibraryList(this.wizPageCustomLibraries.showLibraryList());
                    connection.setJobDescription(this.wizPageCustomLibraries.getJobDescription());
                    connection.setObjectLibrary(this.wizPageLibraries.getObjectLibrary());
                    this.connectionManager.update(connection);
                }
            }
            catch (Exception e) {
                this.logger.log(1, "Could not create server connection.", (Throwable)e);
                this.wizPageConn.setErrorMessage(Messages.ui_conn_wiz_error);
                retVal = false;
            }
        }
        return retVal;
    }

    public boolean canFinish() {
        return this.wizPageLibraries != null ? this.wizPageLibraries.isSeen() : true;
    }

    public void addPages() {
        if (this.fProductRegistry.listRegisteredProducts().size() != 1) {
            return;
        }
        this.wizPageConn = new ConnectionWizardPage(this.fHelpService);
        this.addPage((IWizardPage)this.wizPageConn);
        this.wizPageLibraries = new ConnectionLibrariesWizardPage(this.fHelpService);
        this.addPage((IWizardPage)this.wizPageLibraries);
        this.wizPageCustomLibraries = new ConnectionCustomLibraryListWizardPage(this.imagePool, this.fHelpService);
        this.addPage((IWizardPage)this.wizPageCustomLibraries);
    }
}

