/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.connection.wizard;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import miworkplace.i18n.Messages;
import miworkplace.ui.connection.wizard.ConnectionWizard;
import miworkplace.ui.widgets.LibraryList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConnectionLibrariesWizardPage
extends WizardPage {
    private List<String> libraries = new LinkedList<String>();
    private LibraryList fViewer;
    private boolean fIsSeen;
    private Text objectLibrary;
    private EHelpService fHelpService;

    public ConnectionLibrariesWizardPage(EHelpService pHelpService) {
        super(Messages.ui_conn_wiz_libs_page);
        this.fHelpService = pHelpService;
        this.setTitle(Messages.ui_conn_wiz_libs_title);
        this.setDescription(Messages.ui_conn_wiz_libs_desc);
    }

    public void createControl(Composite parent) {
        Composite controls = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 18;
        controls.setLayout((Layout)gridLayout);
        Label labelListedLibraries = new Label(controls, 0);
        labelListedLibraries.setText(Messages.ui_conn_wiz_libs_listed_libs);
        labelListedLibraries.setLayoutData((Object)GridDataFactory.defaultsFor((Control)labelListedLibraries).align(1, 1).create());
        this.fViewer = new LibraryList(controls, 2560);
        this.fViewer.setInput(this.libraries.toArray(new String[0]));
        this.fViewer.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        ConnectionWizard.addDecorator((Control)this.fViewer, Messages.ui_conn_wiz_libs_col_ttt);
        Label objectLibLabel = new Label(controls, 0);
        objectLibLabel.setText(Messages.common_objlib + ":");
        this.objectLibrary = new Text(controls, 2048);
        this.objectLibrary.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        ConnectionWizard.addDecorator((Control)this.objectLibrary, Messages.ui_conn_wiz_custom_objectlibrary);
        this.setControl((Control)controls);
    }

    public void performHelp() {
        this.fHelpService.displayHelp("miworkplace.help.MIW: Connections");
    }

    public boolean showAllLibraries() {
        return false;
    }

    public List<String> getListedLibraries() {
        return Arrays.asList(this.fViewer.getElements());
    }

    public void setVisible(boolean pVisible) {
        if (pVisible) {
            this.fIsSeen = true;
        }
        super.setVisible(pVisible);
    }

    public boolean isSeen() {
        return this.fIsSeen;
    }

    public String getObjectLibrary() {
        return StringUtils.substring((String)this.objectLibrary.getText().toUpperCase(), (int)0, (int)10);
    }
}

