/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.connection.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.ui.dialog.LoginDialog;
import miworkplace.ui.explorer.RemoteExplorer;
import miworkplace.ui.util.LibraryLoader;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;

public class OpenConnectionHandler {
    public static final String ID = "miworkplace.ui.handler.openConnection";
    @Inject
    private ESelectionService selectionService;
    @Inject
    private EPartService partService;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private MApplication application;
    @Inject
    private IWorkspaceStore workspaceStore;
    private IConnection connection;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection, @Optional @Named(value="miworkplace.ui.command.openConnection.parameter.connection") String connectionName, IEclipseContext context) {
        Object firstElement;
        if (connectionName != null) {
            return true;
        }
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof IConnection) {
            return !((IConnection)firstElement).isConnected();
        }
        return false;
    }

    @Execute
    public void run(@Named(value="activeShell") Shell shell, @Optional @Named(value="miworkplace.ui.command.openConnection.parameter.connection") String connectionName, IEclipseContext context) {
        RemoteExplorer remoteExplorer = (RemoteExplorer)this.partService.findPart("miworkplace.ui.explorer").getObject();
        if (connectionName != null) {
            this.connection = this.connectionManager.get(connectionName);
        } else {
            Object selection = this.selectionService.getSelection("miworkplace.ui.explorer");
            if (selection != null && selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)selection;
                Object element = ss.getFirstElement();
                if (element != null && element instanceof IConnection) {
                    this.connection = (IConnection)element;
                } else if (element != null && element instanceof IRemoteObject) {
                    this.connection = ((IRemoteObject)element).getConnection();
                }
            }
        }
        IEclipseContext activeChild = this.application.getContext().getActiveChild();
        this.workspaceStore.clear(this.connection);
        LoginDialog dialog = new LoginDialog(shell, this.connection);
        int openCode = dialog.open();
        activeChild.setParent(this.application.getContext());
        activeChild.activateBranch();
        if (openCode == 0) {
            LibraryLoader loader = (LibraryLoader)((Object)ContextInjectionFactory.make(LibraryLoader.class, (IEclipseContext)context));
            loader.setConnection(this.connection);
            loader.setSourceId(remoteExplorer.getSourceId());
            loader.schedule();
        }
    }
}

