/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.connection.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class DeleteConnectionHandler {
    @Inject
    private LogService logger;
    @Inject
    private IConnectionManager connectionManager;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        Object firstElement;
        boolean canExecute = false;
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof IConnection) {
            return !((IConnection)firstElement).isConnected();
        }
        return canExecute;
    }

    @Execute
    public void run(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        for (Object element : selection) {
            IConnection conn;
            MessageDialog dialog;
            if (element == null || !(element instanceof IConnection) || (dialog = new MessageDialog(shell, Messages.common_dialog_confirm, null, String.format(Messages.ui_conn_handler_delete_prompt, (conn = (IConnection)element).getName()), 3, new String[]{Messages.common_yes, Messages.common_no}, 0)).open() != 0) continue;
            try {
                conn.disconnect();
                this.connectionManager.delete(conn.getName());
            }
            catch (Exception e) {
                this.logger.log(1, "Could not delete connection " + conn.getName() + ". Cause: " + e.getMessage());
            }
        }
    }
}

