/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.compile;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Command;
import com.ibm.as400.access.QSYSObjectPathName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import miworkplace.commands.core.Cmd;
import miworkplace.commands.core.CommandParser;
import miworkplace.commands.core.Parm;
import miworkplace.commands.core.QcdCLCmd;
import miworkplace.commands.core.Value;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.ui.compile.CommandParameter;
import miworkplace.ui.compile.CommandParameterOption;

public class RemoteCommandParser {
    private static Debug logger = Debug.getInstance();

    public static List<CommandParameter> loadCommandParameters(IConnection connection, String command) {
        if (connection == null || command == null) {
            logger.debug((Option)miworkplace.ui.debug.Option.compile, "Connection = " + String.valueOf(connection) + " Command=" + command);
            return Collections.emptyList();
        }
        if (connection.isConnected()) {
            try {
                AS400 system = connection.getSystem();
                QSYSObjectPathName path = new QSYSObjectPathName("%LIBL%", command, "CMD");
                Command cmd = new Command(system, path.getPath());
                QcdCLCmd clCmd = new CommandParser().parse(cmd.getXML());
                ArrayList<CommandParameter> result = new ArrayList<CommandParameter>();
                if (clCmd != null) {
                    for (Parm parm : ((Cmd)clCmd.getCommands().get(0)).getParms()) {
                        CommandParameter p = new CommandParameter();
                        p.description = parm.getChoices();
                        p.keyword = parm.getKeyWord();
                        p.name = parm.getPrompt();
                        parm.getSpecialValues().forEach(special -> {
                            List<CommandParameterOption> list = RemoteCommandParser.getOptions(special.getValues());
                        });
                        parm.getValues().forEach(values -> {
                            List<CommandParameterOption> list = RemoteCommandParser.getOptions(values.getValues());
                        });
                        result.add(p);
                    }
                }
                return result;
            }
            catch (Exception e) {
                logger.error((Option)miworkplace.ui.debug.Option.compile, e.getMessage(), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private static List<CommandParameterOption> getOptions(List<Value> pValues) {
        ArrayList<CommandParameterOption> result = new ArrayList<CommandParameterOption>();
        for (Value value : pValues) {
            CommandParameterOption option = new CommandParameterOption();
            option.description = value.getValue();
            option.option = value.getValue();
            option.placeholder = true;
            result.add(option);
        }
        return result;
    }
}

