/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.compile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.RemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.ui.Constants;
import miworkplace.ui.compile.CompileSettingsProvider;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.LogService;

public class PersistedCompileSettingsProvider
implements EventHandler,
CompileSettingsProvider {
    private LogService logger;
    private IWorkspaceStore workspaceStore;
    private IConnectionManager connectionManager;

    public void bindLogService(LogService logger) {
        this.logger = logger;
    }

    public void unbindLogService(LogService logger) {
        this.logger = null;
    }

    public void bindWorkspaceStore(IWorkspaceStore workspaceStore) {
        this.workspaceStore = workspaceStore;
    }

    public void unbindWorkspaceStore(IWorkspaceStore workspaceStore) {
        this.workspaceStore = null;
    }

    public void bindConnectionManager(IConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void unbindConnectionManager(IConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public void save(IRemoteObject remoteObject, Properties properties) {
        File f = this.getPropertiesFile(remoteObject);
        try {
            if (!f.exists()) {
                f.getParentFile().mkdirs();
                f.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(f);
            properties.storeToXML((OutputStream)out, remoteObject.getName(), "UTF-8");
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            this.logger.log(2, "Could not save compile settings for " + remoteObject.getName() + ". Error: " + e.getMessage());
        }
    }

    @Override
    public Properties get(IRemoteObject remoteObject) {
        return this.get(remoteObject.getName(), remoteObject.escapedPath());
    }

    private Properties get(String name, String escapedPath) {
        File f = this.getPropertiesFile(escapedPath);
        Properties properties = new Properties();
        try {
            if (!f.exists()) {
                f.getParentFile().mkdirs();
                f.createNewFile();
                FileOutputStream out = new FileOutputStream(f);
                properties.storeToXML((OutputStream)out, name, "UTF-8");
                out.flush();
            }
            properties.loadFromXML(new FileInputStream(f));
            return properties;
        }
        catch (Exception e) {
            this.logger.log(2, "Could not load compile settings for " + name + ". Error: " + e.getMessage());
            return null;
        }
    }

    private File getPropertiesFile(IRemoteObject remoteObject) {
        return this.getPropertiesFile(remoteObject.escapedPath());
    }

    private File getPropertiesFile(String escapedPath) {
        Bundle bundle = Platform.getBundle((String)Constants.PLUGIN_ID);
        IPath bundleStateLocation = Platform.getStateLocation((Bundle)bundle);
        IPath compileSettingsPath = bundleStateLocation.append("compilers").append(escapedPath);
        File f = compileSettingsPath.toFile();
        return f;
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("miworkplace/member/created")) {
            if (event.containsProperty("source.member")) {
                SourceMember oldMember = (SourceMember)event.getProperty("source.member");
                SourceMember newMember = (SourceMember)event.getProperty("org.eclipse.e4.data");
                File file = this.getPropertiesFile((IRemoteObject)oldMember);
                if (file.exists()) {
                    Properties properties = this.get((IRemoteObject)oldMember);
                    this.save((IRemoteObject)newMember, properties);
                }
            }
        } else if (event.getTopic().equals("miworkplace/member/renamed")) {
            SourceMember oldMember = (SourceMember)event.getProperty("old.member");
            SourceMember newMember = (SourceMember)event.getProperty("new.member");
            File file = this.getPropertiesFile((IRemoteObject)oldMember);
            if (file.exists()) {
                String filePath = file.getParentFile().getAbsolutePath() + File.separator + newMember.escapedPath();
                File newFile = new File(filePath);
                file.renameTo(newFile);
            }
        } else if (event.getTopic().equals("miworkplace/member/deleted")) {
            SourceMember member = (SourceMember)event.getProperty("org.eclipse.e4.data");
            File file = this.getPropertiesFile((IRemoteObject)member);
            if (file.exists()) {
                file.delete();
            }
        } else if (event.getTopic().equals("miworkplace/member/moved")) {
            SourceMember oldMember = (SourceMember)event.getProperty("old.member");
            SourceMember newMember = (SourceMember)event.getProperty("new.member");
            Properties properties = this.get((IRemoteObject)oldMember);
            File file = this.getPropertiesFile((IRemoteObject)oldMember);
            if (file.exists()) {
                file.delete();
            }
            this.save((IRemoteObject)newMember, properties);
        } else if (event.getTopic().equals("miworkplace/object/created")) {
            Object value = event.getProperty("miworkplace.ui.source");
            if (value != null && ((IRemoteObject)value).getType() == IRemoteObject.Type.file) {
                IRemoteObject sourceFile = (IRemoteObject)value;
                IRemoteObject destFile = (IRemoteObject)event.getProperty("org.eclipse.e4.data");
                this.copyCompileSettings(sourceFile, destFile);
            }
        } else if (event.getTopic().equals("miworkplace/object/deleted")) {
            IRemoteObject file = (IRemoteObject)event.getProperty("org.eclipse.e4.data");
            if (file.getType() == IRemoteObject.Type.file) {
                this.deleteCompileSettings(file);
            }
        } else if (event.getTopic().equals("miworkplace/object/renamed")) {
            IRemoteObject oldObject = (IRemoteObject)event.getProperty("old.object");
            IRemoteObject newObject = (IRemoteObject)event.getProperty("new.object");
            if (oldObject.getType() == IRemoteObject.Type.file && IRemoteObject.Attribute.sourcefile == newObject.getAttribute()) {
                this.copyCompileSettings(oldObject, newObject);
                this.deleteCompileSettings(oldObject);
            }
        } else if (event.getTopic().equals("miworkplace/streamfile/deleted")) {
            IRemoteObject deletedStreamFile = (IRemoteObject)event.getProperty("org.eclipse.e4.data");
            this.deleteCompileSettings(deletedStreamFile);
        } else if (event.getTopic().equals("miworkplace/streamfile/moved")) {
            String newPath = event.getProperty("new.file.path").toString();
            String oldParentPath = event.getProperty("old.parent.file.path").toString();
            String oldPath = oldParentPath + "/" + FilenameUtils.getName((String)newPath);
            IConnection connection = this.connectionManager.get(event.getProperty("connection").toString());
            IRemoteObject newStreamFile = this.workspaceStore.get(connection, newPath);
            String oldEscapedPath = RemoteObject.escapedPath((String)connection.getName(), (String)oldPath);
            Properties properties = this.get(FilenameUtils.getName((String)newPath), oldEscapedPath);
            File file = this.getPropertiesFile(oldEscapedPath);
            if (file.exists()) {
                file.delete();
            }
            this.save(newStreamFile, properties);
        } else if (event.getTopic().equals("miworkplace/streamfile/renamed")) {
            String oldPath = event.getProperty("old.file.path").toString();
            String newPath = event.getProperty("new.file.path").toString();
            IConnection connection = this.connectionManager.get(event.getProperty("connection").toString());
            IRemoteObject newStreamFile = this.workspaceStore.get(connection, newPath);
            String oldEscapedPath = RemoteObject.escapedPath((String)connection.getName(), (String)oldPath);
            File file = this.getPropertiesFile(oldEscapedPath);
            if (file.exists()) {
                String filePath = file.getParentFile().getAbsolutePath() + File.separator + newStreamFile.escapedPath();
                File newFile = new File(filePath);
                file.renameTo(newFile);
            }
        } else {
            event.getTopic().equals("miworkplace/streamfile/created");
        }
    }

    private void deleteCompileSettings(IRemoteObject file) {
        File[] files = this.getSettingsFiles(file);
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.exists()) {
                    f.delete();
                }
                ++n2;
            }
        }
    }

    private File[] getSettingsFiles(IRemoteObject sourceFile) {
        final String escapedSourcePath = sourceFile.escapedPath();
        Bundle bundle = Platform.getBundle((String)Constants.PLUGIN_ID);
        IPath bundleStateLocation = Platform.getStateLocation((Bundle)bundle);
        IPath compileSettingsPath = bundleStateLocation.append("compilers");
        File compileSettingsFolder = compileSettingsPath.toFile();
        File[] files = compileSettingsFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.startsWith(escapedSourcePath);
            }
        });
        return files;
    }

    private void copyCompileSettings(IRemoteObject sourceFile, IRemoteObject destFile) {
        String escapedSourcePath = sourceFile.escapedPath();
        String escapedDestPath = destFile.escapedPath();
        File[] files = this.getSettingsFiles(sourceFile);
        if (files == null || files.length == 0) {
            return;
        }
        String destFolder = files[0].getParentFile().getAbsolutePath();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String newFilePath = destFolder + File.separator + file.getName().replace(escapedSourcePath, escapedDestPath);
            try {
                FileWriter out = new FileWriter(newFilePath);
                IOUtils.copy((Reader)new FileReader(file), (Writer)out);
                out.flush();
                out.close();
            }
            catch (IOException ioe) {
                this.logger.log(1, "Could not copy compile settings " + file.getName() + ". Error: " + ioe.getMessage());
            }
            ++n2;
        }
    }
}

