/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.compile;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.ui.api.ICompileCommandBuilder;
import miworkplace.ui.api.IRemoteEditor;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class DisplayCompileCommandHandler {
    @Inject
    private LogService logger;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private ICompileCommandBuilder compileCommandBuilder;
    @Inject
    private IObjectPropertiesStore propertiesStore;

    @Execute
    public void execute(@Optional @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, @Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell) {
        MessageDialog dialog;
        IRemoteObject sourceObject = null;
        IConnection connection = null;
        if (part != null && part.getObject() instanceof IRemoteEditor) {
            String inputUri = ((IRemoteEditor)part.getObject()).getInputUri();
            String connectionName = EditorInputUriUtil.getConnectionName((String)inputUri);
            connection = this.connectionManager.get(connectionName);
            String memberPath = EditorInputUriUtil.getMemberPath((String)inputUri);
            sourceObject = this.workspaceStore.get(connection, memberPath);
        } else {
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IRemoteObject) {
                sourceObject = (IRemoteObject)firstElement;
                connection = sourceObject.getConnection();
            }
        }
        this.propertiesStore.get(sourceObject, true);
        this.logger.log(4, "Compiling using connection " + connection.getName());
        this.logger.log(4, "Compiling source " + sourceObject.getPath());
        try {
            String command = this.compileCommandBuilder.buildCommand(sourceObject);
            this.logger.log(4, "Using compile command: " + command);
            dialog = new MessageDialog(shell, Messages.ui_compile_handler_display_title, null, String.format(Messages.ui_compile_handler_display_command, sourceObject.getName(), command), 0, new String[]{Messages.common_copy, Messages.common_ok}, 1);
            int buttonIndex = dialog.open();
            if (buttonIndex == 0) {
                Clipboard cb = new Clipboard(Display.getCurrent());
                TextTransfer textTransfer = TextTransfer.getInstance();
                cb.setContents(new Object[]{command}, new Transfer[]{textTransfer});
            }
        }
        catch (RuntimeException re) {
            dialog = new MessageDialog(shell, Messages.ui_compile_handler_display_title, null, re.getMessage(), 0, new String[]{Messages.common_ok}, 0);
            dialog.open();
        }
    }
}

