/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.compile;

import com.remainsoftware.common.ui.util.UiUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.ui.api.ICompileResultService;
import miworkplace.ui.compile.CompileResult;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class CompileResultService
implements ICompileResultService,
EventHandler {
    private PropertyChangeSupport compileResultChangeNotifier = new PropertyChangeSupport(this);
    private HashMap<String, CompileResult> compileResults = new HashMap();

    @Override
    public void addCompileResult(String ifsPath, CompileResult compileResult) {
        try {
            EPartService partService = UiUtils.getPartService();
            MPart compileResultViewPart = partService.findPart("miworkplace.ui.part.compileresult");
            if (compileResultViewPart == null) {
                compileResultViewPart = partService.createPart("miworkplace.ui.part.compileresult");
                partService.showPart(compileResultViewPart, EPartService.PartState.ACTIVATE);
            } else {
                partService.activate(compileResultViewPart, true);
            }
            CompileResult oldValue = this.compileResults.get(ifsPath);
            this.compileResults.put(ifsPath, compileResult);
            this.compileResultChangeNotifier.firePropertyChange("new compile result", oldValue, compileResult);
        }
        catch (IllegalStateException e) {
            Debug.getInstance().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void deleteCompileResult(String ifsPath) {
        CompileResult result = this.compileResults.get(ifsPath);
        this.compileResults.remove(ifsPath);
        this.compileResultChangeNotifier.firePropertyChange("delete compile result", result, null);
    }

    @Override
    public CompileResult getCompileResult(String ifsPath) {
        return this.compileResults.get(ifsPath);
    }

    @Override
    public void removeByConnection(IConnection connection) {
        HashMap<String, CompileResult> localMap = new HashMap<String, CompileResult>(this.compileResults);
        Set<Map.Entry<String, CompileResult>> set = localMap.entrySet();
        for (Map.Entry<String, CompileResult> entry : set) {
            if (!entry.getValue().getSource().getConnection().equals(connection)) continue;
            this.compileResults.remove(entry.getKey());
        }
    }

    @Override
    public void addCompileResultListener(PropertyChangeListener listener) {
        this.compileResultChangeNotifier.addPropertyChangeListener(listener);
    }

    @Override
    public void removeCompileResultListener(PropertyChangeListener listener) {
        this.compileResultChangeNotifier.removePropertyChangeListener(listener);
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("miworkplace/connection/disconnected")) {
            IConnection connection = (IConnection)event.getProperty("org.eclipse.e4.data");
            this.removeByConnection(connection);
        }
    }
}

