/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.compile;

import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.text.MessageFormat;
import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.Constants;
import miworkplace.ui.api.EventFile;
import miworkplace.ui.api.EventFileEntry;
import miworkplace.ui.api.ICompileResultService;
import miworkplace.ui.api.IEventFileLoader;
import miworkplace.ui.compile.CompileResult;
import miworkplace.ui.eventfile.NoEventFileException;
import miworkplace.ui.parser.CommandParameter;
import miworkplace.ui.parser.CommandParameterParser;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class CompileJob
extends Job {
    private static final String OBJ = "OBJ";
    private static final String MODULE = "MODULE";
    private static final String QGPL = "QGPL";
    private static final String PGM = "PGM";
    private static final String CURLIB = "*CURLIB";
    private static final String FILE = "FILE";
    private static final String EVFEVENT = "EVFEVENT";
    @Inject
    private UISynchronize sync;
    private Debug logger = Debug.getInstance();
    @Inject
    private IConnectionUtilities connUtil;
    @Inject
    private ICompileResultService compileResultService;
    @Inject
    private IEventFileLoader eventFileLoader;
    @Inject
    @Named(value="compile.command")
    private String command;
    @Inject
    private IRemoteObject sourceObject;
    @Inject
    private EPartService fPartService;

    public CompileJob() {
        super("Compile");
        this.setPriority(20);
    }

    @PostConstruct
    public void postConstruct() {
        this.setName(String.format(Messages.ui_compile_job_name, this.sourceObject.getName()));
    }

    protected IStatus run(IProgressMonitor monitor) {
        IConnection connection = this.sourceObject.getConnection();
        boolean compileSuccess = true;
        EventFileEntry notCreated = null;
        try {
            this.connUtil.executeRemoteCommand(connection, this.command);
        }
        catch (Exception e) {
            compileSuccess = false;
            notCreated = this.createNotCreatedEventEntry(e);
            this.logger.error("Error during compilation of " + this.sourceObject.getName(), (Throwable)e);
            this.sync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MPart part = CompileJob.this.fPartService.findPart("miworkplace.ui.part.compileresult");
                    if (part != null) {
                        CompileJob.this.fPartService.activate(part, false);
                    }
                    Notifier.error((String)Messages.ui_compile_notify_title, (String)e.getLocalizedMessage());
                }
            });
        }
        try {
            String eventFileLibrary = this.retrieveEventFileLibrary(this.sourceObject, this.command.toString());
            QSYSObjectPathName eventFilePath = null;
            if (this.sourceObject instanceof SourceMember) {
                eventFilePath = new QSYSObjectPathName(this.sourceObject.getPath());
                eventFilePath.setObjectName(EVFEVENT);
                eventFilePath.setLibraryName(eventFileLibrary);
            } else if (this.sourceObject instanceof StreamFile) {
                eventFilePath = new QSYSObjectPathName();
                eventFilePath.setLibraryName(eventFileLibrary);
                eventFilePath.setObjectName(EVFEVENT);
                eventFilePath.setObjectType(FILE);
                eventFilePath.setMemberName(FilenameUtils.getBaseName((String)this.sourceObject.getPath()));
            }
            if (eventFilePath.getLibraryName() == null || eventFilePath.getLibraryName().trim().isEmpty()) {
                this.sendEventFileCleanMessage(compileSuccess);
                return Status.OK_STATUS;
            }
            EventFile eventFile = this.eventFileLoader.loadEventFile(this.sourceObject.getConnection(), eventFilePath.getPath());
            CompileResult result = new CompileResult(eventFile);
            result.setMember(this.sourceObject);
            if (!compileSuccess && !result.hasErrors() && notCreated != null) {
                eventFile.addFile(this.sourceObject.getName().hashCode(), this.sourceObject.getPath());
                notCreated.setEventFile(eventFile);
                notCreated.setFileId(this.sourceObject.getName().hashCode());
                result.addEntry(notCreated);
            }
            this.sync.asyncExec(() -> this.compileResultService.addCompileResult(this.sourceObject.getPath(), result));
            if (!result.hasErrors()) {
                this.sendEventFileCleanMessage(compileSuccess);
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            this.logger.error("Error retrieving event file content.", (Throwable)e);
            if (compileSuccess) {
                this.eventFileIssueCompileSuccess(e);
                return Status.OK_STATUS;
            }
            this.eventFileIssueCompileFail(e);
            return new Status(2, Constants.PLUGIN_ID, Messages.ui_compile_job_result_error);
        }
    }

    private EventFileEntry createNotCreatedEventEntry(Exception e) {
        EventFileEntry notCreated = new EventFileEntry();
        notCreated.setMessage(e.getMessage() + " See spoolfile or joblog for more information.");
        notCreated.setSeverityCode("E");
        notCreated.setSeverityLevel(30);
        notCreated.setColumnEnd(1);
        notCreated.setColumnStart(1);
        notCreated.setMessageId("CPF9898");
        return notCreated;
    }

    private void sendEventFileCleanMessage(final boolean compileSuccess) {
        if (!compileSuccess) {
            return;
        }
        final String message = String.format(Messages.ui_compile_job_ok, this.sourceObject.getName()) + (compileSuccess ? "" : Messages.ui_compile_issues);
        this.sync.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (compileSuccess) {
                    Notifier.info((String)Messages.ui_compile_notify_title, (String)message);
                } else {
                    Notifier.warn((String)Messages.ui_compile_notify_title, (String)message);
                }
            }
        });
    }

    private void eventFileIssueCompileSuccess(final Exception e) {
        this.sync.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (e instanceof NoEventFileException) {
                    Notifier.warn((String)String.format(Messages.ui_compile_job_ok, CompileJob.this.sourceObject.getName()), (String)e.getMessage());
                } else {
                    Notifier.warn((String)String.format(Messages.ui_compile_job_ok, CompileJob.this.sourceObject.getName()), (String)Messages.ui_compile_job_result_error);
                }
            }
        });
    }

    private void eventFileIssueCompileFail(final Exception e) {
        this.sync.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (e instanceof NoEventFileException) {
                    Notifier.warn((String)Messages.ui_compile_job_result_notify_title, (String)e.getMessage());
                } else {
                    Notifier.error((String)Messages.ui_compile_job_result_notify_title, (String)Messages.ui_compile_job_result_error);
                }
            }
        });
    }

    public boolean belongsTo(Object family) {
        return this.sourceObject.getConnection().getName().equals(family);
    }

    private String retrieveEventFileLibrary(IRemoteObject source, String command) {
        String buildOptions;
        String library = CURLIB;
        String[] commandParts = command.split(" ", 2);
        library = this.getEventFileLibraryByCommandName(commandParts[0], buildOptions = commandParts[1]);
        if (library == null && !StringUtils.isEmpty((CharSequence)source.getConnection().getObjectLibrary())) {
            library = source.getConnection().getObjectLibrary();
        } else if (library == null && source instanceof SourceMember) {
            library = ((SourceMember)source).getLibrary();
        }
        if (library == null || library.equals(CURLIB)) {
            return this.connUtil.getCurrentLibrary(source.getConnection());
        }
        this.logger.debug((Option)miworkplace.ui.debug.Option.compile, MessageFormat.format("Event file library for compilation of {0} is {1}.", source.getName(), library));
        return library;
    }

    private String getEventFileLibraryByCommandName(String command, String buildOptions) {
        List<CommandParameter> parameters = new CommandParameterParser().parse(buildOptions.trim());
        command = command.trim().toUpperCase();
        String outputValue = null;
        if (command.equals("CRTBNDCL")) {
            outputValue = this.getOutputParameter(parameters, PGM);
        } else if (command.equals("CRTBNDRPG")) {
            outputValue = this.getOutputParameter(parameters, PGM);
        } else if (command.equals("CRTRPGMOD")) {
            outputValue = this.getOutputParameter(parameters, MODULE);
        } else if (command.equals("CRTCLMOD")) {
            outputValue = this.getOutputParameter(parameters, MODULE);
        } else if (command.equals("CRTSQLRPG")) {
            outputValue = this.getOutputParameter(parameters, PGM);
        } else if (command.equals("CRTSQLRPGI")) {
            outputValue = this.getOutputParameter(parameters, OBJ);
        } else if (command.equals("RUCRTTST")) {
            outputValue = this.getOutputParameter(parameters, "TSTPGM");
        } else {
            outputValue = this.getOutputParameter(parameters, PGM);
            if (outputValue == null && (outputValue = this.getOutputParameter(parameters, MODULE)) == null) {
                outputValue = this.getOutputParameter(parameters, OBJ);
            }
        }
        if (outputValue == null && parameters.size() > 0 && parameters.get((int)0).key == null) {
            outputValue = parameters.get((int)0).value;
        }
        if (outputValue == null) {
            String msg = "Could not determine library for the event file from the command: " + command + " " + buildOptions;
            this.logger.debug((Option)miworkplace.ui.debug.Option.compile, msg, (Throwable)new RuntimeException(msg));
            this.logger.debug((Option)miworkplace.ui.debug.Option.compile, "The above stack is debug output only.");
            return null;
        }
        if (outputValue.contains("/")) {
            String[] parameterValueParts = outputValue.split("/", 2);
            return parameterValueParts[0];
        }
        return null;
    }

    private String getOutputParameter(List<CommandParameter> parameters, String key) {
        for (CommandParameter p : parameters) {
            if (p.key == null || !p.key.equalsIgnoreCase(key)) continue;
            return p.value;
        }
        return null;
    }
}

