/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.connection.impl;

import com.remainsoftware.common.util.ServiceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import miworkplace.common.IProductRegistry;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.connection.impl.Connection;
import miworkplace.i18n.Messages;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ConnectionManager
implements IConnectionManager {
    private static final String SLASH = "/";
    private static final String PLUGIN_ID = "miworkplace.connection";
    private static final String PERSISTED_PROPERTY_NAME = "name";
    private static final String PERSISTED_PROPERTY_SYSTEM_NAME = "systemname";
    private static final String PERSISTED_PROPERTY_SECURE = "secure";
    private static final String PERSISTED_PROPERTY_USER_NAME = "username";
    private static final String PERSISTED_PROPERTY_SHOW_LIBRARY_LIST = "showLibraryList";
    private static final String PERSISTED_PROPERTY_SHOW_ALL_LIBRARIES = "showAllLibraries";
    private static final String PERSISTED_PROPERTY_LISTED_LIBRARIES = "libraries";
    private static final String PERSISTED_SEPARATOR_LIBRARIES = ",";
    private static final String PERSISTED_PROPERTY_REPLACE_LIBRARY_LIST = "replaceUserLibraryList";
    private static final String PERSISTED_PROPERTY_CUSTOM_LIBRARY_LIST = "customUserLibraryList";
    private static final String PERSISTED_PROPERTY_JOB_DESCRIPTION = "jobDescription";
    private static final String PERSISTED_PROPERTY_OBJECT_LIBRARY = "objectLibrary";
    private Map<String, IConnection> connections = new HashMap<String, IConnection>();
    private Debug logger = Debug.getInstance();
    private EventAdmin eventAdmin;

    public void activate(BundleContext context) {
        this.logger.info((Option)miworkplace.connection.debug.Option.connection, "Activating connection manager");
        this.loadConnections();
    }

    void bindEventService(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    void unbindEventService(EventAdmin eventAdmin) {
        eventAdmin = null;
    }

    private void loadConnections() {
        try {
            try {
                String[] connNames;
                String[] stringArray = connNames = InstanceScope.INSTANCE.getNode(PLUGIN_ID).childrenNames();
                int n = connNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String connName = stringArray[n2];
                    IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("miworkplace.connection/" + connName);
                    Connection conn = new Connection(preferences.get(PERSISTED_PROPERTY_NAME, "default"), preferences.get(PERSISTED_PROPERTY_SYSTEM_NAME, "ibm_i"), preferences.getBoolean(PERSISTED_PROPERTY_SECURE, false));
                    if (Arrays.asList(preferences.keys()).contains(PERSISTED_PROPERTY_USER_NAME)) {
                        conn.setUsername(preferences.get(PERSISTED_PROPERTY_USER_NAME, null));
                    }
                    conn.setShowAllLibraries(preferences.getBoolean(PERSISTED_PROPERTY_SHOW_ALL_LIBRARIES, false));
                    conn.setShowLibraryList(preferences.getBoolean(PERSISTED_PROPERTY_SHOW_LIBRARY_LIST, true));
                    conn.setListedLibraries(new HashSet<String>(Arrays.asList(StringUtils.split((String)preferences.get(PERSISTED_PROPERTY_LISTED_LIBRARIES, ""), (String)PERSISTED_SEPARATOR_LIBRARIES))));
                    conn.setReplaceUserLibraryList(preferences.getBoolean(PERSISTED_PROPERTY_REPLACE_LIBRARY_LIST, false));
                    conn.setCustomUserLibraries(new LinkedList<String>(Arrays.asList(StringUtils.split((String)preferences.get(PERSISTED_PROPERTY_CUSTOM_LIBRARY_LIST, ""), (String)PERSISTED_SEPARATOR_LIBRARIES))));
                    conn.setJobDescription(preferences.get(PERSISTED_PROPERTY_JOB_DESCRIPTION, null));
                    conn.setObjectLibrary(preferences.get(PERSISTED_PROPERTY_OBJECT_LIBRARY, null));
                    conn.setEventAdmin(this.eventAdmin);
                    this.connections.put(conn.getName(), conn);
                    ++n2;
                }
            }
            catch (BackingStoreException e) {
                this.logger.error("Could not load connections.", (Throwable)e);
                this.postEvent("miworkplace/connection/loaded");
            }
        }
        finally {
            this.postEvent("miworkplace/connection/loaded");
        }
    }

    @Override
    public IConnection create(String name, String systemName, boolean secure) {
        IProductRegistry registry = (IProductRegistry)ServiceUtils.getOSGiService(this.getClass(), IProductRegistry.class);
        if (registry == null || registry.listRegisteredProducts().size() == 0) {
            return null;
        }
        if (this.connections.containsKey(name)) {
            throw new RuntimeException(String.format(Messages.connmgr_unique_conn, name));
        }
        Connection conn = new Connection(name, systemName, secure);
        conn.setEventAdmin(this.eventAdmin);
        this.connections.put(name, conn);
        try {
            ConnectionManager.persist(conn);
            this.postEvent("miworkplace/connection/created", conn);
        }
        catch (BackingStoreException bse) {
            throw new RuntimeException(bse);
        }
        return conn;
    }

    @Override
    public IConnection get(String name) {
        return this.connections.get(name);
    }

    @Override
    public void delete(String name) {
        IConnection conn = this.get(name);
        if (conn == null) {
            this.logger.error((Option)miworkplace.connection.debug.Option.connection, "A connection with name " + name + " was not found.");
            return;
        }
        if (conn.isConnected()) {
            try {
                conn.disconnect();
            }
            catch (Exception exception) {}
        }
        this.connections.remove(name);
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("miworkplace.connection/" + conn.getName());
        try {
            Preferences parent = preferences.parent();
            preferences.removeNode();
            parent.flush();
            parent.sync();
            this.postEvent("miworkplace/connection/deleted", conn);
        }
        catch (BackingStoreException e) {
            this.logger.error("Could not delete connection " + conn.getName() + ".", (Throwable)e);
        }
    }

    @Override
    public List<IConnection> list() {
        return new ArrayList<IConnection>(this.connections.values());
    }

    @Override
    public void update(IConnection conn) {
        try {
            ConnectionManager.persist(conn);
            this.postEvent("miworkplace/connection/changed", conn);
        }
        catch (BackingStoreException e) {
            RuntimeException re = new RuntimeException(String.format(Messages.connmgr_persist_error, conn.getName()), e);
            this.logger.error("Could not persist connection " + conn.getName() + ".", (Throwable)re);
        }
    }

    private static void persist(IConnection conn) throws BackingStoreException {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("miworkplace.connection/" + conn.getName());
        preferences.clear();
        preferences.put(PERSISTED_PROPERTY_NAME, conn.getName());
        preferences.put(PERSISTED_PROPERTY_SYSTEM_NAME, conn.getSystemName());
        preferences.putBoolean(PERSISTED_PROPERTY_SECURE, conn.isSecure());
        if (conn.getUsername() != null) {
            preferences.put(PERSISTED_PROPERTY_USER_NAME, conn.getUsername());
        }
        preferences.put(PERSISTED_PROPERTY_SHOW_ALL_LIBRARIES, String.valueOf(conn.showAllLibraries()));
        preferences.put(PERSISTED_PROPERTY_SHOW_LIBRARY_LIST, String.valueOf(conn.showLibraryList()));
        preferences.put(PERSISTED_PROPERTY_LISTED_LIBRARIES, StringUtils.join((Iterable)conn.getListedLibraries(), (String)PERSISTED_SEPARATOR_LIBRARIES));
        preferences.put(PERSISTED_PROPERTY_REPLACE_LIBRARY_LIST, String.valueOf(conn.isReplaceUserLibraryList()));
        preferences.put(PERSISTED_PROPERTY_CUSTOM_LIBRARY_LIST, StringUtils.join((Iterable)conn.getCustomUserLibraries(), (String)PERSISTED_SEPARATOR_LIBRARIES));
        if (conn.getJobDescription() != null) {
            preferences.put(PERSISTED_PROPERTY_JOB_DESCRIPTION, conn.getJobDescription());
        }
        if (conn.getObjectLibrary() != null) {
            preferences.put(PERSISTED_PROPERTY_OBJECT_LIBRARY, conn.getObjectLibrary());
        }
        preferences.flush();
    }

    private void postEvent(String topic) {
        this.postEvent(topic, null);
    }

    private void postEvent(String topic, Object conn) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("org.eclipse.e4.data", conn);
        Event event = new Event(topic, map);
        this.eventAdmin.postEvent(event);
    }

    @Override
    public String getPreference(IConnection connection, String key, String defaultValue) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("miworkplace.connection/" + connection.getName());
        return preferences.get(key, defaultValue);
    }

    @Override
    public void setPreference(IConnection connection, String key, String value) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("miworkplace.connection/" + connection.getName());
        if (value == null) {
            preferences.remove(key);
        } else {
            preferences.put(key, value.toUpperCase());
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

